/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.layout.column;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.layout.column.AbstractColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItemImpl;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutStorageException;
import com.atlassian.jira.issue.fields.layout.column.EditableSearchRequestColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.EditableSearchRequestColumnLayoutImpl;
import com.atlassian.jira.issue.fields.layout.column.UserColumnLayoutImpl;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.util.map.CacheObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.LRUMap;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@EventComponent
public class DefaultColumnLayoutManager
extends AbstractColumnLayoutManager {
    private final Map<Long, CacheObject<GenericValue>> filterColumnlayoutCache;
    private final Map<Long, List<ColumnLayoutItem>> filterColumnLayoutItemCache;
    private FieldManager fieldManager;

    public DefaultColumnLayoutManager(FieldManager fieldManager, OfBizDelegator ofBizDelegator, UserKeyService userKeyService) {
        super(fieldManager, ofBizDelegator, userKeyService);
        this.fieldManager = fieldManager;
        this.filterColumnlayoutCache = Collections.synchronizedMap(new LRUMap(200));
        this.filterColumnLayoutItemCache = Collections.synchronizedMap(new LRUMap(200));
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }

    public ColumnLayout getColumnLayout(User remoteUser, SearchRequest searchRequest) throws ColumnLayoutStorageException {
        try {
            Set availableFields = this.getFieldManager().getAvailableNavigableFields(remoteUser);
            String username = remoteUser == null ? null : remoteUser.getName();
            AbstractColumnLayoutManager.CacheableColumnLayout cols = this.getColumnLayoutItems(username, searchRequest, availableFields);
            return new UserColumnLayoutImpl(cols.columnLayoutItems, remoteUser, cols.columnConfig);
        }
        catch (FieldException e) {
            throw new ColumnLayoutStorageException("Could not retrieve available fields.", (Throwable)e);
        }
    }

    protected AbstractColumnLayoutManager.CacheableColumnLayout getColumnLayoutItems(String username, SearchRequest searchRequest, Set<NavigableField> availableFields) {
        List<ColumnLayoutItem> columnLayoutItems;
        GenericValue columnLayoutGV;
        CacheObject<GenericValue> cacheObject = this.filterColumnlayoutCache.get(searchRequest.getId());
        if (cacheObject != null) {
            columnLayoutGV = cacheObject.getValue();
        } else {
            columnLayoutGV = this.fetchColumnLayout(searchRequest.getId());
            this.filterColumnlayoutCache.put(searchRequest.getId(), new CacheObject<GenericValue>(columnLayoutGV));
        }
        AbstractColumnLayoutManager.CacheableColumnLayout columnLayout = columnLayoutGV != null ? ((columnLayoutItems = this.filterColumnLayoutItemCache.get(searchRequest.getId())) != null ? new AbstractColumnLayoutManager.CacheableColumnLayout(ColumnLayout.ColumnConfig.FILTER, columnLayoutItems) : this.fetchFilterColumnLayout(searchRequest, availableFields, columnLayoutGV)) : super.getColumnLayout(username, availableFields);
        return columnLayout;
    }

    private AbstractColumnLayoutManager.CacheableColumnLayout fetchFilterColumnLayout(SearchRequest searchRequest, Set<NavigableField> availableFields, GenericValue columnLayoutGV) {
        AbstractColumnLayoutManager.CacheableColumnLayout columnLayout;
        try {
            List<ColumnLayoutItem> columnLayoutItems = this.verifyColumnLayoutItems(columnLayoutGV, availableFields);
            this.filterColumnLayoutItemCache.put(searchRequest.getId(), columnLayoutItems);
            columnLayout = new AbstractColumnLayoutManager.CacheableColumnLayout(ColumnLayout.ColumnConfig.FILTER, columnLayoutItems);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Could not retrieve the Column Layout Items.", (Throwable)e);
        }
        return columnLayout;
    }

    public EditableSearchRequestColumnLayout getEditableSearchRequestColumnLayout(User user, SearchRequest searchRequest) {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null.");
        }
        if (searchRequest == null) {
            throw new IllegalArgumentException("SearchRequest cannot be null.");
        }
        try {
            Set availableFields = this.getFieldManager().getAvailableNavigableFields(user);
            AbstractColumnLayoutManager.CacheableColumnLayout cols = this.getColumnLayoutItems(user.getName(), searchRequest, availableFields);
            return new EditableSearchRequestColumnLayoutImpl(cols.columnLayoutItems, user, searchRequest, cols.columnConfig);
        }
        catch (FieldException e) {
            throw new DataAccessException("Could not retrieve available fields for user '" + user.getName() + "'.", (Throwable)e);
        }
    }

    public void storeEditableSearchRequestColumnLayout(EditableSearchRequestColumnLayout editableSearchRequestColumnLayout) {
        Long filterId = editableSearchRequestColumnLayout.getSearchRequest().getId();
        this.storeFilterColumnLayout((ColumnLayout)editableSearchRequestColumnLayout, filterId);
        this.filterColumnlayoutCache.remove(filterId);
        this.filterColumnLayoutItemCache.remove(filterId);
    }

    private void storeFilterColumnLayout(ColumnLayout columnLayout, Long filterId) {
        try {
            GenericValue columnLayoutGV = this.fetchColumnLayout(filterId);
            if (columnLayoutGV == null) {
                columnLayoutGV = EntityUtils.createValue("ColumnLayout", EasyMap.build((Object)"username", null, (Object)"searchrequest", (Object)filterId));
            }
            this.storeColumnLayoutItems(columnLayoutGV, columnLayout);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Could not load ColumnLayout", (Throwable)e);
        }
    }

    private GenericValue fetchColumnLayout(Long filterId) {
        return EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("ColumnLayout", EasyMap.build((Object)"username", null, (Object)"searchrequest", (Object)filterId)));
    }

    public void restoreSearchRequestColumnLayout(SearchRequest searchRequest) throws ColumnLayoutStorageException {
        this.resetFilterColumnLayout(searchRequest.getId());
        this.filterColumnlayoutCache.remove(searchRequest.getId());
        this.filterColumnLayoutItemCache.remove(searchRequest.getId());
    }

    private void resetFilterColumnLayout(Long filterId) {
        try {
            GenericValue columnLayoutGV = this.fetchColumnLayout(filterId);
            if (columnLayoutGV != null) {
                this.removeColumnLayoutItems(columnLayoutGV);
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Error removing column layout for search request with id  '" + filterId + "'.", (Throwable)e);
        }
    }

    public boolean hasColumnLayout(SearchRequest searchRequest) {
        return this.hasColumnLayout(searchRequest.getId());
    }

    public boolean hasColumnLayout(Long filterId) {
        if (null == filterId) {
            return false;
        }
        GenericValue columnLayoutGV = null;
        CacheObject<GenericValue> cacheObject = this.filterColumnlayoutCache.get(filterId);
        if (cacheObject != null) {
            columnLayoutGV = cacheObject.getValue();
        } else {
            columnLayoutGV = this.fetchColumnLayout(filterId);
            this.filterColumnlayoutCache.put(filterId, new CacheObject<GenericValue>(columnLayoutGV));
        }
        return columnLayoutGV != null;
    }

    @Override
    public void refresh() {
        this.filterColumnlayoutCache.clear();
        this.filterColumnLayoutItemCache.clear();
        super.refresh();
    }

    public boolean hasColumnLayout(User user) {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null.");
        }
        return this.hasDefaultColumnLayout(user);
    }

    public boolean hasDefaultColumnLayout() throws ColumnLayoutStorageException {
        return this.hasDefaultColumnLayout(null);
    }

    @Override
    List<ColumnLayoutItem> removeUnavailableColumnLayoutItems(List<ColumnLayoutItem> columnLayoutItems, Set<NavigableField> availableFields) {
        ArrayList<ColumnLayoutItem> availableColumnLyaoutItems = new ArrayList<ColumnLayoutItem>();
        for (ColumnLayoutItem columnLayoutItem : columnLayoutItems) {
            if (!availableFields.contains(columnLayoutItem.getNavigableField())) continue;
            availableColumnLyaoutItems.add(columnLayoutItem);
        }
        return availableColumnLyaoutItems;
    }

    @Override
    List<ColumnLayoutItem> verifyColumnLayoutItems(GenericValue columnLayoutGV, Set<NavigableField> availableFields) throws GenericEntityException {
        ArrayList<ColumnLayoutItem> columnLayoutItems = new ArrayList<ColumnLayoutItem>();
        List columnLayoutItemGVs = columnLayoutGV.getRelatedOrderBy("ChildColumnLayoutItem", EasyList.build((Object)"horizontalposition ASC"));
        for (GenericValue columnLayoutItemGV : columnLayoutItemGVs) {
            if (!this.fieldManager.isNavigableField(columnLayoutItemGV.getString("fieldidentifier"))) continue;
            NavigableField navigableField = this.fieldManager.getNavigableField(columnLayoutItemGV.getString("fieldidentifier"));
            columnLayoutItems.add(new ColumnLayoutItemImpl(navigableField, columnLayoutItemGV.getLong("horizontalposition").intValue()));
        }
        return this.removeUnavailableColumnLayoutItems(columnLayoutItems, availableFields);
    }
}

