/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.AbstractOrderableNavigableFieldImpl;
import com.atlassian.jira.issue.fields.HideableField;
import com.atlassian.jira.issue.fields.LabelsField;
import com.atlassian.jira.issue.fields.RequirableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.LabelsRestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.RestFieldOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.util.MessagedResult;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.label.LabelManager;
import com.atlassian.jira.issue.label.LabelParser;
import com.atlassian.jira.issue.label.LabelUtil;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.handlers.LabelsSearchHandlerFactory;
import com.atlassian.jira.issue.statistics.TextFieldSorter;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.web.bean.BulkEditBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import webwork.action.Action;

public class LabelsSystemField
extends AbstractOrderableNavigableFieldImpl
implements HideableField,
RequirableField,
LabelsField,
RestAwareField,
RestFieldOperations {
    private static final LuceneFieldSorter SORTER = new TextFieldSorter("labels");
    private final LabelManager labelManager;
    private final IssueManager issueManager;
    private final JiraBaseUrls jiraBaseUrls;
    private LabelUtil labelUtil;

    public LabelsSystemField(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager, LabelsSearchHandlerFactory searchHandlerFactory, LabelManager labelManager, IssueManager issueManager, JiraBaseUrls jiraBaseUrls) {
        super("labels", "issue.field.labels", templatingEngine, applicationProperties, authenticationContext, permissionManager, searchHandlerFactory);
        this.labelManager = labelManager;
        this.issueManager = issueManager;
        this.jiraBaseUrls = jiraBaseUrls;
    }

    protected LabelUtil getLabelUtil() {
        if (this.labelUtil == null) {
            this.labelUtil = (LabelUtil)ComponentAccessor.getComponentOfType(LabelUtil.class);
        }
        return this.labelUtil;
    }

    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        return this.getEditHtml(fieldLayoutItem, operationContext, action, issue, displayParameters);
    }

    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        Map fieldValuesHolder = operationContext.getFieldValuesHolder();
        if (fieldValuesHolder.containsKey(this.getId())) {
            velocityParams.put("labels", fieldValuesHolder.get(this.getId()));
        } else if (issue != null && issue.getId() != null) {
            velocityParams.put("labels", this.labelManager.getLabels(issue.getId()));
        }
        return this.renderTemplate("labels-edit.vm", velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParameters = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        velocityParameters.put("labels", issue.getLabels());
        velocityParameters.put("canEdit", Boolean.FALSE);
        velocityParameters.put("fieldId", "label");
        velocityParameters.put("i18n", this.authenticationContext.getI18nHelper());
        velocityParameters.put("labelUtil", this.getLabelUtil());
        return this.renderTemplate("labels-view.vm", velocityParameters);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Object value, Map displayParameters) {
        Map<String, Object> velocityParameters = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        velocityParameters.put("canEdit", Boolean.FALSE);
        Set labels = value instanceof Set ? (Set)value : CollectionBuilder.newBuilder((Object[])new Label[]{new Label(null, issue.getId(), (String)value)}).asHashSet();
        velocityParameters.put("labels", labels);
        velocityParameters.put("fieldId", "label");
        velocityParameters.put("i18n", this.authenticationContext.getI18nHelper());
        velocityParameters.put("labelUtil", this.getLabelUtil());
        return this.renderTemplate("labels-view.vm", velocityParameters);
    }

    public Object getValueFromParams(Map params) {
        return params.get(this.getId());
    }

    public void populateParamsFromString(Map<String, Object> fieldValuesHolder, String stringValue, Issue issue) throws FieldValidationException {
        String[] labels = StringUtils.split((String)stringValue, (String)" ");
        if (labels != null) {
            LinkedHashSet<Label> labelSet = new LinkedHashSet<Label>();
            for (String label : labels) {
                labelSet.add(new Label(null, issue.getId(), label));
            }
            fieldValuesHolder.put(this.getId(), labelSet);
        }
    }

    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
        Set labels = (Set)this.getValueFromParams(fieldValueHolder);
        issue.setLabels(labels);
    }

    public void removeValueFromIssueObject(MutableIssue issue) {
        issue.setLabels(Collections.emptySet());
    }

    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return true;
    }

    public MessagedResult needsMove(Collection originalIssues, Issue targetIssue, FieldLayoutItem targetFieldLayoutItem) {
        for (Issue originalIssue : originalIssues) {
            if (!originalIssue.getLabels().isEmpty() || !targetFieldLayoutItem.isRequired()) continue;
            return new MessagedResult(true);
        }
        return new MessagedResult(false);
    }

    public void populateForMove(Map<String, Object> fieldValuesHolder, Issue originalIssue, Issue targetIssue) {
        fieldValuesHolder.put(this.getId(), originalIssue.getLabels());
    }

    public void populateFromIssue(Map<String, Object> fieldValuesHolder, Issue issue) {
        fieldValuesHolder.put(this.getId(), issue.getLabels());
    }

    public boolean hasValue(Issue issue) {
        return issue.getLabels().size() > 0;
    }

    public boolean isShown(Issue issue) {
        return true;
    }

    public void populateDefaults(Map<String, Object> fieldValuesHolder, Issue issue) {
        fieldValuesHolder.put(this.getId(), Collections.emptySet());
    }

    public void validateParams(OperationContext operationContext, ErrorCollection errorCollectionToAddTo, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        Map fieldValuesHolder = operationContext.getFieldValuesHolder();
        Set labels = (Set)fieldValuesHolder.get(this.getId());
        if (labels != null && !labels.isEmpty()) {
            for (Label theLabel : labels) {
                String label = theLabel.getLabel().trim();
                if (!LabelParser.isValidLabelName((String)label)) {
                    errorCollectionToAddTo.addError("labels", i18n.getText("label.service.error.label.invalid", label));
                } else {
                    if (label.length() <= 255) continue;
                    errorCollectionToAddTo.addError("labels", i18n.getText("label.service.error.label.toolong", label));
                }
                break;
            }
        } else if (fieldScreenRenderLayoutItem.isRequired()) {
            errorCollectionToAddTo.addError(this.getId(), i18n.getText("issue.field.required", i18n.getText(this.getNameKey())));
        }
    }

    public Object getDefaultValue(Issue issue) {
        return null;
    }

    public void createValue(Issue issue, Object value) {
        String labelString = (String)value;
        Set<String> labels = this.getLabelSet(labelString);
        this.labelManager.setLabels(this.authenticationContext.getLoggedInUser(), issue.getId(), labels, false, false);
    }

    public void updateValue(FieldLayoutItem fieldLayoutItem, Issue issue, ModifiedValue modifiedValue, IssueChangeHolder issueChangeHolder) {
        Set<String> labels;
        String oldLabelString = (String)modifiedValue.getOldValue();
        String labelString = (String)modifiedValue.getNewValue();
        Set<String> oldLabels = this.getLabelSet(oldLabelString);
        if (this.valueChanged(oldLabels, labels = this.getLabelSet(labelString))) {
            Set newLabels = this.labelManager.setLabels(this.authenticationContext.getLoggedInUser(), issue.getId(), labels, false, false);
            issueChangeHolder.addChangeItem(new ChangeItemBean("jira", "labels", null, oldLabelString, null, StringUtils.join((Collection)newLabels, (String)" ")));
        }
    }

    private boolean valueChanged(Set<String> oldLabels, Set<String> labels) {
        return !((Object)oldLabels).equals(labels);
    }

    private Set<String> getLabelSet(String labelString) {
        LinkedHashSet<String> labels = new LinkedHashSet<String>();
        String[] labelArray = StringUtils.split((String)labelString, (String)" ");
        if (labelArray != null) {
            for (String label : labelArray) {
                labels.add(label.trim());
            }
        }
        return labels;
    }

    public String getColumnHeadingKey() {
        return "issue.column.heading.labels";
    }

    public String getDefaultSortOrder() {
        return "ASC";
    }

    public LuceneFieldSorter getSorter() {
        return SORTER;
    }

    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        Map<String, Object> velocityParams = this.getVelocityParams(this.getAuthenticationContext().getI18nHelper(), displayParams, issue);
        velocityParams.put("labels", issue.getLabels());
        velocityParams.put("labelUtil", this.getLabelUtil());
        velocityParams.put("remoteUser", this.authenticationContext.getLoggedInUser());
        velocityParams.put("canEdit", this.issueManager.isEditable(issue, this.authenticationContext.getLoggedInUser()));
        return this.renderTemplate("labels-columnview.vm", velocityParams);
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        if (this.isHidden(bulkEditBean.getFieldLayouts())) {
            return "bulk.edit.unavailable.hidden";
        }
        for (Issue issue : bulkEditBean.getSelectedIssues()) {
            if (this.hasBulkUpdatePermission(bulkEditBean, issue) && this.isShown(issue)) continue;
            return "bulk.edit.multiproject.unavailable.permission";
        }
        return null;
    }

    @Override
    protected Object getRelevantParams(Map<String, String[]> params) {
        String[] value = params.get(this.getId());
        if (value != null && value.length > 0) {
            LinkedHashSet<Label> labels = new LinkedHashSet<Label>();
            for (String labelString : value) {
                labels.add(new Label(null, null, labelString));
            }
            return labels;
        }
        return Collections.emptySet();
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        return new FieldTypeInfo(null, String.format("%s/rest/api/1.0/labels/suggest?query=", this.jiraBaseUrls.baseUrl()));
    }

    public JsonType getJsonSchema() {
        return JsonTypeBuilder.systemArray((String)"string", (String)this.getId());
    }

    public RestFieldOperationsHandler getRestFieldOperation() {
        return new LabelsRestFieldOperationsHandler(this.authenticationContext.getI18nHelper());
    }

    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequired, FieldLayoutItem fieldLayoutItem) {
        ArrayList<String> list = new ArrayList<String>();
        for (Label label : issue.getLabels()) {
            list.add(label.getLabel());
        }
        return new FieldJsonRepresentation(new JsonData(list));
    }

    public JsonData getJsonDefaultValue(IssueContext issueCtx) {
        return null;
    }
}

