/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comments;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.comments.MutableComment;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.JiraDateUtils;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class CommentImpl
implements MutableComment {
    private final CommentManager manager;
    private Long id;
    private ApplicationUser author;
    private String body;
    private String groupLevel;
    private Long roleLevelId;
    private Date created;
    private final Issue issue;
    private ApplicationUser updateAuthor;
    private Date updated;

    public CommentImpl(CommentManager manager, ApplicationUser author, ApplicationUser updateAuthor, String body, String groupLevel, Long roleLevelId, Date created, Date updated, Issue issue) throws IllegalArgumentException {
        Date createdDate;
        if (StringUtils.isNotBlank((String)groupLevel) && roleLevelId != null) {
            throw new IllegalArgumentException("Cannot specify both grouplevel and rolelevel comment visibility");
        }
        this.manager = manager;
        this.author = author;
        this.updateAuthor = updateAuthor;
        this.body = body == null ? "" : body;
        this.groupLevel = groupLevel;
        this.roleLevelId = roleLevelId;
        this.created = createdDate = JiraDateUtils.copyOrCreateDateNullsafe((Date)created);
        this.updated = updated == null ? createdDate : updated;
        this.issue = issue;
    }

    public String getAuthor() {
        return this.getAuthorKey();
    }

    public String getAuthorKey() {
        return this.author == null ? null : this.author.getKey();
    }

    public User getAuthorUser() {
        return this.author == null ? null : this.author.getDirectoryUser();
    }

    public String getAuthorFullName() {
        return this.author == null ? null : this.author.getDisplayName();
    }

    public String getBody() {
        return this.body;
    }

    public Date getCreated() {
        return JiraDateUtils.copyDateNullsafe((Date)this.created);
    }

    public String getGroupLevel() {
        return this.groupLevel;
    }

    public Long getId() {
        return this.id;
    }

    public ApplicationUser getAuthorApplicationUser() {
        return this.author;
    }

    public User getUpdateAuthorUser() {
        return this.updateAuthor == null ? null : this.updateAuthor.getDirectoryUser();
    }

    public String getUpdateAuthorFullName() {
        return this.updateAuthor == null ? null : this.updateAuthor.getDisplayName();
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setAuthor(ApplicationUser author) {
        this.author = author;
    }

    public void setAuthor(String author) {
        this.author = ComponentAccessor.getUserManager().getUserByKeyEvenWhenUnknown(author);
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setGroupLevel(String groupLevel) {
        this.groupLevel = groupLevel;
    }

    public void setRoleLevelId(Long roleLevelId) {
        this.roleLevelId = roleLevelId;
    }

    public void setUpdateAuthor(ApplicationUser updateAuthor) {
        this.updateAuthor = updateAuthor;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public void setUpdateAuthor(String updateAuthor) {
        this.updateAuthor = ComponentAccessor.getUserManager().getUserByKeyEvenWhenUnknown(updateAuthor);
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    void setId(Long id) {
        this.id = id;
    }

    public Long getRoleLevelId() {
        return this.roleLevelId;
    }

    public ProjectRole getRoleLevel() {
        return this.roleLevelId == null ? null : this.manager.getProjectRole(this.roleLevelId);
    }

    public Issue getIssue() {
        return this.issue;
    }

    public String getUpdateAuthor() {
        return this.updateAuthor == null ? null : this.updateAuthor.getKey();
    }

    public ApplicationUser getUpdateAuthorApplicationUser() {
        return this.updateAuthor;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CommentImpl)) {
            return false;
        }
        CommentImpl comment = (CommentImpl)obj;
        if (this.id != null ? !this.id.equals(comment.id) : comment.id != null) {
            return false;
        }
        if (!this.author.equals(comment.author)) {
            return false;
        }
        if (!this.created.equals(comment.created)) {
            return false;
        }
        if (!this.body.equals(comment.body)) {
            return false;
        }
        if (this.roleLevelId != null ? !this.roleLevelId.equals(comment.roleLevelId) : comment.roleLevelId != null) {
            return false;
        }
        if (this.groupLevel != null ? !this.groupLevel.equals(comment.groupLevel) : comment.groupLevel != null) {
            return false;
        }
        if (this.updateAuthor != null ? !this.updateAuthor.equals(comment.updateAuthor) : comment.updateAuthor != null) {
            return false;
        }
        return !(this.updated != null ? !this.updated.equals(comment.updated) : comment.updated != null);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }
}

