/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.task.ProvidesTaskProgress;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.Sized;
import com.atlassian.jira.util.index.Contexts;
import com.atlassian.jira.web.ServletContextProvider;
import com.atlassian.jira.web.action.admin.index.IndexCommandResult;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import java.util.concurrent.Callable;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;

public class ReplicateIndexReindexCommand
implements Callable<IndexCommandResult>,
ProvidesTaskProgress {
    private final boolean useBackgroundIndexing;
    private final IssueIndexManager indexManager;
    private final JohnsonEventContainer eventContainer;
    private final I18nHelper i18nHelper;
    private final Logger log;
    private volatile TaskProgressSink taskProgressSink;
    public static final String REINDEXING = "The backup JIRA is currently being reindexed. Depending on how large the database is, this may take a few minutes. JIRA will automatically become available as soon as this task is complete.";

    public ReplicateIndexReindexCommand(boolean useBackgroundIndexing, IssueIndexManager indexManager, I18nHelper i18nHelper, Logger log) {
        this.useBackgroundIndexing = useBackgroundIndexing;
        this.indexManager = indexManager;
        this.i18nHelper = i18nHelper;
        this.log = log;
        this.eventContainer = JohnsonEventContainer.get((ServletContext)ServletContextProvider.getServletContext());
    }

    @Override
    public IndexCommandResult call() throws Exception {
        Event appEvent = new Event(EventType.get((String)"reindex"), REINDEXING, EventLevel.get((String)"warning"));
        if (!this.useBackgroundIndexing) {
            this.eventContainer.addEvent(appEvent);
        }
        Context context = Contexts.percentageReporter((Sized)this.indexManager, (TaskProgressSink)this.taskProgressSink, (I18nHelper)this.i18nHelper, (Logger)this.log, (Event)appEvent);
        this.log.info((Object)"Re-indexing started");
        return new IndexCommandResult(this.indexManager.reIndexAll(context, this.useBackgroundIndexing, false));
    }

    @Override
    public void setTaskProgressSink(TaskProgressSink taskProgressSink) {
        this.taskProgressSink = taskProgressSink;
    }
}

