/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.util.LuceneDirectoryUtils;
import com.atlassian.jira.util.PathUtils;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.NoSuchDirectoryException;

public class ClusteredIndexUtils {
    private static final Logger log = Logger.getLogger(ClusteredIndexUtils.class);
    private final LazyReference<ClusterManager> clusterManagerRef = new LazyReference<ClusterManager>(){

        protected ClusterManager create() throws Exception {
            return (ClusterManager)ComponentAccessor.getComponentOfType(ClusterManager.class);
        }
    };
    private final IssueIndexManager issueIndexManager;
    private final JiraHome jiraHome;
    private final LuceneDirectoryUtils luceneDirectoryUtils;

    public ClusteredIndexUtils(IssueIndexManager issueIndexManager, JiraHome jiraHome, LuceneDirectoryUtils luceneDirectoryUtils) {
        this.issueIndexManager = issueIndexManager;
        this.jiraHome = jiraHome;
        this.luceneDirectoryUtils = luceneDirectoryUtils;
    }

    public void copyIndexes(@Nonnull String sourcePath, @Nonnull String destinationPath) {
        Map<IndexPath, IndexPathMapping> indexPathMappings = this.buildIndexPathMappings(sourcePath, destinationPath);
        for (IndexPathMapping indexPathMapping : indexPathMappings.values()) {
            File sourceDirectory = new File(indexPathMapping.getSourcePath());
            File destDirectory = new File(indexPathMapping.getDestinationPath());
            this.copySpecificIndex(sourceDirectory, destDirectory);
        }
    }

    public Map<IndexPath, IndexPathMapping> buildIndexPathMappings(@Nonnull String sourcePath, @Nonnull String destinationPath) {
        HashMap indexPathMappings = Maps.newHashMap();
        if (((ClusterManager)this.clusterManagerRef.get()).isClustered()) {
            for (IndexPath path : IndexPath.values()) {
                indexPathMappings.put(path, new IndexPathMapping(PathUtils.joinPaths((String[])new String[]{sourcePath, path.getPath()}), PathUtils.joinPaths((String[])new String[]{destinationPath, path.getPath()})));
            }
        }
        return indexPathMappings;
    }

    public void clearIndex(@Nonnull String path) {
        List<String> indexPaths = this.buildIndexPaths(path);
        for (String indexPath : indexPaths) {
            this.clearIndex(new File(indexPath));
        }
    }

    private void clearIndex(File directory) {
        IndexWriter writer = null;
        try {
            writer = this.getWriter(directory);
            writer.deleteAll();
        }
        catch (Exception e) {
            log.error((Object)"Error occured while copying index", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.closeQuietly(writer);
        }
    }

    private List<String> buildIndexPaths(String path) {
        ArrayList paths = Lists.newArrayList();
        for (IndexPath indexPath : IndexPath.values()) {
            paths.add(PathUtils.joinPaths((String[])new String[]{path, indexPath.getPath()}));
        }
        return paths;
    }

    /*
     * Loose catch block
     */
    private void copySpecificIndex(File sourceDirectory, File destDirectory) {
        IndexReader reader = null;
        IndexWriter writer = null;
        try {
            writer = this.getWriter(destDirectory);
            reader = IndexReader.open((Directory)this.luceneDirectoryUtils.getDirectory(sourceDirectory));
            writer.addIndexes(new IndexReader[]{reader});
            this.closeQuietly(reader);
            this.closeQuietly(writer);
        }
        catch (NoSuchDirectoryException e) {
            log.debug((Object)("Cannot copy index; " + e.getMessage()));
            this.closeQuietly(reader);
            this.closeQuietly(writer);
        }
        catch (Exception e2) {
            log.error((Object)"Error occured while copying index", (Throwable)e2);
            throw new RuntimeException(e2);
            {
                catch (Throwable throwable) {
                    this.closeQuietly(reader);
                    this.closeQuietly(writer);
                    throw throwable;
                }
            }
        }
    }

    private void closeQuietly(IndexWriter writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                log.debug((Object)"Exception thrown while closing reader, ignored");
            }
        }
    }

    private void closeQuietly(IndexReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                log.debug((Object)"Exception thrown while closing reader, ignored");
            }
        }
    }

    private IndexWriter getWriter(File directory) throws Exception {
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(IssueIndexManager.LUCENE_VERSION, this.issueIndexManager.getAnalyzerForIndexing());
        indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        return new IndexWriter(this.luceneDirectoryUtils.getDirectory(directory), indexWriterConfig);
    }

    static class IndexPathMapping {
        private final String sourcePath;
        private final String destinationPath;

        IndexPathMapping(String sourcePath, String destinationPath) {
            this.sourcePath = sourcePath;
            this.destinationPath = destinationPath;
        }

        String getSourcePath() {
            return this.sourcePath;
        }

        String getDestinationPath() {
            return this.destinationPath;
        }
    }

    public static enum IndexPath {
        ISSUES("issues"),
        COMMENTS("comments"),
        CHANGE_HISTORY("changes"),
        SEARCH_REQUESTS(PathUtils.joinPaths((String[])new String[]{"entities", "searchrequest"})),
        PORTAL_PAGES(PathUtils.joinPaths((String[])new String[]{"entities", "portalpage"}));

        private final String path;

        private IndexPath(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }
}

