/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.transformer;

import com.atlassian.jira.external.beans.ExternalIssue;
import com.atlassian.jira.external.beans.ExternalIssueImpl;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.transformer.IssueTransformer;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class IssueTransformerImpl
implements IssueTransformer {
    private static final Logger log = Logger.getLogger(IssueTransformerImpl.class);

    @Override
    public ExternalIssue transform(ProjectImportMapper projectImportMapper, ExternalIssue issue) {
        ExternalIssueImpl newIssue = new ExternalIssueImpl();
        newIssue.setKey(issue.getKey());
        newIssue.setSummary(issue.getSummary());
        newIssue.setReporter(projectImportMapper.getUserMapper().getMappedUserKey(issue.getReporter()));
        newIssue.setAssignee(projectImportMapper.getUserMapper().getMappedUserKey(issue.getAssignee()));
        newIssue.setDescription(issue.getDescription());
        newIssue.setEnvironment(issue.getEnvironment());
        newIssue.setCreated(issue.getCreated());
        newIssue.setUpdated(issue.getUpdated());
        newIssue.setDuedate(issue.getDuedate());
        newIssue.setVotes(issue.getVotes());
        newIssue.setOriginalEstimate(issue.getOriginalEstimate());
        newIssue.setTimeSpent(issue.getTimeSpent());
        newIssue.setEstimate(issue.getEstimate());
        newIssue.setProject(projectImportMapper.getProjectMapper().getMappedId(issue.getProject()));
        newIssue.setIssueType(projectImportMapper.getIssueTypeMapper().getMappedId(issue.getIssueType()));
        newIssue.setStatus(projectImportMapper.getStatusMapper().getMappedId(issue.getStatus()));
        newIssue.setPriority(projectImportMapper.getPriorityMapper().getMappedId(issue.getPriority()));
        newIssue.setResolution(projectImportMapper.getResolutionMapper().getMappedId(issue.getResolution()));
        Timestamp now = new Timestamp(System.currentTimeMillis());
        if (newIssue.getCreated() == null) {
            newIssue.setCreated(now);
        }
        if (newIssue.getUpdated() == null) {
            newIssue.setUpdated(now);
        }
        if (issue.getResolutionDate() != null && issue.getResolution() != null) {
            newIssue.setResolutionDate(issue.getResolutionDate());
        } else if (issue.getResolution() != null) {
            newIssue.setResolutionDate(issue.getUpdated());
        }
        newIssue.setSecurityLevel(projectImportMapper.getIssueSecurityLevelMapper().getMappedId(issue.getSecurityLevel()));
        if (issue.getSecurityLevel() != null && projectImportMapper.getIssueSecurityLevelMapper().getMappedId(issue.getSecurityLevel()) == null) {
            log.warn((Object)("Dropping the issue security level with id '" + issue.getSecurityLevel() + "' for issue with key '" + issue.getKey() + "' as JIRA is unable to resolve the issue security level in the backup data."));
        }
        return newIssue;
    }
}

