/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.parser;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalAttachment;
import com.atlassian.jira.external.beans.ExternalProject;
import com.atlassian.jira.imports.project.parser.AttachmentParser;
import com.atlassian.jira.issue.attachment.AttachmentAdapterImpl;
import com.atlassian.jira.issue.attachment.AttachmentStore;
import com.atlassian.jira.issue.attachment.DefaultAttachmentStore;
import com.atlassian.jira.util.dbc.Null;
import java.io.File;
import java.sql.Timestamp;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AttachmentParserImpl
implements AttachmentParser {
    private static final String ID = "id";
    private static final String ISSUE = "issue";
    private static final String FILENAME = "filename";
    private static final String CREATED = "created";
    private static final String AUTHOR = "author";
    private final AttachmentStore attachmentStore;
    protected final String attachmentPath;

    public AttachmentParserImpl(AttachmentStore attachmentStore, String attachmentPath) {
        this.attachmentStore = attachmentStore;
        this.attachmentPath = attachmentPath;
    }

    @Override
    public ExternalAttachment parse(Map<String, String> attributes) throws ParseException {
        Null.not("attributes", attributes);
        String id = attributes.get(ID);
        String issueId = attributes.get(ISSUE);
        String fileName = attributes.get(FILENAME);
        String created = attributes.get(CREATED);
        String author = attributes.get(AUTHOR);
        if (StringUtils.isEmpty((String)id)) {
            throw new ParseException("A file attachment must have an id specified.");
        }
        if (StringUtils.isEmpty((String)issueId)) {
            throw new ParseException("A file attachment with id '" + id + "' must have an issue id specified.");
        }
        if (fileName == null) {
            throw new ParseException("A file attachment with id '" + id + "' must have a file name specified.");
        }
        if (StringUtils.isEmpty((String)created)) {
            throw new ParseException("A file attachment with id '" + id + "' must have a create date specified.");
        }
        Timestamp createdDate = Timestamp.valueOf(created);
        return new ExternalAttachment(id, issueId, fileName, createdDate, author);
    }

    @Override
    public boolean isUsingOriginalKeyPath(ExternalProject project) {
        return StringUtils.isNotEmpty((String)project.getOriginalKey()) && !StringUtils.equals((String)project.getKey(), (String)project.getOriginalKey());
    }

    @Override
    public File getAttachmentDirectory(ExternalProject project, String issueKey) {
        File attachmentDirectory = this.isUsingOriginalKeyPath(project) ? this.attachmentStore.getAttachmentDirectory(this.attachmentPath, project.getOriginalKey(), DefaultAttachmentStore.computeIssueKeyForOriginalProjectKey(project.getOriginalKey(), issueKey)) : this.attachmentStore.getAttachmentDirectory(this.attachmentPath, project.getKey(), issueKey);
        return attachmentDirectory;
    }

    @Override
    public File getAttachmentFile(ExternalAttachment attachment, ExternalProject project, String issueKey) {
        AttachmentAdapterImpl attachmentAdapter = new AttachmentAdapterImpl(Long.valueOf(attachment.getId()), attachment.getFileName());
        File attachmentFile = this.attachmentStore.getAttachmentFile((AttachmentStore.AttachmentAdapter)attachmentAdapter, this.getAttachmentDirectory(project, issueKey));
        return attachmentFile;
    }
}

