/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalProject;
import com.atlassian.jira.imports.project.handler.ImportEntityHandler;
import com.atlassian.jira.imports.project.mapper.SimpleProjectImportIdMapper;
import com.atlassian.jira.imports.project.parser.ProjectParser;
import com.atlassian.jira.imports.project.parser.ProjectParserImpl;
import com.atlassian.jira.util.dbc.Null;
import java.util.Map;

public class ProjectMapperHandler
implements ImportEntityHandler {
    private ProjectParser projectParser;
    private final SimpleProjectImportIdMapper projectMapper;

    public ProjectMapperHandler(SimpleProjectImportIdMapper projectMapper) {
        this.projectMapper = projectMapper;
    }

    @Override
    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException {
        Null.not("attributes", attributes);
        if ("Project".equals(entityName)) {
            ExternalProject project = this.getProjectParser().parseProject(attributes);
            this.projectMapper.registerOldValue(project.getId(), project.getKey());
        }
    }

    ProjectParser getProjectParser() {
        if (this.projectParser == null) {
            this.projectParser = new ProjectParserImpl();
        }
        return this.projectParser;
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectMapperHandler that = (ProjectMapperHandler)o;
        if (this.projectMapper != null ? !this.projectMapper.equals(that.projectMapper) : that.projectMapper != null) {
            return false;
        }
        return !(this.projectParser != null ? !this.projectParser.equals(that.projectParser) : that.projectParser != null);
    }

    public int hashCode() {
        int result = this.projectParser != null ? this.projectParser.hashCode() : 0;
        result = 31 * result + (this.projectMapper != null ? this.projectMapper.hashCode() : 0);
        return result;
    }
}

