/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.favourites;

import com.atlassian.jira.favourites.FavouritesStore;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.PrimitiveMap;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericValue;

public class OfBizFavouritesStore
implements FavouritesStore {
    private final OfBizDelegator delegator;

    public OfBizFavouritesStore(OfBizDelegator delegator) {
        this.delegator = delegator;
    }

    @Override
    public boolean addFavourite(ApplicationUser user, SharedEntity entity) {
        return this.getAssociation(user, entity) == null && this.createAssociation(user, entity) != null;
    }

    @Override
    public boolean removeFavourite(ApplicationUser user, SharedEntity entity) {
        List<GenericValue> favourites = this.getFavouriteGVsOfEntityType(user, entity.getEntityType(), Lists.newArrayList((Object[])new String[]{"id", "entityId", "sequence"}));
        ArrayList<GenericValue> changedValues = new ArrayList<GenericValue>(favourites.size());
        GenericValue removeGv = null;
        int expectedSequence = 0;
        Iterator<GenericValue> i$ = favourites.iterator();
        while (i$.hasNext()) {
            GenericValue element;
            GenericValue favouriteGv = element = i$.next();
            Long entityId = favouriteGv.getLong("entityId");
            if (removeGv == null && entityId != null && entityId.equals(entity.getId())) {
                removeGv = favouriteGv;
                continue;
            }
            Long storedSequence = favouriteGv.getLong("sequence");
            if (storedSequence == null || storedSequence != (long)expectedSequence) {
                favouriteGv.set("sequence", (Object)expectedSequence);
                changedValues.add(favouriteGv);
            }
            ++expectedSequence;
        }
        if (removeGv != null) {
            this.delegator.removeValue(removeGv);
            if (!changedValues.isEmpty()) {
                this.delegator.storeAll(changedValues);
            }
        }
        return removeGv != null;
    }

    @Override
    public boolean isFavourite(ApplicationUser user, SharedEntity entity) {
        return this.getAssociation(user, entity) != null;
    }

    @Override
    public Collection<Long> getFavouriteIds(ApplicationUser user, SharedEntity.TypeDescriptor<?> entityType) {
        List<GenericValue> idGVs = this.getFavouriteGVsOfEntityType(user, entityType, Lists.newArrayList((Object[])new String[]{"entityId"}));
        ArrayList<Long> ids = new ArrayList<Long>(idGVs.size());
        for (GenericValue genericValue : idGVs) {
            ids.add(genericValue.getLong("entityId"));
        }
        return Collections.unmodifiableList(ids);
    }

    @Override
    public void removeFavouritesForUser(ApplicationUser user, SharedEntity.TypeDescriptor<?> entityType) {
        this.delegator.removeByAnd("FavouriteAssociations", new PrimitiveMap.Builder().add("username", ApplicationUsers.getKeyFor((ApplicationUser)user)).add("entityType", entityType.getName()).toMap());
    }

    @Override
    public void removeFavouritesForEntity(SharedEntity entity) {
        this.delegator.removeByAnd("FavouriteAssociations", new PrimitiveMap.Builder().add("entityId", entity.getId()).add("entityType", entity.getEntityType().getName()).toMap());
    }

    @Override
    public void updateSequence(ApplicationUser user, List<? extends SharedEntity> favouriteEntities) {
        this.storeGVListSequence(this.getFavouriteGVsOfEntityTypes(user, favouriteEntities));
    }

    private GenericValue createAssociation(ApplicationUser user, SharedEntity entity) {
        Collection<Long> previousEntities = this.getFavouriteIds(user, entity.getEntityType());
        Long sequence = previousEntities.size();
        return this.delegator.createValue("FavouriteAssociations", new PrimitiveMap.Builder().add("username", ApplicationUsers.getKeyFor((ApplicationUser)user)).add("entityType", entity.getEntityType().getName()).add("entityId", entity.getId()).add("sequence", sequence).toMap());
    }

    private GenericValue getAssociation(ApplicationUser user, SharedEntity entity) {
        Map<String, Object> map = new PrimitiveMap.Builder().add("username", ApplicationUsers.getKeyFor((ApplicationUser)user)).add("entityType", entity.getEntityType().getName()).add("entityId", entity.getId()).toMap();
        List gvs = this.delegator.findByAnd("FavouriteAssociations", map);
        if (gvs != null) {
            return EntityUtil.getOnly((List)gvs);
        }
        return null;
    }

    private List<GenericValue> getFavouriteGVsOfEntityType(ApplicationUser user, SharedEntity.TypeDescriptor<?> entityType, List<String> fieldToReturnList) {
        EntityExpr userCondition = new EntityExpr("username", EntityOperator.EQUALS, (Object)ApplicationUsers.getKeyFor((ApplicationUser)user));
        EntityExpr typeCondition = new EntityExpr("entityType", EntityOperator.EQUALS, (Object)entityType.getName());
        EntityConditionList joinedCondition = new EntityConditionList((List)Lists.newArrayList((Object[])new EntityCondition[]{userCondition, typeCondition}), EntityOperator.AND);
        ArrayList orderByList = Lists.newArrayList((Object[])new String[]{"sequence ASC"});
        return this.delegator.findByCondition("FavouriteAssociations", (EntityCondition)joinedCondition, fieldToReturnList, (List)orderByList);
    }

    private List<GenericValue> getFavouriteGVsOfEntityTypes(ApplicationUser user, List<? extends SharedEntity> entities) {
        ArrayList<GenericValue> gvList = new ArrayList<GenericValue>();
        for (SharedEntity sharedEntity : entities) {
            GenericValue associationGV = this.getAssociation(user, sharedEntity);
            if (associationGV == null) continue;
            gvList.add(associationGV);
        }
        return gvList;
    }

    private void storeGVListSequence(List<GenericValue> sortedGVList) {
        for (int i = 0; i < sortedGVList.size(); ++i) {
            GenericValue genericValue = sortedGVList.get(i);
            genericValue.set("sequence", (Object)i);
        }
        this.delegator.storeAll(sortedGVList);
    }

    private static final class Order {
        private static final String ASCENDING = " ASC";

        private Order() {
        }
    }

    private static final class Column {
        private static final String ENTITY_ID = "entityId";
        private static final String USERKEY = "username";
        private static final String ENTITY_TYPE = "entityType";
        private static final String SEQUENCE = "sequence";
        private static final String ID = "id";

        private Column() {
        }
    }

    static final class Table {
        static final String FAVOURITE_ASSOCIATION = "FavouriteAssociations";

        Table() {
        }
    }
}

