/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.type;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.EventTypeOrderTransformer;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.comparators.TransformingComparator;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

@EventComponent
public class DefaultEventTypeManager
implements EventTypeManager {
    private static final Logger log = Logger.getLogger(DefaultEventTypeManager.class);
    public static final String EVENT_TYPE_ID = "eventTypeId";
    private final OfBizDelegator delegator;
    private final WorkflowManager workflowManager;
    private final NotificationSchemeManager notificationSchemeManager;
    private final Comparator<EventType> eventTypeComparator = new TransformingComparator((Transformer)new EventTypeOrderTransformer());
    private ResettableLazyReference<Map<Long, EventType>> eventTypesMapRef = new ResettableLazyReference<Map<Long, EventType>>(){

        protected Map<Long, EventType> create() throws Exception {
            return DefaultEventTypeManager.this.loadEventTypesMap();
        }
    };

    public DefaultEventTypeManager(OfBizDelegator delegator, WorkflowManager workflowManager, NotificationSchemeManager notificationSchemeManager) {
        this.delegator = delegator;
        this.workflowManager = workflowManager;
        this.notificationSchemeManager = notificationSchemeManager;
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.clearCache();
    }

    public Collection<EventType> getEventTypes() {
        return this.getEventTypesMap().values();
    }

    public Map<Long, EventType> getEventTypesMap() {
        return (Map)this.eventTypesMapRef.get();
    }

    public EventType getEventType(Long id) {
        EventType eventType = this.getEventTypesMap().get(id);
        if (eventType == null) {
            GenericValue issueEventTypeGV = this.retrieveEntityByPrimaryKey(EasyMap.build((Object)"id", (Object)id));
            if (issueEventTypeGV == null) {
                throw new IllegalArgumentException("No event type with id " + id);
            }
            eventType = new EventType(issueEventTypeGV);
        }
        return eventType;
    }

    public boolean isActive(EventType eventType) {
        return !this.getAssociatedWorkflows(eventType, true).isEmpty() || !this.getAssociatedNotificationSchemes(eventType).isEmpty();
    }

    public MultiMap getAssociatedWorkflows(EventType eventType, boolean statusCheck) {
        MultiValueMap workflowTransitionMap = new MultiValueMap();
        Collection workflows = this.workflowManager.getWorkflows();
        Long eventTypeId = eventType.getId();
        for (JiraWorkflow workflow : workflows) {
            Map transitionPostFunctionMap = this.workflowManager.getPostFunctionsForWorkflow(workflow);
            Set keys = transitionPostFunctionMap.keySet();
            for (ActionDescriptor actionDescriptor : keys) {
                Collection postFunctions = (Collection)transitionPostFunctionMap.get(actionDescriptor);
                for (FunctionDescriptor functionDescriptor : postFunctions) {
                    if (!functionDescriptor.getArgs().containsKey(EVENT_TYPE_ID) || !eventTypeId.equals(new Long((String)functionDescriptor.getArgs().get(EVENT_TYPE_ID)))) continue;
                    workflowTransitionMap.put((Object)workflow.getName(), (Object)actionDescriptor);
                    if (!statusCheck) continue;
                    return workflowTransitionMap;
                }
            }
        }
        return workflowTransitionMap;
    }

    public Map<Long, String> getAssociatedNotificationSchemes(EventType eventType) {
        return this.notificationSchemeManager.getSchemesMapByConditions(EasyMap.build((Object)EVENT_TYPE_ID, (Object)eventType.getId()));
    }

    public void addEventType(EventType eventType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", new Long(this.getNextEventTypeId()));
        params.put("name", eventType.getName());
        params.put("description", eventType.getDescription());
        params.put("templateId", eventType.getTemplateId());
        params.put("type", null);
        this.delegator.createValue("EventType", params);
        this.clearCache();
    }

    public void editEventType(Long eventTypeId, String name, String description, Long templateId) {
        GenericValue eventTypeGV = this.retrieveEntityByPrimaryKey(EasyMap.build((Object)"id", (Object)eventTypeId));
        eventTypeGV.set("name", (Object)name);
        eventTypeGV.set("description", (Object)description);
        eventTypeGV.set("templateId", (Object)templateId);
        this.delegator.store(eventTypeGV);
        this.clearCache();
    }

    public void deleteEventType(Long eventTypeId) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("id", eventTypeId);
        this.delegator.removeByAnd("EventType", params);
        this.clearCache();
    }

    public boolean isEventTypeExists(String issueEventTypeName) {
        if (issueEventTypeName == null) {
            throw new IllegalArgumentException("EventTypeName must not be null.");
        }
        for (EventType eventType : this.getEventTypes()) {
            if (!issueEventTypeName.equals(eventType.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isEventTypeExists(Long eventTypeId) {
        if (eventTypeId == null) {
            throw new IllegalArgumentException("EventTypeId must not be null.");
        }
        return this.getEventTypesMap().containsKey(eventTypeId);
    }

    private Map<Long, EventType> loadEventTypesMap() {
        ImmutableMap.Builder eventTypeMap = ImmutableMap.builder();
        for (EventType eventType : this.retrieveAllEntities()) {
            eventTypeMap.put((Object)eventType.getId(), (Object)eventType);
        }
        return eventTypeMap.build();
    }

    private Collection<EventType> retrieveAllEntities() {
        List eventTypeGVs = this.delegator.findAll("EventType");
        ArrayList<EventType> eventTypes = new ArrayList<EventType>(eventTypeGVs.size());
        for (GenericValue eventTypeGV : eventTypeGVs) {
            eventTypes.add(new EventType(eventTypeGV));
        }
        Collections.sort(eventTypes, this.eventTypeComparator);
        return eventTypes;
    }

    private GenericValue retrieveEntityByPrimaryKey(Map params) {
        return this.delegator.findByPrimaryKey("EventType", params);
    }

    private synchronized long getNextEventTypeId() {
        long startID = 10000L;
        List entities = ComponentAccessor.getOfBizDelegator().findAll("EventType");
        for (GenericValue entity : entities) {
            long entityId = entity.getLong("id");
            if (entityId < startID) continue;
            startID = entityId;
        }
        return startID + 1L;
    }

    public void clearCache() {
        this.eventTypesMapRef.reset();
    }
}

