/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.issue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.IssueEventManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.util.ImportUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class DefaultIssueEventManager
implements IssueEventManager {
    private final ApplicationProperties applicationProperties;
    private final EventPublisher eventPublisher;

    public DefaultIssueEventManager(ApplicationProperties applicationProperties, EventPublisher eventPublisher) {
        this.applicationProperties = (ApplicationProperties)Assertions.notNull((Object)applicationProperties);
        this.eventPublisher = (EventPublisher)Assertions.notNull((Object)eventPublisher);
    }

    public void dispatchEvent(Long eventTypeId, Issue issue, User remoteUser, boolean sendMail) {
        this.dispatchEvent(eventTypeId, issue, Collections.<String, Object>emptyMap(), remoteUser, sendMail);
    }

    public void dispatchEvent(Long eventTypeId, Issue issue, Map<String, Object> params, User remoteUser, boolean sendMail) {
        HashMap copyOfParams = params != null ? Maps.newHashMap(params) : Maps.newHashMap();
        this.fillInDefaultParams(copyOfParams);
        this.publishEvent(new IssueEvent(issue, (Map)copyOfParams, remoteUser, eventTypeId, sendMail));
    }

    public void dispatchEvent(Long eventTypeId, Issue issue, Map params, User remoteUser) {
        this.publishEvent(new IssueEvent(issue, params, remoteUser, eventTypeId));
    }

    public void dispatchEvent(Long eventTypeId, Issue issue, User remoteUser, Comment comment, Worklog worklog, GenericValue changelog) {
        HashMap<String, Object> copyOfParams = new HashMap<String, Object>();
        this.fillInDefaultParams(copyOfParams);
        this.publishEvent(new IssueEvent(issue, remoteUser, comment, worklog, changelog, copyOfParams, eventTypeId));
    }

    public void dispatchEvent(Long eventTypeId, Issue issue, User remoteUser, Comment comment, Worklog worklog, GenericValue changelog, boolean sendMail) {
        HashMap<String, Object> copyOfParams = new HashMap<String, Object>();
        this.fillInDefaultParams(copyOfParams);
        this.publishEvent(new IssueEvent(issue, remoteUser, comment, worklog, changelog, copyOfParams, eventTypeId, sendMail));
    }

    public void dispatchEvent(Long eventTypeId, Issue issue, User remoteUser, Comment comment, Worklog worklog, GenericValue changelog, Map params) {
        Map<String, Object> copyOfParams = DefaultIssueEventManager.copyParams(params);
        this.fillInDefaultParams(copyOfParams);
        this.publishEvent(new IssueEvent(issue, remoteUser, comment, worklog, changelog, copyOfParams, eventTypeId));
    }

    public void dispatchEvent(Long eventTypeId, Issue issue, User remoteUser, Comment comment, Worklog worklog, GenericValue changelog, Map params, boolean sendMail) {
        Map<String, Object> copyOfParams = DefaultIssueEventManager.copyParams(params);
        this.fillInDefaultParams(copyOfParams);
        this.publishEvent(new IssueEvent(issue, remoteUser, comment, worklog, changelog, copyOfParams, eventTypeId, sendMail));
    }

    public void dispatchEvent(Long eventTypeId, Issue issue, User remoteUser, GenericValue changelog, boolean sendMail, boolean subtasksUpdated) {
        HashMap<String, Object> copyOfParams = new HashMap<String, Object>();
        this.fillInDefaultParams(copyOfParams);
        this.publishEvent(new IssueEvent(issue, remoteUser, null, null, changelog, copyOfParams, eventTypeId, sendMail, subtasksUpdated));
    }

    public void dispatchEvent(Long eventTypeId, Issue issue, User remoteUser, Comment comment, Worklog worklog, GenericValue changelog, Map params, boolean sendMail, boolean subtasksUpdated) {
        Map<String, Object> copyOfParams = DefaultIssueEventManager.copyParams(params);
        this.fillInDefaultParams(copyOfParams);
        this.publishEvent(new IssueEvent(issue, remoteUser, comment, worklog, changelog, copyOfParams, eventTypeId, sendMail, subtasksUpdated));
    }

    private static Map<String, Object> copyParams(Map params) {
        HashMap<String, Object> copyOfParams = new HashMap<String, Object>();
        if (params != null) {
            copyOfParams.putAll(params);
        }
        return copyOfParams;
    }

    protected void fillInDefaultParams(Map<String, Object> params) {
        params.put(IssueEvent.BASE_URL_PARAM_NAME, this.applicationProperties.getString("jira.baseurl"));
    }

    protected void publishEvent(IssueEvent event) {
        if (ImportUtils.isEnableNotifications()) {
            this.eventPublisher.publish((Object)event);
        }
    }
}

