/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.entity;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.EntityFactory;
import com.atlassian.jira.entity.PagedListIterator;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.util.collect.PagedList;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityListIterator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericHelper;
import org.ofbiz.core.entity.model.ModelEntity;

public class EntityPagedList<E>
implements PagedList<E> {
    private final String entityName;
    private final EntityFactory<E> entityFactory;
    private final EntityCondition entityCondition;
    private final List<String> orderBy;
    private final int pageSize;
    private final int count;
    private final DelegatorInterface genericDelegator;
    private final Logger log = Logger.getLogger(this.getClass());

    public EntityPagedList(int pageSize, EntityFactory<E> entityFactory, EntityCondition entityCondition, List<String> orderBy) {
        this(pageSize, entityFactory, entityCondition, orderBy, (DelegatorInterface)ComponentAccessor.getComponent(DelegatorInterface.class));
    }

    @VisibleForTesting
    EntityPagedList(int pageSize, EntityFactory<E> entityFactory, EntityCondition entityCondition, List<String> orderBy, DelegatorInterface genericDelegator) {
        this.pageSize = pageSize;
        this.entityFactory = entityFactory;
        this.entityCondition = entityCondition;
        this.orderBy = orderBy;
        this.entityName = entityFactory.getEntityName();
        this.genericDelegator = genericDelegator;
        this.count = this.getItemCount();
    }

    public List<E> getPage(int pageNumber) {
        EntityListIterator entityListIterator = null;
        if (this.pageNumberInvalid(pageNumber)) {
            throw new IllegalArgumentException("pageNumber should be between 0 and " + (this.count / this.pageSize - 1));
        }
        try {
            entityListIterator = this.getListIterator(pageNumber);
            List<E> list = this.entityFactory.buildList(entityListIterator.getCompleteList());
            return list;
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Problem retrieving page.", (Throwable)e);
        }
        finally {
            if (entityListIterator != null) {
                try {
                    entityListIterator.close();
                }
                catch (GenericEntityException ignore) {}
            }
        }
    }

    public Iterator<List<E>> iterator() {
        return new PagedListIterator(this);
    }

    public List<E> getCompleteList() {
        ArrayList list = Lists.newArrayList();
        Iterator<List<E>> iterator = this.iterator();
        while (iterator.hasNext()) {
            list.addAll((Collection)iterator.next());
        }
        return list;
    }

    private EntityListIterator getListIterator(int pageNumber) throws GenericEntityException {
        GenericHelper helper = this.genericDelegator.getEntityHelper(this.entityName);
        ModelEntity modelEntity = this.genericDelegator.getModelEntity(this.entityName);
        EntityFindOptions entityFindOptions = new EntityFindOptions();
        entityFindOptions.setOffset(pageNumber * this.pageSize);
        entityFindOptions.setMaxResults(this.pageSize);
        return helper.findListIteratorByCondition(modelEntity, this.entityCondition, null, null, this.orderBy, entityFindOptions);
    }

    public int getSize() {
        return this.count;
    }

    private int getItemCount() {
        int itemCount = 0;
        try {
            itemCount = this.genericDelegator.countByCondition(this.entityName, null, this.entityCondition, null);
        }
        catch (GenericEntityException e) {
            this.log.error((Object)"Exception thrown trying to count rows", (Throwable)e);
        }
        return itemCount;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    boolean pageNumberInvalid(int pageNumber) {
        if (this.count > 0) {
            return pageNumber < 0 || pageNumber * this.pageSize >= this.getSize();
        }
        return pageNumber != 0;
    }
}

