/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.datetime;

import com.atlassian.core.util.Clock;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatStrategy;
import com.atlassian.jira.datetime.DateTimeFormatterServiceProvider;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.TimeZoneResolver;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

abstract class AbstractDateTimeRelativeDatesFormatter
implements DateTimeFormatStrategy {
    private final DateTimeFormatterServiceProvider serviceProvider;
    private final ApplicationProperties applicationProperties;
    private final TimeZoneResolver timeZoneInfoResolver;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private DateTimeFormatStrategy relativeDatesFormatter;
    private DateTimeFormatStrategy datesFormatter;
    private final Clock clock;

    public AbstractDateTimeRelativeDatesFormatter(DateTimeFormatterServiceProvider serviceProvider, ApplicationProperties applicationProperties, TimeZoneResolver timeZoneInfoResolver, JiraAuthenticationContext jiraAuthenticationContext, DateTimeFormatStrategy relativeDateFormatter, DateTimeFormatStrategy datesFormatter, Clock clock) {
        this.serviceProvider = serviceProvider;
        this.applicationProperties = applicationProperties;
        this.timeZoneInfoResolver = timeZoneInfoResolver;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.relativeDatesFormatter = relativeDateFormatter;
        this.datesFormatter = datesFormatter;
        this.clock = clock;
    }

    @Override
    public String format(DateTime dateTime, Locale locale) {
        TimeZone userTimeZone = this.timeZoneInfoResolver.getUserTimeZone((JiraServiceContext)new JiraServiceContextImpl(this.jiraAuthenticationContext.getUser()));
        DateTime referenceDateTime = new DateTime((Object)this.clock.getCurrentDate(), DateTimeZone.forTimeZone((TimeZone)userTimeZone));
        String dateI18nKey = RelativeFormatter.getDayI18nKey(dateTime, referenceDateTime);
        boolean formatterRelative = this.applicationProperties.getOption("jira.lf.date.relativize");
        if (formatterRelative && dateI18nKey != null) {
            String dateString = this.relativeDatesFormatter.format(dateTime, locale);
            return this.serviceProvider.getText(dateI18nKey, dateString);
        }
        return this.datesFormatter.format(dateTime, locale);
    }

    @Override
    public Date parse(String text, DateTimeZone timeZone, Locale locale) {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract DateTimeStyle style();

    @Override
    public String pattern() {
        throw new UnsupportedOperationException();
    }

    public static class RelativeFormatter {
        public static String getDayI18nKey(DateTime theDate, DateTime referenceDate) {
            LocalDate timeDt;
            LocalDate refDt = RelativeFormatter.createLocalDate(referenceDate.toDate(), referenceDate.getZone().toTimeZone());
            int daysBetween = Days.daysBetween((ReadablePartial)refDt, (ReadablePartial)(timeDt = RelativeFormatter.createLocalDate(theDate.toDate(), theDate.getZone().toTimeZone()))).getDays();
            if (daysBetween < -7) {
                return null;
            }
            if (daysBetween < -1) {
                return "common.date.relative.days.last." + timeDt.dayOfWeek().get();
            }
            if (daysBetween == -1) {
                return "common.concepts.yesterday";
            }
            if (daysBetween == 0) {
                return "common.concepts.today";
            }
            if (daysBetween == 1) {
                return "common.concepts.tomorrow";
            }
            if (daysBetween <= 7) {
                return "common.date.relative.days.next." + timeDt.dayOfWeek().get();
            }
            return null;
        }

        private static LocalDate createLocalDate(Date date, TimeZone timeZone) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeZone(timeZone);
            cal.setTime(date);
            cal.getTime();
            return new LocalDate(cal.get(1), cal.get(2) + 1, cal.get(5));
        }
    }
}

