/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.dashboard.permission;

import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.spi.DashboardPermissionService;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class JiraPermissionService
implements DashboardPermissionService {
    private final UserUtil userUtil;
    private final PortalPageService portalPageService;
    private final PermissionManager permissionManager;
    private static final ThreadLocal<Boolean> allowEditingOfDefaultDashboard = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.TRUE;
        }
    };

    public JiraPermissionService(UserUtil userUtil, PortalPageService portalPageService, PermissionManager permissionManager) {
        this.userUtil = userUtil;
        this.portalPageService = portalPageService;
        this.permissionManager = permissionManager;
    }

    public boolean isReadableBy(DashboardId dashboardId, @Nullable ApplicationUser user) {
        JiraServiceContextImpl context = new JiraServiceContextImpl(user);
        return this.portalPageService.validateForGetPortalPage((JiraServiceContext)context, Long.valueOf(dashboardId.value()));
    }

    public boolean isReadableBy(DashboardId dashboardId, @Nullable String username) {
        return this.isReadableBy(dashboardId, this.getUser(username));
    }

    public boolean isWritableBy(DashboardId dashboardId, @Nullable ApplicationUser user) {
        JiraServiceContextImpl context = new JiraServiceContextImpl(user);
        PortalPage portalPage = this.portalPageService.getPortalPage((JiraServiceContext)context, Long.valueOf(dashboardId.value()));
        if (portalPage == null) {
            return false;
        }
        if (!portalPage.isSystemDefaultPortalPage()) {
            return this.portalPageService.validateForUpdate((JiraServiceContext)context, portalPage);
        }
        return allowEditingOfDefaultDashboard.get() != false && this.portalPageService.validateForUpdate((JiraServiceContext)context, portalPage);
    }

    public boolean isWritableBy(DashboardId dashboardId, @Nullable String username) {
        return this.isWritableBy(dashboardId, this.getUser(username));
    }

    public static void setAllowEditingOfDefaultDashboard(boolean allow) {
        allowEditingOfDefaultDashboard.set(allow);
    }

    private ApplicationUser getUser(String username) {
        if (StringUtils.isEmpty((String)username)) {
            return null;
        }
        return this.userUtil.getUserByName(username);
    }
}

