/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.jira.crowd.embedded.ofbiz.EntityConditionFactory;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import org.ofbiz.core.entity.model.ModelEntity;

class UserEntityConditionFactory
extends EntityConditionFactory {
    private final String attributeTableName;

    UserEntityConditionFactory(OfBizDelegator ofBizDelegator) {
        ModelEntity modelEntity = ofBizDelegator.getDelegatorInterface().getModelEntity("UserAttribute");
        this.attributeTableName = modelEntity.getTableName(ofBizDelegator.getDelegatorInterface().getEntityHelperName("UserAttribute"));
    }

    @Override
    String getEntityTableIdColumnName() {
        return "id";
    }

    @Override
    String getAttributeTableName() {
        return this.attributeTableName;
    }

    @Override
    String getAttributeIdColumnName() {
        return "user_id";
    }

    @Override
    boolean isCoreProperty(Property<?> property) {
        return property.equals((Object)UserTermKeys.USERNAME) || property.equals((Object)UserTermKeys.EMAIL) || property.equals((Object)UserTermKeys.FIRST_NAME) || property.equals((Object)UserTermKeys.LAST_NAME) || property.equals((Object)UserTermKeys.DISPLAY_NAME) || property.equals((Object)UserTermKeys.CREATED_DATE) || property.equals((Object)UserTermKeys.UPDATED_DATE) || property.equals((Object)UserTermKeys.ACTIVE);
    }

    @Override
    String getLowerFieldName(Property<?> property) {
        if (property.equals((Object)UserTermKeys.USERNAME)) {
            return "lowerUserName";
        }
        if (property.equals((Object)UserTermKeys.EMAIL)) {
            return "lowerEmailAddress";
        }
        if (property.equals((Object)UserTermKeys.FIRST_NAME)) {
            return "lowerFirstName";
        }
        if (property.equals((Object)UserTermKeys.LAST_NAME)) {
            return "lowerLastName";
        }
        if (property.equals((Object)UserTermKeys.DISPLAY_NAME)) {
            return "lowerDisplayName";
        }
        if (property.equals((Object)UserTermKeys.ACTIVE)) {
            return "active";
        }
        if (property.equals((Object)UserTermKeys.CREATED_DATE)) {
            return "createdDate";
        }
        if (property.equals((Object)UserTermKeys.UPDATED_DATE)) {
            return "updatedDate";
        }
        throw new UnsupportedOperationException("Unknown user property: " + property);
    }
}

