/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationManagerException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.atlassian.ip.IPMatcher;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.crowd.embedded.JaacsService;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.ValidationFailureException;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DefaultJaacsService
implements JaacsService {
    private static final Logger log = Logger.getLogger(DefaultJaacsService.class);
    private final ApplicationManager applicationManager;
    private final PermissionManager permissionManager;
    private final I18nHelper.BeanFactory i18nFactory;

    public DefaultJaacsService(ApplicationManager applicationManager, PermissionManager permissionManager, I18nHelper.BeanFactory i18nFactory) {
        this.applicationManager = applicationManager;
        this.permissionManager = permissionManager;
        this.i18nFactory = i18nFactory;
    }

    @Override
    public Set<RemoteAddress> getRemoteAddresses(JiraServiceContext jiraServiceContext, long applicationId) {
        Application app = null;
        try {
            app = this.applicationManager.findById(applicationId);
        }
        catch (ObjectNotFoundException e) {
            return Collections.emptySet();
        }
        return app.getRemoteAddresses();
    }

    @Override
    public boolean validateAddRemoteAddress(JiraServiceContext jiraServiceContext, String remoteAddress, long applicationId) {
        this.validateJiraServiceContext(jiraServiceContext);
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        I18nHelper i18n = jiraServiceContext.getI18nBean();
        if (!this.permissionManager.hasPermission(0, jiraServiceContext.getLoggedInUser())) {
            errorCollection.addErrorMessage(i18n.getText("admin.jaacs.application.admin.required"));
            return false;
        }
        if (StringUtils.isEmpty((String)remoteAddress)) {
            errorCollection.addError("remoteAddresses", i18n.getText("admin.jaacs.application.remote.address.empty"));
            return false;
        }
        if (!IPMatcher.isValidPatternOrHost((String)remoteAddress)) {
            errorCollection.addError("remoteAddresses", i18n.getText("admin.jaacs.application.remote.address.invalid.ip", remoteAddress));
            return false;
        }
        Application app = null;
        try {
            app = this.applicationManager.findById(applicationId);
        }
        catch (ObjectNotFoundException e) {
            errorCollection.addError("remoteAddresses", i18n.getText("admin.jaacs.application.application.invalid"));
            return false;
        }
        Set remoteAddresses = app.getRemoteAddresses();
        if (remoteAddresses.contains(new RemoteAddress(remoteAddress))) {
            errorCollection.addError("remoteAddresses", i18n.getText("admin.jaacs.application.remote.address.duplicate"));
            return false;
        }
        return true;
    }

    @Override
    public boolean addRemoteAddress(JiraServiceContext jiraServiceContext, String remoteAddress, long applicationId) {
        I18nHelper i18n = jiraServiceContext.getI18nBean();
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        if (this.validateAddRemoteAddress(jiraServiceContext, remoteAddress, applicationId)) {
            Application app = null;
            try {
                app = this.applicationManager.findById(applicationId);
            }
            catch (ObjectNotFoundException e) {
                errorCollection.addError("remoteAddresses", i18n.getText("admin.jaacs.application.application.invalid"));
                return false;
            }
            try {
                this.applicationManager.addRemoteAddress(app, new RemoteAddress(remoteAddress));
            }
            catch (ObjectNotFoundException e) {
                errorCollection.addErrorMessage(i18n.getText("admin.jaacs.application.remote.add.address.error", (Object)e));
                log.error((Object)("Exception trying to add remote address: " + (Object)((Object)e)), (Throwable)e);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean validateDeleteApplication(JiraServiceContext jiraServiceContext, long applicationId) {
        this.validateJiraServiceContext(jiraServiceContext);
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        I18nHelper i18n = jiraServiceContext.getI18nBean();
        if (!this.permissionManager.hasPermission(0, jiraServiceContext.getLoggedInUser())) {
            errorCollection.addErrorMessage(i18n.getText("admin.jaacs.application.admin.required"));
            return false;
        }
        try {
            Application app = this.applicationManager.findById(applicationId);
        }
        catch (ObjectNotFoundException e) {
            errorCollection.addError("remoteAddresses", i18n.getText("admin.jaacs.application.application.invalid"));
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteApplication(JiraServiceContext jiraServiceContext, long applicationId) {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        I18nHelper i18n = jiraServiceContext.getI18nBean();
        if (this.validateDeleteApplication(jiraServiceContext, applicationId)) {
            Application app;
            try {
                app = this.applicationManager.findById(applicationId);
            }
            catch (ObjectNotFoundException e) {
                errorCollection.addError("remoteAddresses", i18n.getText("admin.jaacs.application.application.invalid"));
                return false;
            }
            try {
                this.applicationManager.remove(app);
            }
            catch (ApplicationManagerException e) {
                errorCollection.addErrorMessage(i18n.getText("admin.jaacs.application.remote.remove.address.error", (Object)e));
                log.error((Object)("Exception trying to remove application: " + (Object)((Object)e)), (Throwable)e);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean validateResetPassword(JiraServiceContext jiraServiceContext, String password, long applicationId) {
        this.validateJiraServiceContext(jiraServiceContext);
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        I18nHelper i18n = jiraServiceContext.getI18nBean();
        if (!this.permissionManager.hasPermission(0, jiraServiceContext.getLoggedInUser())) {
            errorCollection.addErrorMessage(i18n.getText("admin.jaacs.application.admin.required"));
            return false;
        }
        if (StringUtils.isEmpty((String)password)) {
            errorCollection.addError("credential", i18n.getText("admin.jaacs.application.password.empty"));
            return false;
        }
        return true;
    }

    @Override
    public boolean resetPassword(JiraServiceContext jiraServiceContext, String password, long applicationId) {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        I18nHelper i18n = jiraServiceContext.getI18nBean();
        if (this.validateResetPassword(jiraServiceContext, password, applicationId)) {
            Application app;
            try {
                app = this.applicationManager.findById(applicationId);
            }
            catch (ObjectNotFoundException e) {
                errorCollection.addError("remoteAddresses", i18n.getText("admin.jaacs.application.application.invalid"));
                return false;
            }
            try {
                this.applicationManager.updateCredential(app, new PasswordCredential(password));
            }
            catch (ObjectNotFoundException e) {
                errorCollection.addError("credential", i18n.getText("admin.jaacs.application.remote.set.password.error", (Object)e));
                log.error((Object)("Exception trying to set application password: " + (Object)((Object)e)), (Throwable)e);
            }
            catch (ApplicationManagerException e) {
                errorCollection.addErrorMessage(i18n.getText("admin.jaacs.application.remote.set.password.error", (Object)e));
                log.error((Object)("Exception trying to set application password: " + (Object)((Object)e)), (Throwable)e);
            }
            return true;
        }
        return false;
    }

    @Override
    public List<Application> findAll(User remoteUser) {
        this.ensureIsAdmin(remoteUser);
        List allApplications = this.applicationManager.findAll();
        Collection nonPermanentApplications = Collections2.filter((Collection)allApplications, (Predicate)new ExcludePermanent());
        return Lists.newArrayList((Iterable)nonPermanentApplications);
    }

    @Override
    public ApplicationImpl findById(User remoteUser, Long applicationId) {
        this.ensureIsAdmin(remoteUser);
        try {
            Application app = this.applicationManager.findById(applicationId.longValue());
            return app.isPermanent() ? null : ApplicationImpl.newInstance((Application)app);
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
    }

    @Override
    public void create(User remoteUser, Application application) {
        this.ensureIsAdmin(remoteUser);
        try {
            this.validateApplication(remoteUser, application);
            this.applicationManager.add(application);
        }
        catch (InvalidCredentialException e) {
            throw new ValidationFailureException(this.i18n(remoteUser).getText("admin.jaacs.application.must.be.admin"), (Throwable)e);
        }
        catch (DataAccessException e) {
            throw new ValidationFailureException(this.i18n(remoteUser).getText("admin.jaacs.application.create.failed", application.getName()), (Throwable)e);
        }
    }

    @Override
    public void update(User remoteUser, Application updatedApplication) {
        this.ensureIsAdmin(remoteUser);
        try {
            this.validateApplication(remoteUser, updatedApplication);
            this.applicationManager.update(updatedApplication);
        }
        catch (ObjectNotFoundException e) {
            throw new ValidationFailureException(this.i18n(remoteUser).getText("admin.jaacs.application.not.found", (Object)updatedApplication.getId()), (Throwable)e);
        }
        catch (ApplicationManagerException e) {
            throw new ValidationFailureException(this.i18n(remoteUser).getText("admin.jaacs.application.update.failed", this.displayName(remoteUser, updatedApplication.getId())), (Throwable)e);
        }
        catch (DataAccessException e) {
            throw new ValidationFailureException(this.i18n(remoteUser).getText("admin.jaacs.application.update.failed", this.displayName(remoteUser, updatedApplication.getId())), (Throwable)e);
        }
    }

    protected void validateJiraServiceContext(JiraServiceContext jiraServiceContext) {
        if (jiraServiceContext == null) {
            throw new IllegalArgumentException("The JiraServiceContext must not be null.");
        }
        if (jiraServiceContext.getErrorCollection() == null) {
            throw new IllegalArgumentException("The error collection must not be null.");
        }
    }

    protected void ensureIsAdmin(User remoteUser) throws ValidationFailureException {
        if (!this.permissionManager.hasPermission(0, remoteUser)) {
            throw new ValidationFailureException(this.i18n(remoteUser).getText("admin.jaacs.application.admin.required"));
        }
    }

    protected void validateApplication(User user, Application application) throws ValidationFailureException {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (StringUtils.isBlank((String)application.getName())) {
            errors.addError("name", this.i18n(user).getText("admin.jaacs.application.remote.application.name.required"));
        }
        if (application.getCredential() == null || StringUtils.isBlank((String)application.getCredential().getCredential())) {
            errors.addError("credential", this.i18n(user).getText("admin.jaacs.application.password.empty"));
        }
        for (RemoteAddress remoteAddress : application.getRemoteAddresses()) {
            if (IPMatcher.isValidPatternOrHost((String)remoteAddress.getAddress())) continue;
            errors.addError("remoteAddresses", this.i18n(user).getText("admin.jaacs.application.remote.address.invalid.ip", remoteAddress.getAddress()));
            break;
        }
        if (errors.hasAnyErrors()) {
            throw new ValidationFailureException((ErrorCollection)errors);
        }
    }

    protected String displayName(User remoteUser, Long applicationId) {
        try {
            return this.findById(remoteUser, applicationId).getName();
        }
        catch (RuntimeException e) {
            log.warn((Object)("Could not read application with id: %d" + applicationId), (Throwable)e);
            return String.valueOf(applicationId);
        }
    }

    protected I18nHelper i18n(User user) {
        return this.i18nFactory.getInstance(user);
    }

    static class ExcludePermanent
    implements Predicate<Application> {
        ExcludePermanent() {
        }

        public boolean apply(Application application) {
            return !application.isPermanent();
        }
    }
}

