/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.config.IndexTask;
import com.atlassian.jira.config.ReindexMessage;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.plugin.profile.UserFormatManager;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskMatcher;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.util.HelpUtil;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Date;

@EventComponent
public class DefaultReindexMessageManager
implements ReindexMessageManager {
    static final String PS_KEY = "admin.message.manager";
    static final String PS_KEY_USER = "user";
    static final String PS_KEY_TASK = "task";
    static final String PS_KEY_TIME = "time";
    private final UserKeyService userKeyService;
    private final UserFormatManager userFormatManager;
    private final I18nHelper.BeanFactory i18nFactory;
    private final OutlookDateManager outlookDateManager;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final ResettableLazyReference<PropertySet> propertiesReference;
    private final PermissionManager permissionManager;
    private final TaskManager taskManager;

    public DefaultReindexMessageManager(final JiraPropertySetFactory jiraPropertySetFactory, UserKeyService userKeyService, UserFormatManager userFormatManager, I18nHelper.BeanFactory i18nFactory, OutlookDateManager outlookDateManager, VelocityRequestContextFactory velocityRequestContextFactory, PermissionManager permissionManager, TaskManager taskManager) {
        this.permissionManager = (PermissionManager)Assertions.notNull((String)"permissionManager", (Object)permissionManager);
        this.velocityRequestContextFactory = (VelocityRequestContextFactory)Assertions.notNull((String)"velocityRequestContextFactory", (Object)velocityRequestContextFactory);
        this.userKeyService = (UserKeyService)Assertions.notNull((String)"userKeyService", (Object)userKeyService);
        this.userFormatManager = (UserFormatManager)Assertions.notNull((String)"userFormatManager", (Object)userFormatManager);
        this.i18nFactory = (I18nHelper.BeanFactory)Assertions.notNull((String)"i18nFactory", (Object)i18nFactory);
        this.outlookDateManager = (OutlookDateManager)Assertions.notNull((String)"outlookDateManager", (Object)outlookDateManager);
        this.taskManager = (TaskManager)Assertions.notNull((String)"taskManager", (Object)taskManager);
        this.propertiesReference = new ResettableLazyReference<PropertySet>(){

            protected PropertySet create() throws Exception {
                return jiraPropertySetFactory.buildCachingDefaultPropertySet(DefaultReindexMessageManager.PS_KEY, true);
            }
        };
    }

    @EventListener
    public synchronized void onClearCache(ClearCacheEvent event) {
        this.propertiesReference.reset();
    }

    public synchronized void pushMessage(User user, String i18nTask) {
        String key = ApplicationUsers.getKeyFor((User)user);
        ((PropertySet)this.propertiesReference.get()).setString(PS_KEY_USER, key == null ? "" : key);
        ((PropertySet)this.propertiesReference.get()).setString(PS_KEY_TASK, i18nTask);
        ((PropertySet)this.propertiesReference.get()).setDate(PS_KEY_TIME, this.getCurrentDate());
    }

    public synchronized void clear() {
        PropertySet propertySet = (PropertySet)this.propertiesReference.get();
        if (propertySet.exists(PS_KEY_USER)) {
            propertySet.remove(PS_KEY_TIME);
            propertySet.remove(PS_KEY_TASK);
            propertySet.remove(PS_KEY_USER);
        }
    }

    public synchronized String getMessage(User user) {
        TaskDescriptor<Object> task = this.findActiveIndexTasks();
        PropertySet propertySet = (PropertySet)this.propertiesReference.get();
        if (propertySet.exists(PS_KEY_USER) && this.permissionManager.hasPermission(0, user)) {
            String userKey = propertySet.getString(PS_KEY_USER);
            String i18nTaskKey = propertySet.getString(PS_KEY_TASK);
            Date time = propertySet.getDate(PS_KEY_TIME);
            if (task == null || task.isFinished()) {
                return this.getReindexRequiredMessage(user, userKey, i18nTaskKey, time);
            }
            Date startedTimestamp = task.getStartedTimestamp();
            if (startedTimestamp != null && startedTimestamp.before(time)) {
                return this.getReindexRestartRequiredMessage(user, userKey, i18nTaskKey, time);
            }
        }
        if (task != null && task.isStarted() && !task.isFinished()) {
            I18nHelper i18n = this.i18nFactory.getInstance(user);
            return ((IndexTask)task.getTaskContext()).getTaskInProgressMessage(i18n);
        }
        return null;
    }

    private String getReindexRequiredMessage(User user, String userKey, String i18nTaskKey, Date time) {
        I18nHelper i18n = this.i18nFactory.getInstance(user);
        OutlookDate outlookDate = this.outlookDateManager.getOutlookDate(i18n.getLocale());
        String userFullName = this.userFormatManager.formatUserkey(userKey, "fullName", "fullName");
        String i18nTask = i18n.getText(i18nTaskKey);
        String timeString = outlookDate.formatDMYHMS(time);
        HelpUtil helpUtil = HelpUtil.getInstance();
        HelpUtil.HelpPath path = helpUtil.getHelpPath("reindex_after_configuration_changes");
        String reindexLink = String.format("<a href=\"%s\" data-helplink=\"online\" target=\"_jirahelp\">", path.getUrl().toString());
        StringBuilder message = new StringBuilder();
        if (userFullName == null) {
            message.append("<p>").append(i18n.getText("admin.notifications.task.requires.reindex.nouser", (Object)new Object[]{i18nTask, timeString, reindexLink, "</a>"}));
        } else {
            message.append("<p>").append(i18n.getText("admin.notifications.task.requires.reindex", (Object)new Object[]{userFullName, i18nTask, timeString, reindexLink, "</a>"}));
        }
        message.append("<p>").append(i18n.getText("admin.notifications.reindex.now", "<a href='" + this.getContextPath() + "/secure/admin/jira/IndexAdmin.jspa'>", "</a>"));
        message.append("<p>").append(i18n.getText("admin.notifications.complete.all.changes"));
        return message.toString();
    }

    private String getReindexRestartRequiredMessage(User user, String userKey, String i18nTaskKey, Date time) {
        I18nHelper i18n = this.i18nFactory.getInstance(user);
        OutlookDate outlookDate = this.outlookDateManager.getOutlookDate(i18n.getLocale());
        String userFullName = this.userFormatManager.formatUserkey(userKey, "fullName", "fullName");
        String i18nTask = i18n.getText(i18nTaskKey);
        String timeString = outlookDate.formatDMYHMS(time);
        HelpUtil helpUtil = HelpUtil.getInstance();
        HelpUtil.HelpPath path = helpUtil.getHelpPath("reindex_after_configuration_changes");
        String reindexLink = String.format("<a href=\"%s\" data-helplink=\"online\" target=\"_jirahelp\">", path.getUrl().toString());
        StringBuilder message = new StringBuilder();
        if (userFullName == null) {
            String text = i18n.getText("admin.notifications.task.requires.reindex.restart.nouser", (Object)new Object[]{i18nTask, timeString, reindexLink, "</a>"});
            message.append("<p>").append(text);
        } else {
            String text = i18n.getText("admin.notifications.task.requires.reindex.restart", (Object)new Object[]{userFullName, i18nTask, timeString, reindexLink, "</a>"});
            message.append("<p>").append(text);
        }
        message.append("<p>").append(i18n.getText("admin.notifications.reindex.now", "<a href='" + this.getContextPath() + "/secure/admin/jira/IndexAdmin.jspa'>", "</a>"));
        message.append("<p>").append(i18n.getText("admin.notifications.complete.all.changes"));
        return message.toString();
    }

    public synchronized ReindexMessage getMessageObject() {
        PropertySet propertySet = (PropertySet)this.propertiesReference.get();
        if (propertySet.exists(PS_KEY_USER)) {
            String userKey = propertySet.getString(PS_KEY_USER);
            String i18nTaskKey = propertySet.getString(PS_KEY_TASK);
            Date time = propertySet.getDate(PS_KEY_TIME);
            String userName = this.userKeyService.getUsernameForKey(userKey);
            if (userName == null) {
                userName = userKey;
            }
            return new ReindexMessage(userName, time, i18nTaskKey);
        }
        return null;
    }

    public synchronized void clearMessageForTimestamp(Date time) {
        Date messageTime;
        if (((PropertySet)this.propertiesReference.get()).exists(PS_KEY_TIME) && !time.before(messageTime = ((PropertySet)this.propertiesReference.get()).getDate(PS_KEY_TIME))) {
            this.clear();
        }
    }

    String getContextPath() {
        return this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
    }

    Date getCurrentDate() {
        return new Date(System.currentTimeMillis());
    }

    private TaskDescriptor<Object> findActiveIndexTasks() {
        return this.taskManager.findFirstTask(new TaskMatcher(){

            @Override
            public boolean match(TaskDescriptor<?> descriptor) {
                return !descriptor.isFinished() && descriptor.getTaskContext() instanceof IndexTask;
            }
        });
    }
}

