/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cache.LazyLoadingCache;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.IssueConstantFactory;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.TextIssueConstant;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@EventComponent
public class DefaultConstantsManager
implements ConstantsManager {
    private static final Logger log = Logger.getLogger(DefaultConstantsManager.class);
    private static final List<String> DEFAULT_CONSTANTS_SORT = Collections.singletonList("sequence ASC");
    private static final List<String> DEFAULT_ISSUE_TYPE_SORT = ImmutableList.of((Object)"style", (Object)"name");
    private final LazyLoadingCache<ConstantsCache<Priority>> priorityCache = new LazyLoadingCache<ConstantsCache<Priority>>(new PriorityCacheLoader());
    private final LazyLoadingCache<ConstantsCache<Resolution>> resolutionCache = new LazyLoadingCache<ConstantsCache<Resolution>>(new ResolutionCacheLoader());
    private final LazyLoadingCache<ConstantsCache<Status>> statusCache = new LazyLoadingCache<ConstantsCache<Status>>(new StatusCacheLoader());
    private final LazyLoadingCache<IssueTypeCache> issueTypeCache = new LazyLoadingCache<IssueTypeCache>(new IssueTypeCacheLoader());
    private final IssueConstant UNRESOLVED_RESOLUTION;
    private final JiraAuthenticationContext authenticationContext;
    private final OfBizDelegator ofBizDelegator;
    private final IssueConstantFactory issueConstantFactory;

    public DefaultConstantsManager(JiraAuthenticationContext authenticationContext, OfBizDelegator ofBizDelegator, IssueConstantFactory issueConstantFactory) {
        this.issueConstantFactory = issueConstantFactory;
        this.authenticationContext = authenticationContext;
        this.ofBizDelegator = ofBizDelegator;
        this.UNRESOLVED_RESOLUTION = new TextIssueConstant("common.status.unresolved", "common.status.unresolved", null, authenticationContext);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent ignored) {
        this.refresh();
    }

    public Collection<GenericValue> getStatuses() {
        return this.statusCache.getData().getGenericValues();
    }

    public Collection<Status> getStatusObjects() {
        return this.statusCache.getData().getObjects();
    }

    public GenericValue getStatus(String id) {
        return this.convertToGenericValue((IssueConstant)this.getStatusObject(id));
    }

    public Status getStatusObject(String id) {
        return this.statusCache.getData().getObject(id);
    }

    public void refreshStatuses() {
        this.statusCache.reload();
    }

    public IssueConstant getConstantObject(String constantType, String id) {
        if ("Priority".equalsIgnoreCase(constantType)) {
            return this.getPriorityObject(id);
        }
        if ("Status".equalsIgnoreCase(constantType)) {
            return this.getStatusObject(id);
        }
        if ("Resolution".equalsIgnoreCase(constantType)) {
            return this.getResolutionObject(id);
        }
        if ("IssueType".equalsIgnoreCase(constantType)) {
            return this.getIssueTypeObject(id);
        }
        return null;
    }

    public Collection getConstantObjects(String constantType) {
        if ("Priority".equalsIgnoreCase(constantType)) {
            return this.getPriorityObjects();
        }
        if ("Status".equalsIgnoreCase(constantType)) {
            return this.getStatusObjects();
        }
        if ("Resolution".equalsIgnoreCase(constantType)) {
            return this.getResolutionObjects();
        }
        if ("IssueType".equalsIgnoreCase(constantType)) {
            return this.getAllIssueTypeObjects();
        }
        return null;
    }

    public List<IssueConstant> convertToConstantObjects(String constantType, Collection ids) {
        if (ids != null && !ids.isEmpty() && constantType != null) {
            ArrayList<IssueConstant> list = new ArrayList<IssueConstant>(ids.size());
            for (Object o : ids) {
                String id = o instanceof GenericValue ? ((GenericValue)o).getString("id") : (String)o;
                Object constant = null;
                if ("Priority".equalsIgnoreCase(constantType)) {
                    constant = this.getPriorityObject(id);
                } else if ("Status".equalsIgnoreCase(constantType)) {
                    constant = this.getStatusObject(id);
                } else if ("Resolution".equalsIgnoreCase(constantType)) {
                    constant = "-1".equals(id) ? this.UNRESOLVED_RESOLUTION : this.getResolutionObject(id);
                } else if ("IssueType".equalsIgnoreCase(constantType)) {
                    constant = this.getIssueTypeObject(id);
                }
                if (constant != null) {
                    list.add((IssueConstant)constant);
                    continue;
                }
                log.warn((Object)(id + " returned a null constant of type " + constantType));
            }
            return list;
        }
        return null;
    }

    public boolean constantExists(String constantType, String name) {
        return this.getIssueConstantByName(constantType, name) != null;
    }

    public IssueConstant getIssueConstantByName(String constantType, String name) {
        ConstantsCache<? extends IssueConstant> constantsCache = this.getConstantsCache(constantType);
        for (IssueConstant issueConstant : constantsCache.getObjects()) {
            if (!(name == null ? issueConstant.getName() == null : name.equals(issueConstant.getName()))) continue;
            return issueConstant;
        }
        return null;
    }

    public GenericValue getConstantByName(String constantType, String name) {
        return this.convertToGenericValue(this.getIssueConstantByName(constantType, name));
    }

    private GenericValue convertToGenericValue(IssueConstant issueConstant) {
        if (issueConstant == null) {
            return null;
        }
        return issueConstant.getGenericValue();
    }

    public IssueConstant getConstantByNameIgnoreCase(String constantType, String name) {
        ConstantsCache<? extends IssueConstant> constantsCache = this.getConstantsCache(constantType);
        for (IssueConstant issueConstant : constantsCache.getObjects()) {
            if (!(name == null ? issueConstant.getName() == null : name.equalsIgnoreCase(issueConstant.getName()))) continue;
            return issueConstant;
        }
        return null;
    }

    private ConstantsCache<? extends IssueConstant> getConstantsCache(String constantType) {
        if ("Priority".equalsIgnoreCase(constantType)) {
            return this.priorityCache.getData();
        }
        if ("Status".equalsIgnoreCase(constantType)) {
            return this.statusCache.getData();
        }
        if ("Resolution".equalsIgnoreCase(constantType)) {
            return this.resolutionCache.getData();
        }
        if ("IssueType".equalsIgnoreCase(constantType)) {
            return this.issueTypeCache.getData();
        }
        throw new IllegalArgumentException("Unknown constant type '" + constantType + "'.");
    }

    public GenericValue createIssueType(String name, Long sequence, String style, String description, String iconurl) throws CreateException {
        GenericValue createdIssueType;
        try {
            Map fields = MapBuilder.newBuilder().add((Object)"id", (Object)EntityUtils.getNextStringId("IssueType")).add((Object)"name", (Object)name).add((Object)"sequence", (Object)sequence).add((Object)"style", (Object)StringUtils.trimToNull((String)style)).add((Object)"description", (Object)description).add((Object)"iconurl", (Object)iconurl).toMap();
            createdIssueType = EntityUtils.createValue("IssueType", fields);
        }
        catch (DataAccessException e) {
            throw new CreateException("Error occurred while creating issue type with name='" + name + "' sequence='" + sequence + "' style='" + style + "' description='" + description + "' iconurl='" + iconurl + "'.", (Exception)((Object)e));
        }
        this.refreshIssueTypes();
        return createdIssueType;
    }

    public IssueType insertIssueType(String name, Long sequence, String style, String description, String iconurl) throws CreateException {
        GenericValue createdIssueType = this.createIssueType(name, sequence, style, description, iconurl);
        return this.issueConstantFactory.createIssueType(createdIssueType);
    }

    public void validateCreateIssueType(String name, String style, String description, String iconurl, ErrorCollection errors, String nameFieldName) {
        if (StringUtils.isBlank((String)name)) {
            errors.addError(nameFieldName, this.authenticationContext.getI18nHelper().getText("admin.errors.must.specify.name"));
        } else if (StringUtils.length((String)name) > 60) {
            errors.addError(nameFieldName, this.authenticationContext.getI18nHelper().getText("admin.errors.issuetypes.name.must.not.exceed.max.length"));
        } else {
            for (IssueType issueType : this.getAllIssueTypeObjects()) {
                if (!name.trim().equalsIgnoreCase(issueType.getName())) continue;
                errors.addError(nameFieldName, this.authenticationContext.getI18nHelper().getText("admin.errors.issue.type.with.this.name.already.exists"));
                break;
            }
        }
        if (StringUtils.isBlank((String)iconurl)) {
            errors.addError("iconurl", this.authenticationContext.getI18nHelper().getText("admin.errors.must.specify.url.for.issue.type"));
        }
    }

    public void updateIssueType(String id, String name, Long sequence, String style, String description, String iconurl) throws DataAccessException {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null.");
        }
        try {
            GenericValue issueTypeGV = EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("IssueType", (Map)new FieldMap("id", (Object)id)));
            if (issueTypeGV == null) {
                throw new IllegalArgumentException("Issue Type with id '" + id + "' does not exist.");
            }
            issueTypeGV.set("name", (Object)name);
            issueTypeGV.set("sequence", (Object)sequence);
            issueTypeGV.set("style", (Object)style);
            issueTypeGV.set("description", (Object)description);
            issueTypeGV.set("iconurl", (Object)iconurl);
            issueTypeGV.store();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Error occurred while updating issue type with id '" + id + "'.");
        }
        this.refreshIssueTypes();
    }

    public void removeIssueType(String id) throws RemoveException {
        GenericValue issueTypeGV = this.getIssueType(id);
        if (issueTypeGV != null) {
            try {
                issueTypeGV.remove();
                this.refreshIssueTypes();
            }
            catch (GenericEntityException e) {
                throw new RemoveException("Error occurred while removing issute type with id '" + id + "'.", (Exception)((Object)e));
            }
        } else {
            throw new RemoveException("Issue type with id '" + id + "' does not exist.");
        }
    }

    public void storeIssueTypes(List<GenericValue> issueTypes) throws DataAccessException {
        try {
            this.ofBizDelegator.storeAll(issueTypes);
        }
        catch (DataAccessException e) {
            throw new DataAccessException("Error occurred while storing issue types to the database.", (Throwable)e);
        }
        this.refreshIssueTypes();
    }

    public void refresh() {
        this.priorityCache.reset();
        this.resolutionCache.reset();
        this.issueTypeCache.reset();
        this.statusCache.reset();
    }

    public List<String> expandIssueTypeIds(Collection<String> issueTypeIds) {
        if (issueTypeIds == null) {
            return Collections.emptyList();
        }
        for (String issueTypeId : issueTypeIds) {
            if ("-2".equals(issueTypeId)) {
                return DefaultConstantsManager.getIds(this.getIssueTypes());
            }
            if ("-3".equals(issueTypeId)) {
                return DefaultConstantsManager.getIds(this.getSubTaskIssueTypes());
            }
            if (!"-4".equals(issueTypeId)) continue;
            return this.getAllIssueTypeIds();
        }
        return new ArrayList<String>(issueTypeIds);
    }

    public List<String> getAllIssueTypeIds() {
        return this.issueTypeCache.getData().getCachedIds();
    }

    public IssueConstant getIssueConstant(GenericValue issueConstantGV) {
        if (issueConstantGV == null) {
            return null;
        }
        if ("IssueType".equals(issueConstantGV.getEntityName())) {
            return this.getIssueTypeObject(issueConstantGV.getString("id"));
        }
        if ("Status".equals(issueConstantGV.getEntityName())) {
            return this.getStatusObject(issueConstantGV.getString("id"));
        }
        if ("Priority".equals(issueConstantGV.getEntityName())) {
            return this.getPriorityObject(issueConstantGV.getString("id"));
        }
        if ("Resolution".equals(issueConstantGV.getEntityName())) {
            return this.getResolutionObject(issueConstantGV.getString("id"));
        }
        throw new IllegalArgumentException("Unknown constant entity name '" + issueConstantGV.getEntityName() + "'.");
    }

    private static List<String> getIds(Collection<GenericValue> issueTypes) {
        ArrayList<String> ids = new ArrayList<String>(issueTypes.size());
        for (GenericValue issueTypeGV : issueTypes) {
            ids.add(issueTypeGV.getString("id"));
        }
        return ids;
    }

    public Collection<GenericValue> getPriorities() {
        return this.priorityCache.getData().getGenericValues();
    }

    public Collection<Priority> getPriorityObjects() {
        return this.priorityCache.getData().getObjects();
    }

    public Priority getPriorityObject(String id) {
        return this.priorityCache.getData().getObject(id);
    }

    public Priority getDefaultPriorityObject() {
        String defaultPriorityId = ComponentAccessor.getApplicationProperties().getString("jira.constant.default.priority");
        if (defaultPriorityId == null) {
            Collection<Priority> priorities = this.getPriorityObjects();
            Priority defaultPriority = null;
            Iterator<Priority> priorityIt = priorities.iterator();
            int times = (int)Math.ceil((double)priorities.size() / 2.0);
            for (int i = 0; i < times; ++i) {
                defaultPriority = priorityIt.next();
            }
            return defaultPriority;
        }
        return this.getPriorityObject(defaultPriorityId);
    }

    public GenericValue getDefaultPriority() {
        Priority defaultPriority = this.getDefaultPriorityObject();
        return defaultPriority == null ? null : defaultPriority.getGenericValue();
    }

    public String getPriorityName(String id) {
        if ("-1".equals(id)) {
            return this.authenticationContext.getI18nHelper().getText("constants.manager.no.priority");
        }
        return this.getPriorityObject(id).getName();
    }

    public Resolution getResolutionObject(String id) {
        return this.resolutionCache.getData().getObject(id);
    }

    public void refreshPriorities() {
        this.priorityCache.reload();
    }

    public Collection<GenericValue> getResolutions() {
        return this.resolutionCache.getData().getGenericValues();
    }

    public Collection<Resolution> getResolutionObjects() {
        return this.resolutionCache.getData().getObjects();
    }

    public GenericValue getResolution(String id) {
        return this.convertToGenericValue((IssueConstant)this.getResolutionObject(id));
    }

    public void refreshResolutions() {
        this.resolutionCache.reload();
    }

    public Collection<GenericValue> getIssueTypes() {
        return this.issueTypeCache.getData().getRegularIssueTypes();
    }

    public Collection<IssueType> getAllIssueTypeObjects() {
        return this.issueTypeCache.getData().getObjects();
    }

    public Collection<IssueType> getRegularIssueTypeObjects() {
        return this.issueTypeCache.getData().getRegularIssueTypeObjects();
    }

    public Collection<IssueType> getSubTaskIssueTypeObjects() {
        return this.issueTypeCache.getData().getSubTaskIssueTypeObjects();
    }

    public Status getStatusByName(String name) {
        Collection<Status> statusObjects = this.getStatusObjects();
        return this.findByName(name, statusObjects);
    }

    public Status getStatusByTranslatedName(String name) {
        Collection<Status> statusObjects = this.getStatusObjects();
        Status status = this.findByTranslatedName(name, statusObjects);
        if (status == null) {
            status = this.findByName(name, statusObjects);
        }
        return status;
    }

    private Status findByName(final String name, Collection<Status> statusObjects) {
        try {
            return (Status)Iterables.find(statusObjects, (Predicate)new Predicate<Status>(){

                public boolean apply(@Nullable Status statusObject) {
                    return statusObject.getName().equals(name);
                }
            });
        }
        catch (NoSuchElementException notFound) {
            return null;
        }
    }

    private Status findByTranslatedName(final String name, Collection<Status> statusObjects) {
        try {
            return (Status)Iterables.find(statusObjects, (Predicate)new Predicate<Status>(){

                public boolean apply(@Nullable Status statusObject) {
                    return statusObject.getNameTranslation().equals(name);
                }
            });
        }
        catch (NoSuchElementException notFound) {
            return null;
        }
    }

    public Collection<GenericValue> getSubTaskIssueTypes() {
        return this.issueTypeCache.getData().getSubTaskIssueTypes();
    }

    public List<GenericValue> getEditableSubTaskIssueTypes() {
        return this.ofBizDelegator.findByField("IssueType", "style", (Object)"jira_subtask", "name");
    }

    public List<GenericValue> getAllIssueTypes() {
        return this.issueTypeCache.getData().getGenericValues();
    }

    public GenericValue getIssueType(String id) {
        return this.convertToGenericValue((IssueConstant)this.getIssueTypeObject(id));
    }

    public IssueType getIssueTypeObject(String id) {
        return (IssueType)this.issueTypeCache.getData().getObject(id);
    }

    public void refreshIssueTypes() {
        this.issueTypeCache.reload();
    }

    private List<GenericValue> getConstants(String type) {
        return this.getConstantsWithSort(type, DEFAULT_CONSTANTS_SORT);
    }

    private List<GenericValue> getConstantsWithSort(String type, List<String> sortList) {
        try {
            return this.ofBizDelegator.findAll(type, sortList);
        }
        catch (Exception e) {
            log.error((Object)("Error getting constants of type: " + type + " : " + e), (Throwable)e);
            return null;
        }
    }

    private class IssueTypeCacheLoader
    implements LazyLoadingCache.CacheLoader<IssueTypeCache> {
        private IssueTypeCacheLoader() {
        }

        @Override
        public IssueTypeCache loadData() {
            List allIssueTypeGVs = DefaultConstantsManager.this.getConstantsWithSort("IssueType", DEFAULT_ISSUE_TYPE_SORT);
            LinkedHashMap<String, IssueType> idObjectMap = new LinkedHashMap<String, IssueType>();
            ArrayList<IssueType> regularIssueTypeObjects = new ArrayList<IssueType>();
            ArrayList<GenericValue> regularIssueTypes = new ArrayList<GenericValue>();
            ArrayList<IssueType> subTaskIssueTypeObjects = new ArrayList<IssueType>();
            ArrayList<GenericValue> subTaskIssueTypes = new ArrayList<GenericValue>();
            for (GenericValue issueTypeGV : allIssueTypeGVs) {
                IssueType issueType = DefaultConstantsManager.this.issueConstantFactory.createIssueType(issueTypeGV);
                if (issueType.isSubTask()) {
                    subTaskIssueTypeObjects.add(issueType);
                    subTaskIssueTypes.add(issueTypeGV);
                } else {
                    regularIssueTypeObjects.add(issueType);
                    regularIssueTypes.add(issueTypeGV);
                }
                idObjectMap.put(issueType.getId(), issueType);
            }
            return new IssueTypeCache(allIssueTypeGVs, idObjectMap, regularIssueTypeObjects, regularIssueTypes, subTaskIssueTypeObjects, subTaskIssueTypes);
        }
    }

    private class StatusCacheLoader
    implements LazyLoadingCache.CacheLoader<ConstantsCache<Status>> {
        private StatusCacheLoader() {
        }

        @Override
        public ConstantsCache<Status> loadData() {
            List statuses = DefaultConstantsManager.this.getConstants("Status");
            LinkedHashMap<String, Status> statusObjectsMap = new LinkedHashMap<String, Status>();
            for (GenericValue statusGV : statuses) {
                statusObjectsMap.put(statusGV.getString("id"), DefaultConstantsManager.this.issueConstantFactory.createStatus(statusGV));
            }
            return new ConstantsCache<Status>(statuses, statusObjectsMap);
        }
    }

    private class ResolutionCacheLoader
    implements LazyLoadingCache.CacheLoader<ConstantsCache<Resolution>> {
        private ResolutionCacheLoader() {
        }

        @Override
        public ConstantsCache<Resolution> loadData() {
            List resolutions = DefaultConstantsManager.this.getConstants("Resolution");
            LinkedHashMap<String, Resolution> resolutionObjectsMap = new LinkedHashMap<String, Resolution>();
            for (GenericValue resolutionGV : resolutions) {
                Resolution resolution = DefaultConstantsManager.this.issueConstantFactory.createResolution(resolutionGV);
                resolutionObjectsMap.put(resolutionGV.getString("id"), resolution);
            }
            return new ConstantsCache<Resolution>(resolutions, resolutionObjectsMap);
        }
    }

    private class PriorityCacheLoader
    implements LazyLoadingCache.CacheLoader<ConstantsCache<Priority>> {
        private PriorityCacheLoader() {
        }

        @Override
        public ConstantsCache<Priority> loadData() {
            List priorities = DefaultConstantsManager.this.getConstants("Priority");
            LinkedHashMap<String, Priority> priorityObjectsMap = new LinkedHashMap<String, Priority>();
            for (GenericValue priorityGV : priorities) {
                Priority priority = DefaultConstantsManager.this.issueConstantFactory.createPriority(priorityGV);
                priorityObjectsMap.put(priorityGV.getString("id"), priority);
            }
            return new ConstantsCache<Priority>(priorities, priorityObjectsMap);
        }
    }

    private static class IssueTypeCache
    extends ConstantsCache<IssueType> {
        private final List<IssueType> regularIssueTypeObjects;
        private final List<GenericValue> regularIssueTypes;
        private final List<IssueType> subTaskIssueTypeObjects;
        private final List<GenericValue> subTaskIssueTypes;

        public IssueTypeCache(List<GenericValue> gvList, Map<String, IssueType> idObjectMap, List<IssueType> regularIssueTypeObjects, List<GenericValue> regularIssueTypes, List<IssueType> subTaskIssueTypeObjects, List<GenericValue> subTaskIssueTypes) {
            super(gvList, idObjectMap);
            this.regularIssueTypeObjects = Collections.unmodifiableList(regularIssueTypeObjects);
            this.regularIssueTypes = Collections.unmodifiableList(regularIssueTypes);
            this.subTaskIssueTypeObjects = Collections.unmodifiableList(subTaskIssueTypeObjects);
            this.subTaskIssueTypes = Collections.unmodifiableList(subTaskIssueTypes);
        }

        public List<IssueType> getRegularIssueTypeObjects() {
            return this.regularIssueTypeObjects;
        }

        public List<GenericValue> getRegularIssueTypes() {
            return this.regularIssueTypes;
        }

        public List<IssueType> getSubTaskIssueTypeObjects() {
            return this.subTaskIssueTypeObjects;
        }

        public List<GenericValue> getSubTaskIssueTypes() {
            return this.subTaskIssueTypes;
        }
    }

    private static class ConstantsCache<T extends IssueConstant> {
        private final List<GenericValue> gvList;
        private final Map<String, T> idObjectMap;
        private final List<String> idList;

        public ConstantsCache(List<GenericValue> gvList, Map<String, T> idObjectMap) {
            this.gvList = Collections.unmodifiableList(gvList);
            this.idObjectMap = Collections.unmodifiableMap(idObjectMap);
            List ids = DefaultConstantsManager.getIds(gvList);
            this.idList = Collections.unmodifiableList(ids);
        }

        List<GenericValue> getGenericValues() {
            return this.gvList;
        }

        Collection<T> getObjects() {
            return this.idObjectMap.values();
        }

        T getObject(String id) {
            return (T)((IssueConstant)this.idObjectMap.get(id));
        }

        List<String> getCachedIds() {
            return this.idList;
        }
    }
}

