/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class OfBizClusterNodeStore {
    private static final String ENTITY = "ClusterNode";
    public static final String NODE_ID = "nodeId";
    public static final String NODE_STATE = "nodeState";
    private final OfBizDelegator ofBizDelegator;

    public OfBizClusterNodeStore(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    public Node createNode(@Nonnull String nodeId, @Nonnull Node.NodeState state) {
        Node node = new Node(nodeId, state);
        return this.storeFieldMap(this.getFields(node), true);
    }

    public Node storeNode(@Nonnull String nodeId, @Nonnull Node.NodeState state) {
        Node node = new Node(nodeId, state);
        return this.storeFieldMap(this.getFields(node), false);
    }

    public int deleteNode(Node node) {
        return this.ofBizDelegator.removeByCondition(ENTITY, (EntityCondition)new EntityExpr(NODE_ID, EntityOperator.EQUALS, (Object)node.getNodeId()));
    }

    public Node getNode(String nodeId) {
        Node node = null;
        GenericValue gv = this.ofBizDelegator.findByPrimaryKey(ENTITY, this.getPkFields(nodeId));
        if (gv != null) {
            node = this.fromGv(gv);
        }
        return node;
    }

    public List<Node> getAllNodes() {
        return this.findNodes(null, null);
    }

    public List<Node> findNodes(EntityCondition condition, List<String> orderBy) {
        return Lists.transform((List)this.ofBizDelegator.findByCondition(ENTITY, condition, null, orderBy), (Function)new Function<GenericValue, Node>(){

            public Node apply(@Nullable GenericValue gv) {
                return OfBizClusterNodeStore.this.fromGv(gv);
            }
        });
    }

    private Node fromGv(@Nonnull GenericValue gv) {
        return new Node(gv.getString(NODE_ID), Node.NodeState.valueOf(gv.getString(NODE_STATE)));
    }

    private Node storeFieldMap(@Nonnull Map<String, Object> fields, boolean create) {
        GenericValue gv = this.ofBizDelegator.makeValue(ENTITY, fields);
        try {
            if (create) {
                gv.create();
            } else {
                gv.store();
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Problem storing node", (Throwable)e);
        }
        return this.fromGv(gv);
    }

    private Map<String, Object> getFields(Node node) {
        return new FieldMap(NODE_ID, (Object)node.getNodeId()).add(NODE_STATE, (Object)node.getState().toString());
    }

    private Map<String, Object> getPkFields(String nodeId) {
        return new FieldMap(NODE_ID, (Object)nodeId);
    }
}

