/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cluster.FailoverProperties;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

@EventComponent
public class FailoverPropertiesImpl
implements FailoverProperties {
    private static final Logger log = Logger.getLogger(FailoverPropertiesImpl.class);
    public static final String JIRA_FAILOVER_CONFIG_PROPERTIES = "jira-ha.properties";
    public static final String JIRA_SHARED_HOME = "jira.shared.home";
    public static final String JIRA_NODE_ID = "jira.node.id";
    private static final int PROPERTY_COUNT = 2;
    private final File overlayFile;
    private final JiraHome jiraHome;
    private final ResettableLazyReference<Map<String, String>> failoverPropertiesRef = new ResettableLazyReference<Map<String, String>>(){

        protected Map<String, String> create() throws Exception {
            return Maps.fromProperties((Properties)this.loadProperties());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Properties loadProperties() {
            FileInputStream in;
            Properties properties;
            block4: {
                properties = new Properties();
                in = null;
                try {
                    if (!FailoverPropertiesImpl.this.overlayFile.exists()) break block4;
                    in = new FileInputStream(FailoverPropertiesImpl.this.overlayFile);
                    properties.load(in);
                }
                catch (IOException e) {
                    try {
                        log.warn((Object)("Could not load config properties from '" + FailoverPropertiesImpl.this.overlayFile + "'."));
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(in);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)in);
                }
            }
            IOUtils.closeQuietly(in);
            return properties;
        }
    };

    public FailoverPropertiesImpl(JiraHome jiraHome) {
        this.jiraHome = jiraHome;
        this.overlayFile = new File(jiraHome.getLocalHomePath(), JIRA_FAILOVER_CONFIG_PROPERTIES);
    }

    @Override
    @Nullable
    public String getProperty(String property) {
        return (String)((Map)this.failoverPropertiesRef.get()).get(property);
    }

    @Override
    public String getSharedHome() {
        return this.getProperty(JIRA_SHARED_HOME);
    }

    @Override
    public String getNodeId() {
        return this.getProperty(JIRA_NODE_ID);
    }

    @Override
    public void refresh() {
        this.failoverPropertiesRef.reset();
    }

    @Override
    public boolean propertyFileExists() {
        return this.overlayFile.exists();
    }

    @Override
    public boolean isValid() {
        return this.propertyFileExists() && this.allPropertiesExist();
    }

    private boolean allPropertiesExist() {
        Map properties = (Map)this.failoverPropertiesRef.get();
        int count = properties.size();
        boolean containsNulls = properties.containsValue(null);
        return count == 2 && !containsNulls;
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }
}

