/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.cache.CacheManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cluster.ClusterStateException;
import com.atlassian.jira.cluster.FailoverProperties;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.NodeStateManager;
import com.atlassian.jira.cluster.NotClusteredException;
import com.atlassian.jira.cluster.OfBizClusterNodeStore;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.cluster.NodeActivatedEvent;
import com.atlassian.jira.event.cluster.NodeActivatingEvent;
import com.atlassian.jira.event.cluster.NodePassivatedEvent;
import com.atlassian.jira.event.cluster.NodePassivatingEvent;
import com.atlassian.jira.plugin.scheduler.LifecycleAwarePluginScheduler;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.TransactionSupport;
import com.atlassian.jira.user.util.DirectorySynchroniserBarrier;
import com.atlassian.jira.util.ComponentFactory;
import com.atlassian.jira.util.system.JiraSystemRestarter;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.sal.api.scheduling.PluginScheduler;
import com.atlassian.util.concurrent.ResettableLazyReference;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;

@EventComponent
public class DefaultNodeStateManager
implements NodeStateManager {
    private static final Logger log = Logger.getLogger(DefaultNodeStateManager.class);
    private static final int WAIT_SECONDS = 20;
    private final EventPublisher eventPublisher;
    private final OfBizClusterNodeStore ofBizClusterNodeStore;
    private final FailoverProperties failoverProperties;
    private final Scheduler scheduler;
    private final ComponentFactory componentFactory;
    private final TaskManager taskManager;
    private final TransactionSupport transactionSupport;
    private final MailQueue mailQueue;
    private final JiraSystemRestarter jiraSystemRestarter;
    private final CacheManager cacheManager;
    private ResettableLazyReference<Node> nodeRef = new ResettableLazyReference<Node>(){

        protected Node create() throws Exception {
            return DefaultNodeStateManager.this.initializeNode();
        }
    };

    public DefaultNodeStateManager(OfBizClusterNodeStore ofBizClusterNodeStore, FailoverProperties failoverProperties, Scheduler scheduler, ComponentFactory componentFactory, TaskManager taskManager, MailQueue mailQueue, EventPublisher eventPublisher, TransactionSupport transactionSupport, JiraSystemRestarter jiraSystemRestarter, CacheManager cacheManager) {
        this.ofBizClusterNodeStore = ofBizClusterNodeStore;
        this.failoverProperties = failoverProperties;
        this.scheduler = scheduler;
        this.componentFactory = componentFactory;
        this.taskManager = taskManager;
        this.mailQueue = mailQueue;
        this.eventPublisher = eventPublisher;
        this.transactionSupport = transactionSupport;
        this.jiraSystemRestarter = jiraSystemRestarter;
        this.cacheManager = cacheManager;
    }

    @EventListener
    public void clearCache(ClearCacheEvent event) {
        this.refreshState();
    }

    @Override
    public Node getNode() {
        return (Node)this.nodeRef.get();
    }

    @Override
    public void refreshState() {
        this.nodeRef.reset();
    }

    private Node initializeNode() {
        Node node;
        String nodeId = this.failoverProperties.getNodeId();
        if (nodeId != null) {
            node = this.ofBizClusterNodeStore.getNode(nodeId);
            if (node == null) {
                Node.NodeState state = Node.NodeState.PASSIVE;
                if (this.ofBizClusterNodeStore.getAllNodes().isEmpty()) {
                    state = Node.NodeState.ACTIVE;
                }
                node = this.ofBizClusterNodeStore.createNode(nodeId, state);
            }
        } else {
            node = new Node(null, Node.NodeState.ACTIVE);
        }
        return node;
    }

    @Override
    public synchronized void activate() throws ClusterStateException {
        Node currentNode = this.getNode();
        if (!currentNode.isClustered()) {
            throw new NotClusteredException();
        }
        log.info((Object)("Activating cluster instance: '" + currentNode.getNodeId() + "'"));
        this.eventPublisher.publish((Object)NodeActivatingEvent.INSTANCE);
        this.ofBizClusterNodeStore.storeNode(currentNode.getNodeId(), Node.NodeState.ACTIVATING);
        this.nodeRef.reset();
        this.eventPublisher.publish((Object)ClearCacheEvent.INSTANCE);
        this.cacheManager.flushCaches();
        this.startServices();
        if (!this.ofBizClusterNodeStore.getNode(currentNode.getNodeId()).getState().equals((Object)Node.NodeState.ACTIVATING)) {
            this.deactivate();
            throw new ClusterStateException("Unable to activate, because another node has become the active node. Deactivating");
        }
        this.persistActiveState();
        this.eventPublisher.publish((Object)NodeActivatedEvent.INSTANCE);
        log.info((Object)("Activated cluster instance: '" + currentNode.getNodeId() + "'"));
    }

    private void startServices() {
        try {
            if (this.scheduler.isInStandbyMode()) {
                this.scheduler.start();
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
        LifecycleAwarePluginScheduler pluginScheduler = (LifecycleAwarePluginScheduler)ComponentAccessor.getOSGiComponentInstanceOfType(PluginScheduler.class);
        if (pluginScheduler != null) {
            pluginScheduler.start();
        } else {
            log.warn((Object)"Cannot start the plugin scheduler as it does not exist.");
        }
        this.taskManager.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistActiveState() {
        Node thisNode = this.getNode();
        Transaction txn = this.transactionSupport.begin();
        try {
            List<Node> nodes = this.ofBizClusterNodeStore.findNodes(null, Collections.singletonList("nodeId"));
            for (Node node : nodes) {
                if (node.getNodeId().equals(thisNode.getNodeId())) {
                    this.ofBizClusterNodeStore.storeNode(node.getNodeId(), Node.NodeState.ACTIVE);
                    continue;
                }
                this.ofBizClusterNodeStore.storeNode(node.getNodeId(), Node.NodeState.PASSIVE);
            }
            txn.commit();
            this.nodeRef.reset();
        }
        finally {
            txn.finallyRollbackIfNotCommitted();
        }
    }

    @Override
    public synchronized void quiesce() throws NotClusteredException {
        Node currentNode = this.getNode();
        if (!currentNode.isClustered()) {
            throw new NotClusteredException();
        }
        log.info((Object)("Quiescing cluster instance: '" + currentNode.getNodeId() + "'"));
        this.shutdownAndFlushAsyncServices();
    }

    @Override
    public void restart() {
        this.jiraSystemRestarter.ariseSirJIRA();
    }

    @Override
    public synchronized void deactivate() throws NotClusteredException {
        Node currentNode = this.getNode();
        if (!currentNode.isClustered()) {
            throw new NotClusteredException();
        }
        log.info((Object)("Passivating cluster instance: '" + currentNode.getNodeId() + "'"));
        this.eventPublisher.publish((Object)NodePassivatingEvent.INSTANCE);
        this.ofBizClusterNodeStore.storeNode(currentNode.getNodeId(), Node.NodeState.PASSIVATING);
        this.nodeRef.reset();
        this.shutdownAndFlushAsyncServices();
        this.ofBizClusterNodeStore.storeNode(currentNode.getNodeId(), Node.NodeState.PASSIVE);
        this.nodeRef.reset();
        this.eventPublisher.publish((Object)NodePassivatedEvent.INSTANCE);
        log.info((Object)("Passivated cluster instance: '" + currentNode.getNodeId() + "'"));
    }

    private void shutdownAndFlushAsyncServices() {
        try {
            if (!this.scheduler.isInStandbyMode()) {
                this.scheduler.standby();
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
        LifecycleAwarePluginScheduler pluginScheduler = (LifecycleAwarePluginScheduler)ComponentAccessor.getOSGiComponentInstanceOfType(PluginScheduler.class);
        if (pluginScheduler != null) {
            pluginScheduler.shutdown();
        } else {
            log.warn((Object)"Cannot shutdown the plugin scheduler as it does not exist.");
        }
        this.cleanUpTaskManager();
        this.cleanUpCrowd();
        try {
            this.mailQueue.sendBuffer();
        }
        catch (RuntimeException e) {
            log.warn((Object)("Sending buffer failed: " + e.getMessage()), (Throwable)e);
        }
    }

    private void cleanUpCrowd() {
        DirectorySynchroniserBarrier barrier = this.componentFactory.createObject(DirectorySynchroniserBarrier.class);
        if (!barrier.await(20L, TimeUnit.SECONDS)) {
            log.error((Object)"Unable to stop remote directory synchronization.");
        }
    }

    private void cleanUpTaskManager() {
        this.taskManager.shutdownAndWait(20L);
    }
}

