/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.component;

import com.atlassian.jira.bc.project.component.MutableProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentImpl;
import java.util.ArrayList;
import java.util.Collection;
import org.ofbiz.core.entity.GenericValue;

public class ComponentConverter {
    public Collection<MutableProjectComponent> convertToComponents(Collection<GenericValue> componentGVCollection) {
        ArrayList<MutableProjectComponent> components = new ArrayList<MutableProjectComponent>(componentGVCollection.size());
        for (GenericValue gv : componentGVCollection) {
            if (gv == null) continue;
            components.add(this.convertToComponent(gv));
        }
        return components;
    }

    public MutableProjectComponent convertToComponent(GenericValue componentGV) {
        Long id = componentGV.getLong("id");
        String name = componentGV.getString("name");
        String description = componentGV.getString("description");
        String lead = componentGV.getString("lead");
        Long projectId = componentGV.getLong("project");
        Long assigneeTypeLong = componentGV.getLong("assigneetype");
        long assigneeType = assigneeTypeLong != null ? assigneeTypeLong : 0L;
        MutableProjectComponent mutableProjectComponent = new MutableProjectComponent(id, name, description, lead, assigneeType, projectId);
        mutableProjectComponent.setGenericValue(componentGV);
        return mutableProjectComponent;
    }

    public ProjectComponent convertToProjectComponent(MutableProjectComponent value) {
        return new ProjectComponentImpl(value.getId(), value.getName(), value.getDescription(), value.getLead(), value.getAssigneeType(), value.getProjectId(), value.getGenericValue());
    }

    public Collection<ProjectComponent> convertToProjectComponents(Collection<MutableProjectComponent> mutables) {
        ArrayList<ProjectComponent> components = new ArrayList<ProjectComponent>(mutables.size());
        for (MutableProjectComponent mutable : mutables) {
            components.add(this.convertToProjectComponent(mutable));
        }
        return components;
    }
}

