/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.comment;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.issue.util.VisibilityValidator;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.comments.CommentPermissionManager;
import com.atlassian.jira.issue.comments.MutableComment;
import com.atlassian.jira.issue.fields.TextFieldCharacterLengthValidator;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DefaultCommentService
implements CommentService {
    private static final Logger log = Logger.getLogger(DefaultCommentService.class);
    private static final String ERROR_NO_PERMISSION = "comment.service.error.no.permission";
    private static final String ERROR_NO_PERMISSION_NO_USER = "comment.service.error.no.permission.no.user";
    private static final String ERROR_NO_EDIT_PERMISSION = "comment.service.error.no.edit.permission";
    private static final String ERROR_NO_EDIT_PERMISSION_NO_USER = "comment.service.error.no.edit.permission.no.user";
    private static final String ERROR_NO_COMMENT_VISIBILITY = "comment.service.error.no.comment.visibility";
    private static final String ERROR_NO_COMMENT_VISIBILITY_NO_USER = "comment.service.error.no.comment.visibility.no.user";
    private static final String ERROR_NULL_ISSUE = "comment.service.error.issue.null";
    private static final String ERROR_NULL_BODY = "comment.service.error.body.null";
    private static final String ERROR_USER_NOT_IN_ROLE = "comment.service.error.usernotinrole";
    private static final String ERROR_ROLE_DOES_NOT_EXIST = "comment.service.error.roledoesnotexist";
    private static final String ERROR_ROLE_ID_NOT_NUMBER = "comment.service.error.roleidnotnumber";
    private static final String ERROR_NO_COMMENT_FOR_ID = "comment.service.error.no.comment.for.id";
    private static final String ERROR_NO_ID_SPECIFIED = "comment.service.error.no.id.specified";
    public static final String ERROR_NULL_COMMENT_ID = "comment.service.error.update.null.comment.id";
    public static final String ERROR_NULL_COMMENT = "comment.service.error.update.null.comment";
    public static final String ERROR_NULL_COMMENT_DELETE = "comment.service.error.delete.null.comment";
    public static final String ERROR_NULL_COMMENT_ID_DELETE = "comment.service.error.delete.null.comment.id";
    public static final String ERROR_COMMENT_DELETE_ISSUE_UPDATE_FAILED = "comment.service.error.delete.issue.update.failed";
    public static final String ERROR_COMMENT_EDIT_NON_EDITABLE_ISSUE = "comment.service.error.edit.issue.non.editable";
    public static final String ERROR_COMMENT_DELETE_NON_EDITABLE_ISSUE = "comment.service.error.delete.issue.non.editable";
    public static final String ERROR_COMMENT_DELETE_NO_PERMISSION = "comment.service.error.delete.no.permission";
    private static final String COMMENT_I18N_PREFIX = "comment";
    public static final String ERROR_BODY_TOOLONG = "field.error.text.toolong";
    private CommentManager commentManager;
    private PermissionManager permissionManager;
    private JiraAuthenticationContext jiraAuthenticationContext;
    private ProjectRoleManager projectRoleManager;
    private CommentPermissionManager commentPermissionManager;
    private final IssueUpdater issueUpdater;
    private final IssueManager issueManager;
    private final VisibilityValidator visibilityValidator;
    private final TextFieldCharacterLengthValidator textFieldCharacterLengthValidator;

    public DefaultCommentService(CommentManager commentManager, PermissionManager permissionManager, JiraAuthenticationContext jiraAuthenticationContext, ProjectRoleManager projectRoleManager, CommentPermissionManager commentPermissionManager, IssueUpdater issueUpdater, IssueManager issueManager, VisibilityValidator visibilityValidator, TextFieldCharacterLengthValidator textFieldCharacterLengthValidator) {
        this.commentManager = commentManager;
        this.permissionManager = permissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.projectRoleManager = projectRoleManager;
        this.commentPermissionManager = commentPermissionManager;
        this.issueUpdater = issueUpdater;
        this.issueManager = issueManager;
        this.visibilityValidator = visibilityValidator;
        this.textFieldCharacterLengthValidator = textFieldCharacterLengthValidator;
    }

    public Comment create(User user, Issue issue, String body, boolean dispatchEvent, ErrorCollection errorCollection) {
        return this.create(ApplicationUsers.from((User)user), issue, body, dispatchEvent, errorCollection);
    }

    public Comment create(ApplicationUser user, Issue issue, String body, boolean dispatchEvent, ErrorCollection errorCollection) {
        return this.create(user, issue, body, null, null, null, dispatchEvent, errorCollection);
    }

    public void validateCommentUpdate(ApplicationUser user, Long commentId, String body, String groupLevel, Long roleLevelId, ErrorCollection errorCollection) {
        if (commentId == null) {
            errorCollection.addErrorMessage(this.getText(ERROR_NULL_COMMENT_ID));
            return;
        }
        MutableComment mutableComment = this.getMutableComment(user, commentId, errorCollection);
        if (mutableComment == null) {
            return;
        }
        this.hasPermissionToEdit(user, (Comment)mutableComment, errorCollection);
        if (errorCollection.hasAnyErrors()) {
            return;
        }
        this.isValidAllCommentData(user, mutableComment.getIssue(), body, groupLevel, roleLevelId == null ? null : roleLevelId.toString(), errorCollection);
    }

    public void validateCommentUpdate(User user, Long commentId, String body, String groupLevel, Long roleLevelId, ErrorCollection errorCollection) {
        this.validateCommentUpdate(ApplicationUsers.from((User)user), commentId, body, groupLevel, roleLevelId, errorCollection);
    }

    public void update(ApplicationUser user, MutableComment comment, boolean dispatchEvent, ErrorCollection errorCollection) {
        if (comment == null) {
            errorCollection.addErrorMessage(this.getText(ERROR_NULL_COMMENT));
            return;
        }
        if (comment.getId() == null) {
            errorCollection.addErrorMessage(this.getText(ERROR_NULL_COMMENT_ID));
            return;
        }
        this.hasPermissionToEdit(user, (Comment)comment, errorCollection);
        if (!errorCollection.hasAnyErrors()) {
            comment.setUpdateAuthor(user);
            comment.setUpdated(new Date(System.currentTimeMillis()));
            this.commentManager.update((Comment)comment, dispatchEvent);
        }
    }

    public void update(User user, MutableComment comment, boolean dispatchEvent, ErrorCollection errorCollection) {
        this.update(ApplicationUsers.from((User)user), comment, dispatchEvent, errorCollection);
    }

    public Comment create(ApplicationUser user, Issue issue, String body, String groupLevel, Long roleLevelId, boolean dispatchEvent, ErrorCollection errorCollection) {
        return this.create(user, issue, body, groupLevel, roleLevelId, null, dispatchEvent, errorCollection);
    }

    public Comment create(User user, Issue issue, String body, String groupLevel, Long roleLevelId, boolean dispatchEvent, ErrorCollection errorCollection) {
        return this.create(ApplicationUsers.from((User)user), issue, body, groupLevel, roleLevelId, dispatchEvent, errorCollection);
    }

    public Comment create(ApplicationUser user, Issue issue, String body, String groupLevel, Long roleLevelId, Date created, boolean dispatchEvent, ErrorCollection errorCollection) {
        Comment comment = null;
        if (this.hasPermissionToCreate(user, issue, errorCollection)) {
            String roleLevelIdString;
            String string = roleLevelIdString = roleLevelId == null ? null : roleLevelId.toString();
            if (this.isValidAllCommentData(user, issue, body, groupLevel, roleLevelIdString, errorCollection)) {
                comment = this.commentManager.create(issue, user, body, groupLevel, roleLevelId, created, dispatchEvent);
            }
        }
        return comment;
    }

    public Comment create(User user, Issue issue, String body, String groupLevel, Long roleLevelId, Date created, boolean dispatchEvent, ErrorCollection errorCollection) {
        return this.create(ApplicationUsers.from((User)user), issue, body, groupLevel, roleLevelId, created, dispatchEvent, errorCollection);
    }

    public List<Comment> getCommentsForUser(ApplicationUser currentUser, Issue issue, ErrorCollection errorCollection) {
        boolean internalError = false;
        List<Object> comments = new ArrayList<Comment>();
        if (issue == null) {
            errorCollection.addErrorMessage(this.getText(ERROR_NULL_ISSUE));
            internalError = true;
        }
        if (!internalError) {
            comments = this.commentManager.getCommentsForUser(issue, currentUser);
        }
        return comments;
    }

    public List<Comment> getCommentsForUser(User currentUser, Issue issue, ErrorCollection errorCollection) {
        return this.getCommentsForUser(ApplicationUsers.from((User)currentUser), issue, errorCollection);
    }

    public boolean isValidCommentData(ApplicationUser currentUser, Issue issue, String groupLevel, String roleLevelId, ErrorCollection errorCollection) {
        return this.visibilityValidator.isValidVisibilityData((JiraServiceContext)new JiraServiceContextImpl(currentUser, errorCollection), COMMENT_I18N_PREFIX, issue, groupLevel, roleLevelId);
    }

    public boolean isValidCommentData(User user, Issue issue, String groupLevel, String roleLevelId, ErrorCollection errorCollection) {
        return this.isValidCommentData(ApplicationUsers.from((User)user), issue, groupLevel, roleLevelId, errorCollection);
    }

    public boolean isValidCommentBody(String body, ErrorCollection errorCollection) {
        return this.isValidCommentBody(body, errorCollection, false);
    }

    public boolean isValidCommentBody(String body, ErrorCollection errorCollection, boolean allowEmpty) {
        boolean valid = true;
        if (!allowEmpty && StringUtils.isBlank((String)body)) {
            valid = false;
            errorCollection.addError(COMMENT_I18N_PREFIX, this.getText(ERROR_NULL_BODY), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (this.textFieldCharacterLengthValidator.isTextTooLong(body)) {
            valid = false;
            long maximumNumberOfCharacters = this.textFieldCharacterLengthValidator.getMaximumNumberOfCharacters();
            errorCollection.addError(COMMENT_I18N_PREFIX, this.getText(ERROR_BODY_TOOLONG, String.valueOf(maximumNumberOfCharacters)));
        }
        return valid;
    }

    public boolean isValidAllCommentData(ApplicationUser currentUser, Issue issue, String body, String groupLevel, String roleLevelId, ErrorCollection errorCollection) {
        boolean validCommentBody = this.isValidCommentBody(body, errorCollection);
        boolean validCommentData = this.isValidCommentData(currentUser, issue, groupLevel, roleLevelId, errorCollection);
        return validCommentBody && validCommentData;
    }

    public boolean isValidAllCommentData(User user, Issue issue, String body, String groupLevel, String roleLevelId, ErrorCollection errorCollection) {
        return this.isValidAllCommentData(ApplicationUsers.from((User)user), issue, body, groupLevel, roleLevelId, errorCollection);
    }

    public boolean isGroupVisiblityEnabled() {
        return this.visibilityValidator.isGroupVisiblityEnabled();
    }

    public boolean isProjectRoleVisiblityEnabled() {
        return this.visibilityValidator.isProjectRoleVisiblityEnabled();
    }

    public Comment getCommentById(ApplicationUser user, Long commentId, ErrorCollection errorCollection) {
        return this.getMutableComment(user, commentId, errorCollection);
    }

    public Comment getCommentById(User user, Long commentId, ErrorCollection errorCollection) {
        return this.getCommentById(ApplicationUsers.from((User)user), commentId, errorCollection);
    }

    public MutableComment getMutableComment(ApplicationUser user, Long commentId, ErrorCollection errorCollection) {
        if (commentId == null) {
            errorCollection.addErrorMessage(this.getText(ERROR_NO_ID_SPECIFIED));
            return null;
        }
        MutableComment comment = this.commentManager.getMutableComment(commentId);
        if (comment == null) {
            errorCollection.addErrorMessage(this.getText(ERROR_NO_COMMENT_FOR_ID, commentId.toString()));
            return null;
        }
        if (this.commentPermissionManager.hasBrowsePermission(user, (Comment)comment)) {
            return comment;
        }
        if (user == null) {
            errorCollection.addErrorMessage(this.getText(ERROR_NO_PERMISSION_NO_USER));
        } else {
            errorCollection.addErrorMessage(this.getText(ERROR_NO_PERMISSION, user.getDisplayName()));
        }
        return null;
    }

    public MutableComment getMutableComment(User user, Long commentId, ErrorCollection errorCollection) {
        return this.getMutableComment(ApplicationUsers.from((User)user), commentId, errorCollection);
    }

    public boolean hasPermissionToDelete(JiraServiceContext jiraServiceContext, Long commentId) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ApplicationUser user = jiraServiceContext.getLoggedInApplicationUser();
        Comment comment = this.getCommentById(user, commentId, (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        if (!this.hasVisibility(jiraServiceContext, comment)) {
            return false;
        }
        Issue issue = comment.getIssue();
        if (!this.isIssueInEditableWorkflowState(issue)) {
            errorCollection.addErrorMessage(this.getText(ERROR_COMMENT_DELETE_NON_EDITABLE_ISSUE));
            jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        if (this.userHasCommentDeleteAllPermission(issue, user) || this.userHasCommentDeleteOwnPermission(issue, user) && this.commentManager.isUserCommentAuthor(user, comment)) {
            return true;
        }
        errorCollection.addErrorMessage(this.getText(ERROR_COMMENT_DELETE_NO_PERMISSION, String.valueOf(comment.getId())));
        jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
        return false;
    }

    protected boolean hasVisibility(JiraServiceContext jiraServiceContext, Comment comment) {
        Issue issue;
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        ApplicationUser user = jiraServiceContext.getLoggedInApplicationUser();
        boolean visible = this.visibilityValidator.isValidVisibilityData((JiraServiceContext)new JiraServiceContextImpl(user, errorCollection), COMMENT_I18N_PREFIX, issue = comment.getIssue(), comment.getGroupLevel(), comment.getRoleLevelId() == null ? null : comment.getRoleLevelId().toString());
        if (!visible) {
            if (user != null) {
                errorCollection.addErrorMessage(this.getText(ERROR_NO_COMMENT_VISIBILITY, user.getDisplayName()));
            } else {
                errorCollection.addErrorMessage(this.getText(ERROR_NO_COMMENT_VISIBILITY_NO_USER));
            }
        }
        return visible;
    }

    public void delete(JiraServiceContext jiraServiceContext, Comment comment, boolean dispatchEvent) {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        if (comment == null) {
            errorCollection.addErrorMessage(this.getText(ERROR_NULL_COMMENT_DELETE, null));
            return;
        }
        if (comment.getId() == null) {
            errorCollection.addErrorMessage(this.getText(ERROR_NULL_COMMENT_ID_DELETE));
            return;
        }
        if (this.hasPermissionToDelete(jiraServiceContext, comment.getId())) {
            ChangeItemBean changeItem = this.commentManager.delete(comment);
            this.doUpdateWithChangelog(EventType.ISSUE_COMMENT_DELETED_ID, EasyList.build((Object)changeItem), comment.getIssue(), jiraServiceContext.getLoggedInApplicationUser(), dispatchEvent);
        }
    }

    public boolean hasPermissionToCreate(ApplicationUser user, Issue issue, ErrorCollection errorCollection) {
        boolean hasPerm;
        boolean bl = hasPerm = issue.getProjectObject() == null ? this.permissionManager.hasPermission(15, issue, user) : this.permissionManager.hasPermission(15, issue.getProjectObject(), user);
        if (!hasPerm) {
            if (user != null) {
                errorCollection.addErrorMessage(this.getText(ERROR_NO_PERMISSION, user.getDisplayName()), ErrorCollection.Reason.FORBIDDEN);
            } else {
                errorCollection.addErrorMessage(this.getText(ERROR_NO_PERMISSION_NO_USER), ErrorCollection.Reason.FORBIDDEN);
            }
        }
        return hasPerm;
    }

    public boolean hasPermissionToCreate(User user, Issue issue, ErrorCollection errorCollection) {
        return this.hasPermissionToCreate(ApplicationUsers.from((User)user), issue, errorCollection);
    }

    public boolean hasPermissionToEdit(JiraServiceContext jiraServiceContext, Long commentId) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ApplicationUser user = jiraServiceContext.getLoggedInApplicationUser();
        Comment comment = this.getCommentById(user, commentId, (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        return this.hasPermissionToEdit(user, comment, jiraServiceContext.getErrorCollection());
    }

    public boolean hasPermissionToEdit(ApplicationUser user, Comment comment, ErrorCollection errorCollection) {
        if (comment == null) {
            errorCollection.addErrorMessage(this.getText(ERROR_NULL_COMMENT));
            return false;
        }
        if (comment.getId() == null) {
            errorCollection.addErrorMessage(this.getText(ERROR_NULL_COMMENT_ID));
            return false;
        }
        if (!this.isIssueInEditableWorkflowState(comment.getIssue())) {
            errorCollection.addErrorMessage(this.getText(ERROR_COMMENT_EDIT_NON_EDITABLE_ISSUE));
            return false;
        }
        if (!this.hasVisibility((JiraServiceContext)new JiraServiceContextImpl(user, errorCollection), comment)) {
            return false;
        }
        boolean hasPerm = this.commentPermissionManager.hasEditPermission(user, comment);
        if (!hasPerm) {
            if (user != null) {
                errorCollection.addErrorMessage(this.getText(ERROR_NO_EDIT_PERMISSION, user.getDisplayName()));
            } else {
                errorCollection.addErrorMessage(this.getText(ERROR_NO_EDIT_PERMISSION_NO_USER));
            }
        }
        return hasPerm;
    }

    public boolean hasPermissionToEdit(User user, Comment comment, ErrorCollection errorCollection) {
        return this.hasPermissionToEdit(ApplicationUsers.from((User)user), comment, errorCollection);
    }

    protected void doUpdateWithChangelog(Long eventTypeId, List<ChangeItemBean> changeItems, Issue issue, ApplicationUser user, boolean dispatchEvent) {
        IssueUpdateBean issueUpdateBean = new IssueUpdateBean(issue.getGenericValue(), issue.getGenericValue(), eventTypeId, user == null ? null : user.getDirectoryUser());
        issueUpdateBean.setChangeItems(changeItems);
        if (dispatchEvent) {
            issueUpdateBean.setDispatchEvent(true);
        }
        this.issueUpdater.doUpdate(issueUpdateBean, false);
    }

    boolean isIssueInEditableWorkflowState(Issue issue) {
        return this.issueManager.isEditable(issue);
    }

    boolean userHasCommentDeleteAllPermission(Issue issue, ApplicationUser user) {
        return this.permissionManager.hasPermission(36, issue, user);
    }

    boolean userHasCommentDeleteOwnPermission(Issue issue, ApplicationUser user) {
        return this.permissionManager.hasPermission(37, issue, user);
    }

    private String getText(String key) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key);
    }

    private String getText(String key, String param) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key, param);
    }
}

