/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.integrity.check;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.appconsistency.integrity.check.CheckAmendment;
import com.atlassian.jira.appconsistency.integrity.check.CheckImpl;
import com.atlassian.jira.appconsistency.integrity.exception.IntegrityException;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;

public class WorkflowIssueStatusNull
extends CheckImpl {
    private WorkflowManager workflowManager = ComponentAccessor.getWorkflowManager();

    public WorkflowIssueStatusNull(OfBizDelegator ofBizDelegator, int id) {
        super(ofBizDelegator, id);
    }

    @Override
    public String getDescription() {
        return this.getI18NBean().getText("admin.integrity.check.workflow.issue.status.desc");
    }

    @Override
    public List preview() throws IntegrityException {
        return this.doCheck(false);
    }

    @Override
    public List correct() throws IntegrityException {
        return this.doCheck(true);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public String getUnavailableMessage() {
        return "";
    }

    private List doCheck(boolean correct) throws IntegrityException {
        ArrayList<CheckAmendment> results = new ArrayList<CheckAmendment>();
        HashMap<String, ArrayList<Long>> statusKeysMap = new HashMap<String, ArrayList<Long>>();
        HashMap statusCache = new HashMap();
        try {
            List issueSteps = this.ofBizDelegator.findByAnd("IssueWorkflowStepView", EasyMap.build((Object)"status", null));
            for (GenericValue genericValue : issueSteps) {
                String issueKey = genericValue.getString("issueKey");
                try {
                    GenericValue status = this.getStatusFromWorkflow(genericValue, statusCache);
                    String statusFromWorkflow = status.getString("id");
                    Long issueId = genericValue.getLong("issueid");
                    ArrayList<Long> issueIds = (ArrayList<Long>)statusKeysMap.get(statusFromWorkflow);
                    if (issueIds == null) {
                        issueIds = new ArrayList<Long>();
                        statusKeysMap.put(statusFromWorkflow, issueIds);
                    }
                    issueIds.add(issueId);
                    if (correct) {
                        results.add(new CheckAmendment(2, this.getI18NBean().getText("admin.integrity.check.workflow.issue.status.message", issueKey, status.getString("name")), "JRA-7428"));
                        continue;
                    }
                    results.add(new CheckAmendment(2, this.getI18NBean().getText("admin.integrity.check.workflow.issue.status.preview", issueKey, status.getString("name")), "JRA-7428"));
                }
                catch (IllegalStateException ise) {
                    results.add(new CheckAmendment(1, this.getI18NBean().getText("admin.integrity.check.workflow.issue.status.unfixable", issueKey, ise.getMessage()), "JRA-7428"));
                }
            }
            if (correct) {
                for (Object o : statusKeysMap.keySet()) {
                    String statusId = (String)o;
                    List issueIds = (List)statusKeysMap.get(statusId);
                    this.ofBizDelegator.bulkUpdateByPrimaryKey("Issue", EasyMap.build((Object)"status", (Object)statusId), issueIds);
                }
            }
        }
        catch (Exception e) {
            throw new IntegrityException("Error occurred while performing check.", e);
        }
        return results;
    }

    private GenericValue getStatusFromWorkflow(GenericValue genericValue, HashMap statusCache) throws WorkflowException, IllegalStateException {
        String cacheKey = genericValue.getLong("project") + ":" + genericValue.getString("type") + ":" + genericValue.getInteger("stepId");
        GenericValue status = (GenericValue)statusCache.get(cacheKey);
        if (status == null) {
            JiraWorkflow workflow = this.workflowManager.getWorkflow(genericValue);
            if (workflow == null) {
                throw new IllegalStateException("Workflow for project id " + genericValue.getLong("project") + " and issue type id " + genericValue.getString("type") + " is not defined");
            }
            Integer stepId = genericValue.getInteger("stepId");
            if (stepId == null) {
                throw new IllegalStateException("Issue has no status, and status cannot be derived as the workflow step for this issue is missing.");
            }
            StepDescriptor step = workflow.getDescriptor().getStep(stepId.intValue());
            if (step == null) {
                throw new IllegalStateException("Can not resolve a step with id: " + stepId + " from workflow " + workflow.getName());
            }
            status = workflow.getLinkedStatus(step);
            if (status == null) {
                throw new IllegalStateException("Can not resolve a linked status for workflow step " + step.getName());
            }
            statusCache.put(cacheKey, status);
        }
        return status;
    }

    public void setWorkflowManager(WorkflowManager workflowManager) {
        this.workflowManager = workflowManager;
    }
}

