/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.integrity;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.appconsistency.integrity.IntegrityCheckManager;
import com.atlassian.jira.appconsistency.integrity.check.Check;
import com.atlassian.jira.appconsistency.integrity.check.CheckImpl;
import com.atlassian.jira.appconsistency.integrity.check.EntityCheck;
import com.atlassian.jira.appconsistency.integrity.check.EntityCheckImpl;
import com.atlassian.jira.appconsistency.integrity.check.FieldLayoutCheck;
import com.atlassian.jira.appconsistency.integrity.check.FilterSubscriptionsSavedFilterCheck;
import com.atlassian.jira.appconsistency.integrity.check.FilterSubscriptionsTriggerCheck;
import com.atlassian.jira.appconsistency.integrity.check.IssueLinkCheck;
import com.atlassian.jira.appconsistency.integrity.check.PrimaryEntityRelationCreate;
import com.atlassian.jira.appconsistency.integrity.check.PrimaryEntityRelationDelete;
import com.atlassian.jira.appconsistency.integrity.check.SchemePermissionCheck;
import com.atlassian.jira.appconsistency.integrity.check.SearchRequestRelationCheck;
import com.atlassian.jira.appconsistency.integrity.check.SimpleTriggerCheck;
import com.atlassian.jira.appconsistency.integrity.check.WorkflowCurrentStepCheck;
import com.atlassian.jira.appconsistency.integrity.check.WorkflowIssueStatusNull;
import com.atlassian.jira.appconsistency.integrity.check.WorkflowStateCheck;
import com.atlassian.jira.appconsistency.integrity.integritycheck.EntityIntegrityCheckImpl;
import com.atlassian.jira.appconsistency.integrity.integritycheck.FieldLayoutIntegrityCheck;
import com.atlassian.jira.appconsistency.integrity.integritycheck.FilterSubscriptionIntegrityCheck;
import com.atlassian.jira.appconsistency.integrity.integritycheck.IntegrityCheck;
import com.atlassian.jira.appconsistency.integrity.integritycheck.SchemePermissionIntegrityCheck;
import com.atlassian.jira.appconsistency.integrity.integritycheck.SearchRequestRelationIntegrityCheck;
import com.atlassian.jira.appconsistency.integrity.integritycheck.WorkflowStateIntegrityCheck;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.I18nHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IntegrityCheckManagerImpl
implements IntegrityCheckManager {
    private final Map<Long, IntegrityCheck> integrityChecks = new HashMap<Long, IntegrityCheck>();
    private final Map<Long, Check> checks = new HashMap<Long, Check>();
    private final ApplicationProperties applicationProperties;
    private final I18nHelper.BeanFactory i18nFactory;
    private int checkId = 1;
    private int integrityCheckId = 1;

    public IntegrityCheckManagerImpl(OfBizDelegator ofbizDelegator, I18nHelper.BeanFactory i18nFactory, ApplicationProperties applicationProperties) {
        this.i18nFactory = i18nFactory;
        this.applicationProperties = applicationProperties;
        IntegrityCheck issueRelationsCheck = this.getIssueRelationsCheck(ofbizDelegator);
        IntegrityCheck searchRequestRelationsCheck = this.getSearchRequestRelationsCheck(ofbizDelegator);
        IntegrityCheck schemePermissionCheck = this.getSchemePermissionCheck(ofbizDelegator);
        IntegrityCheck workflowStateCheck = this.getWorkflowIntegrityCheck(ofbizDelegator);
        IntegrityCheck fieldLayoutCheck = this.getFieldLayoutIntegrityCheck(ofbizDelegator);
        IntegrityCheck filterSubscriptionCheck = this.getFilterSubscriptionIntegrityCheck(ofbizDelegator);
        this.integrityChecks.put(issueRelationsCheck.getId(), issueRelationsCheck);
        this.integrityChecks.put(searchRequestRelationsCheck.getId(), searchRequestRelationsCheck);
        this.integrityChecks.put(schemePermissionCheck.getId(), schemePermissionCheck);
        this.integrityChecks.put(workflowStateCheck.getId(), workflowStateCheck);
        this.integrityChecks.put(fieldLayoutCheck.getId(), fieldLayoutCheck);
        this.integrityChecks.put(filterSubscriptionCheck.getId(), filterSubscriptionCheck);
    }

    @Override
    public List<IntegrityCheck> getIntegrityChecks() {
        ArrayList<IntegrityCheck> result = new ArrayList<IntegrityCheck>(this.integrityChecks.values());
        Collections.sort(result);
        return result;
    }

    @Override
    public Check getCheck(Long checkId) {
        return this.checks.get(checkId);
    }

    @Override
    public IntegrityCheck getIntegrityCheck(Long id) {
        return this.integrityChecks.get(id);
    }

    private IntegrityCheck getIssueRelationsCheck(OfBizDelegator ofBizDelegator) {
        ArrayList<EntityCheck> issueChecks = new ArrayList<EntityCheck>();
        EntityCheckImpl check = new PrimaryEntityRelationDelete(ofBizDelegator, this.checkId++, "Parent", "Project");
        issueChecks.add(check);
        this.checks.put(check.getId(), check);
        check = new PrimaryEntityRelationCreate(ofBizDelegator, this.checkId++, "Related", "OSWorkflowEntry", "workflowId", EasyMap.build((Object)"name", (Object)"jira", (Object)"state", (Object)new Integer(0)));
        issueChecks.add(check);
        this.checks.put(check.getId(), check);
        check = new IssueLinkCheck(ofBizDelegator, this.checkId++);
        issueChecks.add(check);
        this.checks.put(check.getId(), check);
        return new EntityIntegrityCheckImpl(this.integrityCheckId++, this.getI18nHelper().getText("admin.integrity.check.entity.relation.desc"), "Issue", issueChecks);
    }

    private IntegrityCheck getFilterSubscriptionIntegrityCheck(OfBizDelegator ofBizDelegator) {
        ArrayList<Check> issueChecks = new ArrayList<Check>();
        CheckImpl check = new FilterSubscriptionsTriggerCheck(ofBizDelegator, this.checkId++);
        issueChecks.add(check);
        this.checks.put(check.getId(), check);
        check = new FilterSubscriptionsSavedFilterCheck(ofBizDelegator, this.checkId++);
        issueChecks.add(check);
        this.checks.put(check.getId(), check);
        check = new SimpleTriggerCheck(ofBizDelegator, this.checkId++);
        issueChecks.add(check);
        this.checks.put(check.getId(), check);
        return new FilterSubscriptionIntegrityCheck(this.integrityCheckId++, this.getI18nHelper().getText("admin.integrity.check.filter.subscriptions.desc"), issueChecks);
    }

    private IntegrityCheck getWorkflowIntegrityCheck(OfBizDelegator ofBizDelegator) {
        WorkflowStateCheck check = new WorkflowStateCheck(ofBizDelegator, this.checkId++);
        this.checks.put(check.getId(), check);
        WorkflowCurrentStepCheck check2 = new WorkflowCurrentStepCheck(ofBizDelegator, this.checkId++);
        this.checks.put(check2.getId(), check2);
        WorkflowIssueStatusNull check3 = new WorkflowIssueStatusNull(ofBizDelegator, this.checkId++);
        this.checks.put(check3.getId(), check3);
        return new WorkflowStateIntegrityCheck(this.integrityCheckId++, this.getI18nHelper().getText("admin.integrity.check.workflow.state.desc"), check, check2, check3);
    }

    private IntegrityCheck getFieldLayoutIntegrityCheck(OfBizDelegator ofBizDelegator) {
        FieldLayoutCheck check = new FieldLayoutCheck(ofBizDelegator, this.checkId++);
        this.checks.put(check.getId(), check);
        return new FieldLayoutIntegrityCheck(this.integrityCheckId++, this.getI18nHelper().getText("admin.integrity.check.field.layout.desc"), check);
    }

    private IntegrityCheck getSearchRequestRelationsCheck(OfBizDelegator ofBizDelegator) {
        SearchRequestRelationCheck check = new SearchRequestRelationCheck(ofBizDelegator, this.checkId++);
        this.checks.put(check.getId(), check);
        return new SearchRequestRelationIntegrityCheck(this.integrityCheckId++, this.getI18nHelper().getText("admin.integrity.check.search.request.relation.desc"), check);
    }

    private IntegrityCheck getSchemePermissionCheck(OfBizDelegator ofBizDelegator) {
        SchemePermissionCheck check = new SchemePermissionCheck(ofBizDelegator, this.checkId++);
        this.checks.put(check.getId(), check);
        return new SchemePermissionIntegrityCheck(this.integrityCheckId++, this.getI18nHelper().getText("admin.integrity.check.scheme.permission.desc"), check);
    }

    private I18nHelper getI18nHelper() {
        return this.i18nFactory.getInstance(this.applicationProperties.getDefaultLocale());
    }
}

