/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.clustering;

import com.atlassian.jira.cluster.FailoverProperties;
import com.atlassian.jira.startup.StartupCheck;
import org.apache.log4j.Logger;

public class NodeIdCheck
implements StartupCheck {
    private static final Logger log = Logger.getLogger(NodeIdCheck.class);
    private static final String NAME = "JIRA HA Node ID Check";
    private static final String FAULT_DESC = "JIRA is running in HA mode but no node id is set in jira-ha.properties.";
    private final FailoverProperties failoverProperties;

    public NodeIdCheck(FailoverProperties failoverProperties) {
        this.failoverProperties = failoverProperties;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isOk() {
        log.debug((Object)"Performing JIRA HA Node ID Check");
        return this.failoverProperties.getNodeId() != null;
    }

    @Override
    public String getFaultDescription() {
        return FAULT_DESC;
    }

    @Override
    public String getHTMLFaultDescription() {
        return this.getFaultDescription();
    }

    @Override
    public void stop() {
    }
}

