/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.action.admin;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class OfBizDowngradeHandler {
    private static final String EXTERNAL_ENTITY = "ExternalEntity";
    private static final String OFBIZ_EXTERNAL_ENTITY_STORE = "com.atlassian.jira.user.OfbizExternalEntityStore";
    private static final String OS_PROPERTY_ENTRY = "OSPropertyEntry";
    private static final String APPLICATION_USER = "ApplicationUser";
    private static final String ENTITY_ID = "entityId";
    private static final String ENTITY_NAME = "entityName";
    private static final String META_UPDATE_AUTHOR_NAME = "jira.update.author.name";
    private static final String META_UPDATE_AUTHOR_KEY = "jira.update.author.key";
    private static final String DESCRIPTOR_ENTITY_FIELD = "descriptor";
    private static final String DRAFT_WORKFLOW_ENTITY_NAME = "DraftWorkflow";
    private static final String WORKFLOW_ENTITY_NAME = "Workflow";
    private static final String USER_ENTITY_NAME = "User";
    private final OfBizDelegator ofBizDelegator;

    public OfBizDowngradeHandler(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    public void downgradeAppUsersToExternalEntities() throws GenericEntityException {
        this.downgradeNewAppUsers();
        List entities = this.ofBizDelegator.findByAnd(EXTERNAL_ENTITY, (Map)ImmutableMap.of((Object)"type", (Object)OFBIZ_EXTERNAL_ENTITY_STORE));
        for (GenericValue externalEntityUser : entities) {
            Long entityId = externalEntityUser.getLong("id");
            String username = externalEntityUser.getString("name");
            List users = this.ofBizDelegator.findByAnd(APPLICATION_USER, (Map)ImmutableMap.of((Object)"lowerUserName", (Object)(username = IdentifierUtils.toLowerCase((String)username))));
            if (users == null || users.size() <= 0) continue;
            Long userId = ((GenericValue)users.get(0)).getLong("id");
            List osPropertyEntries = this.ofBizDelegator.findByAnd(OS_PROPERTY_ENTRY, (Map)ImmutableMap.of((Object)ENTITY_ID, (Object)userId, (Object)ENTITY_NAME, (Object)APPLICATION_USER));
            for (GenericValue osPropertyEntry : osPropertyEntries) {
                osPropertyEntry.set(ENTITY_NAME, (Object)EXTERNAL_ENTITY);
                osPropertyEntry.set(ENTITY_ID, (Object)entityId);
                osPropertyEntry.store();
            }
        }
    }

    private void downgradeNewAppUsers() {
        List applicationUsers = this.ofBizDelegator.findAll(APPLICATION_USER);
        for (GenericValue appUser : applicationUsers) {
            String username = appUser.getString("lowerUserName");
            List externalEntities = this.ofBizDelegator.findByAnd(EXTERNAL_ENTITY, (Map)ImmutableMap.of((Object)"name", (Object)username));
            if (!externalEntities.isEmpty()) continue;
            this.ofBizDelegator.createValue(EXTERNAL_ENTITY, (Map)ImmutableMap.of((Object)"name", (Object)username, (Object)"type", (Object)OFBIZ_EXTERNAL_ENTITY_STORE));
        }
    }

    public void convertUserKeysStoredInWorkflowsIntoUserNames() throws GenericEntityException {
        List workflows = this.ofBizDelegator.findAll(WORKFLOW_ENTITY_NAME);
        for (GenericValue workflow : workflows) {
            this.updateWorkflow(workflow);
        }
        List draftWorkflows = this.ofBizDelegator.findAll(DRAFT_WORKFLOW_ENTITY_NAME);
        for (GenericValue draftWorkflow : draftWorkflows) {
            this.updateWorkflow(draftWorkflow);
        }
    }

    private void updateWorkflow(GenericValue workflow) throws GenericEntityException {
        try {
            WorkflowDescriptor descriptor = WorkflowUtil.convertXMLtoWorkflowDescriptor((String)workflow.getString(DESCRIPTOR_ENTITY_FIELD));
            this.convertUserKeyToUsername(descriptor);
            String postConversionDescriptor = WorkflowUtil.convertDescriptorToXML((WorkflowDescriptor)descriptor);
            workflow.set(DESCRIPTOR_ENTITY_FIELD, (Object)postConversionDescriptor);
            workflow.store();
        }
        catch (FactoryException e) {
            throw new GenericEntityException("Cannot convert entity into workflow descriptor", (Throwable)e);
        }
    }

    private void convertUserKeyToUsername(WorkflowDescriptor descriptor) {
        List userEntities;
        Map meta = descriptor.getMetaAttributes();
        String lowecasedUsername = (String)meta.remove(META_UPDATE_AUTHOR_KEY);
        if (lowecasedUsername != null && (userEntities = this.ofBizDelegator.findByField(USER_ENTITY_NAME, "lowerUserName", (Object)lowecasedUsername)) != null && userEntities.size() == 1) {
            String username = ((GenericValue)userEntities.get(0)).getString("userName");
            meta.put(META_UPDATE_AUTHOR_NAME, username);
        }
    }
}

