/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.validation;

import com.atlassian.util.concurrent.LazyReference;
import com.atlassian.validation.Validator;
import com.google.common.base.Supplier;
import org.apache.log4j.Logger;

public final class ValidatorFactory {
    private static final Logger log = Logger.getLogger(ValidatorFactory.class);

    public Validator getInstance(String validator) {
        log.debug((Object)("Instantiating validator of type " + validator));
        try {
            return (Validator)Class.forName(validator).newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Supplier<Validator> getInstanceLazyReference(final String validator) {
        return new LazyReference<Validator>(){

            protected Validator create() throws Exception {
                return ValidatorFactory.this.getInstance(validator);
            }
        };
    }
}

