/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.migration;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.admin.workflow.scheme.SelectProjectWorkflowScheme;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class EnterpriseWorkflowTaskContext
implements TaskContext {
    private final Project triggerProject;
    private final Long schemeId;
    private final boolean draftMigration;
    private final List<Project> projects;

    public EnterpriseWorkflowTaskContext(Project triggerProject) {
        this(triggerProject, null, true);
    }

    public EnterpriseWorkflowTaskContext(Project triggerProject, Long schemeId, boolean draftMigration) {
        this(triggerProject, Arrays.asList(triggerProject), schemeId, draftMigration);
        Assertions.notNull((String)"triggerProject", (Object)triggerProject);
    }

    public EnterpriseWorkflowTaskContext(Project triggerProject, List<Project> projects, Long schemeId, boolean draftMigration) {
        Assertions.notEmpty((String)"projects", projects);
        this.schemeId = schemeId;
        this.triggerProject = triggerProject;
        this.projects = projects;
        this.draftMigration = draftMigration;
    }

    @Override
    public String buildProgressURL(Long taskId) {
        String url = "/secure/project/SelectProjectWorkflowSchemeStep3.jspa?taskId=" + taskId + "&draftMigration=" + this.isDraftMigration() + "&projectIdsParameter=" + this.getProjectIds();
        if (this.getTriggerProject() != null) {
            url = url + "&projectId=" + this.getTriggerProject().getId();
        }
        if (this.getSchemeId() != null) {
            url = url + "&schemeId=" + this.getSchemeId();
        }
        return url;
    }

    public Project getTriggerProject() {
        return this.triggerProject;
    }

    public Long getSchemeId() {
        return this.schemeId;
    }

    public boolean isDraftMigration() {
        return this.draftMigration;
    }

    public List<Project> getProjects() {
        return this.projects;
    }

    private String getProjectIds() {
        return SelectProjectWorkflowScheme.getProjectIdsParameter(this.getProjects());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnterpriseWorkflowTaskContext that = (EnterpriseWorkflowTaskContext)o;
        return CollectionUtils.isNotEmpty((Collection)CollectionUtils.intersection(this.getProjects(), that.getProjects()));
    }

    public int hashCode() {
        return 0;
    }
}

