/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.util.AttachmentUtils;
import com.atlassian.jira.util.BrowserUtils;
import com.atlassian.jira.util.IOUtil;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.util.HostileAttachmentsHelper;
import com.atlassian.jira.web.util.Ie6MimeSniffer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class MimeSniffingKit {
    public static final String CONTENT_DISPOSITION_ATTACHMENT = "attachment";
    public static final String CONTENT_DISPOSITION_INLINE = "inline";
    private static final Logger log = Logger.getLogger(MimeSniffingKit.class);
    private final ApplicationProperties applicationProperties;
    private HostileAttachmentsHelper attachmentHelper;

    public MimeSniffingKit(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
        this.attachmentHelper = new HostileAttachmentsHelper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttachmentResponseHeaders(Attachment attachment, String userAgent, HttpServletResponse httpServletResponse) throws IOException {
        String filename = attachment.getFilename();
        BufferedInputStream inputStream = null;
        try {
            inputStream = this.getInputStream(attachment);
            OpenAttachmentStrategy strategy = this.getOpenAttachmentStrategy(filename, attachment.getMimetype(), userAgent, inputStream);
            strategy.setResponseHeaders(httpServletResponse);
        }
        finally {
            if (inputStream != null) {
                IOUtil.shutdownStream(inputStream);
            }
        }
    }

    public void setAttachmentResponseHeaders(String fileName, String mimeContentType, String userAgent, BufferedInputStream inputStream, HttpServletResponse httpServletResponse) throws IOException {
        OpenAttachmentStrategy strategy = this.getOpenAttachmentStrategy(fileName, mimeContentType, userAgent, inputStream);
        strategy.setResponseHeaders(httpServletResponse);
    }

    private void setContentDispositionOnResponse(HttpServletResponse httpServletResponse, String filename, String contentDisposition) {
        String filenameEncoding = this.applicationProperties.getEncoding();
        httpServletResponse.setHeader("Content-Disposition", String.format("%s; filename*=%s''%s;", contentDisposition, filenameEncoding, JiraUrlCodec.encode((String)filename, (boolean)true)));
    }

    @Nonnull
    private OpenAttachmentStrategy getOpenAttachmentStrategy(String fileName, String mimeContentType, String userAgent, BufferedInputStream inputStream) throws IOException {
        String mimeSniffingPolicy = this.getMimeSniffingPolicy();
        boolean forceDownload = false;
        if (log.isDebugEnabled() && mimeSniffingPolicy.equalsIgnoreCase("insecure")) {
            log.debug((Object)"Mime sniffing policy is insecure, attachment will always be displayed inline");
        }
        if (!mimeSniffingPolicy.equalsIgnoreCase("insecure") && this.isExecutableContent(fileName, mimeContentType)) {
            forceDownload = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Attachment \"" + fileName + "\" (" + mimeContentType + ")" + " presents as executable content, forcing download."));
            }
        } else if (mimeSniffingPolicy.equalsIgnoreCase("workaround") && BrowserUtils.isIe456Or7((String)userAgent)) {
            Ie6MimeSniffer sniffer = new Ie6MimeSniffer();
            byte[] fileBytes = this.getLeadingInputStreamBytes(inputStream, 256);
            forceDownload = sniffer.smellsLikeHtml(fileBytes);
            if (forceDownload) {
                log.debug((Object)"Detected Internet Explorer and file contents would be sniffed as HTML, forcing download");
            }
        } else if (mimeSniffingPolicy.equalsIgnoreCase("secure")) {
            forceDownload = true;
        }
        return forceDownload ? new ForceDownload(fileName) : new ShowInline(fileName);
    }

    @VisibleForTesting
    File getFileForAttachment(Attachment attachment) {
        return AttachmentUtils.getAttachmentFile((Attachment)attachment);
    }

    @VisibleForTesting
    BufferedInputStream getInputStream(Attachment attachment) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(this.getFileForAttachment(attachment)));
    }

    @VisibleForTesting
    byte[] getLeadingInputStreamBytes(BufferedInputStream inputStream, int numBytes) throws IOException {
        byte[] fileBytes = new byte[numBytes];
        inputStream.mark(numBytes);
        ByteStreams.read((InputStream)inputStream, (byte[])fileBytes, (int)0, (int)numBytes);
        inputStream.reset();
        return fileBytes;
    }

    boolean isExecutableContent(String name, String contentType) {
        return this.attachmentHelper.isExecutableFileExtension(name) || this.attachmentHelper.isExecutableContentType(contentType);
    }

    private String getMimeSniffingPolicy() {
        String mimeSniffingPolicy = this.applicationProperties.getDefaultBackedString("jira.attachment.download.mime.sniffing.workaround");
        if (mimeSniffingPolicy == null) {
            mimeSniffingPolicy = "workaround";
            log.warn((Object)"Missing MIME sniffing policy application property jira.attachment.download.mime.sniffing.workaround ! Defaulting to workaround");
        }
        if (!("insecure".equalsIgnoreCase(mimeSniffingPolicy) || "secure".equalsIgnoreCase(mimeSniffingPolicy) || "workaround".equalsIgnoreCase(mimeSniffingPolicy))) {
            log.warn((Object)("MIME sniffing policy application property is invalid: " + mimeSniffingPolicy + " ! Defaulting to " + "workaround"));
            mimeSniffingPolicy = "workaround";
        }
        return mimeSniffingPolicy;
    }

    private class ForceDownload
    extends OpenAttachmentStrategy {
        private ForceDownload(String filename) {
            super(filename);
        }

        @Override
        public void setResponseHeaders(HttpServletResponse httpServletResponse) {
            MimeSniffingKit.this.setContentDispositionOnResponse(httpServletResponse, this.filename, MimeSniffingKit.CONTENT_DISPOSITION_ATTACHMENT);
            httpServletResponse.setHeader("X-Download-Options", "noopen");
        }
    }

    private class ShowInline
    extends OpenAttachmentStrategy {
        public ShowInline(String fileName) {
            super(fileName);
        }

        @Override
        public void setResponseHeaders(HttpServletResponse httpServletResponse) {
            MimeSniffingKit.this.setContentDispositionOnResponse(httpServletResponse, this.filename, MimeSniffingKit.CONTENT_DISPOSITION_INLINE);
        }
    }

    private abstract class OpenAttachmentStrategy {
        final String filename;

        public OpenAttachmentStrategy(String filename) {
            this.filename = (String)Preconditions.checkNotNull((Object)filename);
        }

        abstract void setResponseHeaders(HttpServletResponse var1);
    }
}

