/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.steps.instrumentation;

import com.atlassian.instrumentation.Gauge;
import com.atlassian.instrumentation.operations.OpTimer;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.web.filters.steps.FilterCallContext;
import com.atlassian.jira.web.filters.steps.FilterStep;

public class InstrumentationStep
implements FilterStep {
    private final Gauge concurrentRequestsGauge = Instrumentation.pullGauge(InstrumentationName.CONCURRENT_REQUESTS);
    private OpTimer requestTimer;

    @Override
    public FilterCallContext beforeDoFilter(FilterCallContext callContext) {
        this.requestTimer = Instrumentation.pullTimer(InstrumentationName.WEB_REQUESTS);
        this.concurrentRequestsGauge.incrementAndGet();
        return callContext;
    }

    @Override
    public FilterCallContext finallyAfterDoFilter(FilterCallContext callContext) {
        this.requestTimer.end();
        this.concurrentRequestsGauge.decrementAndGet();
        Instrumentation.snapshotThreadLocalOperationsAndClear();
        return callContext;
    }
}

