/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component.webfragment;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSectionImpl;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.component.AbstractWebComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class AdminTabsWebComponent
extends AbstractWebComponent {
    public static final String SYSTEM_ADMIN_TOP_NAVIGATION_BAR = "system.admin.top.navigation.bar";
    private static final String TEMPLATE = "templates/plugins/webfragments/system-admin-tabs.vm";
    private final SimpleLinkManager linkManager;
    private final JiraAuthenticationContext jac;

    public AdminTabsWebComponent(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, SimpleLinkManager linkManager, JiraAuthenticationContext jac) {
        super(templatingEngine, applicationProperties);
        this.linkManager = linkManager;
        this.jac = jac;
    }

    public Pair<String, Integer> render(Project project, String currentSection, String currentTabId) {
        Pair<List<TabGroup>, Integer> tabGroups = this.getTabs(project, currentSection, currentTabId);
        MapBuilder context = MapBuilder.newBuilder();
        context.add((Object)"project", (Object)project);
        if (project != null) {
            context.add((Object)"projectKeyEncoded", (Object)this.encode(project.getKey()));
        }
        context.add((Object)"tabGroups", tabGroups.first());
        context.add((Object)"numberOfTabs", tabGroups.second());
        return Pair.of((Object)this.getHtml(TEMPLATE, context.toMap()), (Object)tabGroups.second());
    }

    private Pair<List<TabGroup>, Integer> getTabs(Project project, String currentSectionId, String currentTabId) {
        MapBuilder context = MapBuilder.newBuilder();
        context.add((Object)"project", (Object)project);
        if (project != null) {
            context.add((Object)"projectKeyEncoded", (Object)this.encode(project.getKey()));
        }
        JiraHelper jiraHelper = new JiraHelper(this.getHttpRequest(), project, context.toMap());
        User loggedInUser = this.jac.getLoggedInUser();
        String requestURI = this.getHttpRequest().getRequestURI();
        List<SimpleLinkSection> linkSections = this.findRelevantSections(project, currentSectionId, jiraHelper, loggedInUser, requestURI);
        ArrayList<TabGroup> groups = new ArrayList<TabGroup>(linkSections.size());
        boolean foundSelected = false;
        Tab firstTab = null;
        int tabCount = 0;
        for (SimpleLinkSection section : linkSections) {
            String sectionId = project != null ? String.format("atl.jira.proj.config/%s", section.getId()) : section.getId();
            List linksForSection = this.linkManager.getLinksForSection(sectionId, loggedInUser, jiraHelper);
            if (linkSections.isEmpty()) continue;
            TabGroup group = new TabGroup();
            for (SimpleLink simpleLink : linksForSection) {
                boolean selected;
                String tabId = simpleLink.getId();
                boolean bl = selected = tabId != null && tabId.equalsIgnoreCase(currentTabId);
                if (!selected && StringUtils.isBlank((String)currentTabId) && requestURI.endsWith(JiraUrl.extractActionFromURL((String)simpleLink.getUrl()))) {
                    selected = true;
                }
                foundSelected = foundSelected || selected;
                Tab tab = new Tab(simpleLink, selected);
                ++tabCount;
                group.addTab(tab);
                if (firstTab != null) continue;
                firstTab = tab;
            }
            groups.add(group);
        }
        return Pair.of(groups, (Object)tabCount);
    }

    private List<SimpleLinkSection> findRelevantSections(Project project, String currentSectionId, JiraHelper jiraHelper, User loggedInUser, String requestURI) {
        List<SimpleLinkSection> linkSections = Collections.emptyList();
        if (currentSectionId == null) {
            SimpleLinkSection sectionForURL = this.linkManager.getSectionForURL(SYSTEM_ADMIN_TOP_NAVIGATION_BAR, requestURI, loggedInUser, jiraHelper);
            if (sectionForURL != null) {
                linkSections = Collections.singletonList(sectionForURL);
            }
        } else if (project != null) {
            linkSections = this.linkManager.getSectionsForLocation(currentSectionId, loggedInUser, jiraHelper);
        } else {
            SimpleLinkSection linkSection = this.getSectionFromKey(currentSectionId, loggedInUser, jiraHelper);
            if (linkSection != null) {
                linkSections = Collections.singletonList(linkSection);
            }
        }
        return linkSections;
    }

    private SimpleLinkSection getSectionFromKey(String currentSectionId, User loggedInUser, JiraHelper jiraHelper) {
        String[] cells = StringUtils.split((String)currentSectionId, (String)"/");
        if (cells != null && cells.length > 1) {
            int bottomOfHierarchy = cells.length - 1;
            String sectionLocation = cells[bottomOfHierarchy - 1];
            String sectionKey = cells[bottomOfHierarchy];
            for (SimpleLinkSection linkSection : this.linkManager.getSectionsForLocation(sectionLocation, loggedInUser, jiraHelper)) {
                if (!sectionKey.equals(linkSection.getId()) || linkSection.getLabel() == null) continue;
                return new SimpleLinkSectionImpl(sectionLocation + "/" + sectionKey, (SimpleLinkSectionImpl)linkSection);
            }
        }
        return null;
    }

    HttpServletRequest getHttpRequest() {
        return ExecutingHttpRequest.get();
    }

    String encode(String string) {
        return JiraUrlCodec.encode((String)string, (boolean)true);
    }

    public static class Tab {
        private final SimpleLink delegate;
        private boolean selected;

        Tab(SimpleLink delegate, boolean selected) {
            this.delegate = delegate;
            this.selected = selected;
        }

        public String getTitle() {
            return this.delegate.getTitle();
        }

        public String getLabel() {
            return this.delegate.getLabel();
        }

        public String getId() {
            return this.delegate.getId();
        }

        @NotNull
        public String getUrl() {
            return this.delegate.getUrl();
        }

        public boolean isSelected() {
            return this.selected;
        }

        void setSelected() {
            this.selected = true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tab tab = (Tab)o;
            if (this.selected != tab.selected) {
                return false;
            }
            return this.delegate.equals(tab.delegate);
        }

        public int hashCode() {
            int result = this.delegate.hashCode();
            result = 31 * result + (this.selected ? 1 : 0);
            return result;
        }
    }

    public static class TabGroup
    implements Iterable<Tab> {
        private final List<Tab> tabs = new ArrayList<Tab>();

        TabGroup() {
        }

        void addTab(Tab tab) {
            this.tabs.add(tab);
        }

        @Override
        public Iterator<Tab> iterator() {
            return this.tabs.iterator();
        }

        public List<Tab> getTabs() {
            return this.tabs;
        }

        public int size() {
            return this.tabs.size();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TabGroup tabGroup = (TabGroup)o;
            return ((Object)this.tabs).equals(tabGroup.tabs);
        }

        public int hashCode() {
            return ((Object)this.tabs).hashCode();
        }
    }
}

