/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.bc.filter.FilterSubscriptionService;
import com.atlassian.jira.issue.search.ClauseTooComplexSearchException;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.plugin.profile.UserFormatManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.sharing.type.ShareTypePermissionChecker;
import com.atlassian.jira.sharing.type.ShareTypeRenderer;
import com.atlassian.jira.user.util.UserNames;
import com.atlassian.jira.web.action.util.sharing.SharesListHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SearchRequestDisplayBean
implements SharesListHelper {
    private final JiraAuthenticationContext authCtx;
    private final SearchRequest request;
    private final SearchProvider searchProvider;
    private final FavouritesService favouriteService;
    private final PermissionManager permissionManager;
    private final FilterSubscriptionService subscriptionService;
    private final ShareTypeFactory shareTypeFactory;
    private final UserFormatManager userFormatManager;
    private Collection subscriptions;
    private long issueCount = -1L;
    private Boolean isFavourite = null;
    private Collection<SharePermission> sortedPermissions;
    private Collection<SharePermission> allSharePermissions;

    public SearchRequestDisplayBean(JiraAuthenticationContext authCtx, SearchRequest request, SearchProvider searchProvider, FavouritesService favouriteService, PermissionManager permissionManager, FilterSubscriptionService subscriptionService, ShareTypeFactory shareTypeFactory, UserFormatManager userFormatManager) {
        this.authCtx = authCtx;
        this.request = request;
        this.searchProvider = searchProvider;
        this.favouriteService = favouriteService;
        this.permissionManager = permissionManager;
        this.subscriptionService = subscriptionService;
        this.shareTypeFactory = shareTypeFactory;
        this.userFormatManager = userFormatManager;
    }

    @Override
    public Long getId() {
        return this.request.getId();
    }

    public String getOwnerUserName() {
        String userName = this.request.getOwnerUserName();
        if (userName != null) {
            return this.userFormatManager.formatUser(userName, "userName", "search_request");
        }
        return null;
    }

    public String getOwnerFullName() {
        String userName = this.request.getOwnerUserName();
        if (userName != null) {
            return this.userFormatManager.formatUser(userName, "fullName", "search_request");
        }
        return null;
    }

    public String getName() {
        return this.request.getName();
    }

    public boolean isCurrentOwner() {
        return UserNames.equal(this.getOwnerUserName(), this.authCtx.getLoggedInUser());
    }

    public String getDescription() {
        return this.request.getDescription();
    }

    public long getIssueCount() {
        if (this.issueCount == -1L) {
            try {
                this.issueCount = this.searchProvider.searchCount(this.request != null ? this.request.getQuery() : null, this.authCtx.getLoggedInUser());
            }
            catch (ClauseTooComplexSearchException e) {
                return -1L;
            }
            catch (SearchException e) {
                throw new RuntimeException(e);
            }
        }
        return this.issueCount;
    }

    public long getSubscriptionCount() {
        return this.getSubscriptions().size();
    }

    private Collection getSubscriptions() {
        if (this.subscriptions == null) {
            this.subscriptions = this.subscriptionService.getVisibleSubscriptions(this.authCtx.getLoggedInUser(), this.request);
        }
        return this.subscriptions;
    }

    @Override
    public boolean isPrivate() {
        return this.request.getPermissions().isPrivate();
    }

    public boolean isFavourite() {
        User user = this.authCtx.getLoggedInUser();
        if (this.isFavourite == null) {
            this.isFavourite = user == null ? Boolean.FALSE : Boolean.valueOf(this.favouriteService.isFavourite(user, (SharedEntity)this.request));
        }
        return this.isFavourite;
    }

    public Long getFavouriteCount() {
        return this.request.getFavouriteCount();
    }

    public long getAlternateFavouriteCount() {
        return this.isFavourite() ? (long)(this.request.getFavouriteCount().intValue() - 1) : (long)(this.request.getFavouriteCount().intValue() + 1);
    }

    public boolean canShare() {
        return this.permissionManager.hasPermission(22, this.authCtx.getLoggedInUser());
    }

    public boolean canEditColumns() {
        return true;
    }

    @Override
    public Collection<SharePermission> getSharePermissions() {
        if (this.sortedPermissions == null) {
            ArrayList<SharePermission> permissions;
            if (this.isCurrentOwner()) {
                permissions = new ArrayList(this.request.getPermissions().getPermissionSet());
            } else {
                permissions = new ArrayList<SharePermission>();
                for (SharePermission sharePermission : this.request.getPermissions()) {
                    ShareTypePermissionChecker permissionChecker;
                    ShareType type = this.shareTypeFactory.getShareType(sharePermission.getType());
                    if (type == null || !(permissionChecker = type.getPermissionsChecker()).hasPermission(this.authCtx.getLoggedInUser(), sharePermission)) continue;
                    permissions.add(sharePermission);
                }
            }
            Collections.sort(permissions, this.shareTypeFactory.getPermissionComparator());
            this.sortedPermissions = permissions;
        }
        return this.sortedPermissions;
    }

    public Collection<SharePermission> getAllSharePermissions() {
        if (this.permissionManager.hasPermission(0, this.authCtx.getLoggedInUser())) {
            if (this.allSharePermissions == null) {
                ArrayList permissions = Lists.newArrayList((Iterable)this.request.getPermissions());
                Collections.sort(permissions, this.shareTypeFactory.getPermissionComparator());
                this.allSharePermissions = permissions;
            }
            return this.allSharePermissions;
        }
        return this.getSharePermissions();
    }

    public String getShareView(SharePermission sharePermission) {
        ShareType type = this.shareTypeFactory.getShareType(sharePermission.getType());
        if (type != null) {
            ShareTypeRenderer shareTypeRenderer = type.getRenderer();
            return shareTypeRenderer.renderPermission(sharePermission, this.authCtx);
        }
        return null;
    }

    public String getSimpleDescription(SharePermission sharePermission) {
        ShareType type = this.shareTypeFactory.getShareType(sharePermission.getType());
        if (type != null) {
            ShareTypeRenderer shareTypeRenderer = type.getRenderer();
            return shareTypeRenderer.getSimpleDescription(sharePermission, this.authCtx);
        }
        return null;
    }

    public static class Factory {
        private final JiraAuthenticationContext authCtx;
        private final SearchProvider searchProvider;
        private final FavouritesService favouriteService;
        private final PermissionManager permissionManager;
        private final FilterSubscriptionService subscriptionService;
        private final ShareTypeFactory shareTypeFactory;
        private final UserFormatManager userFormatManager;

        public Factory(JiraAuthenticationContext authCtx, SearchProvider searchProvider, FavouritesService favouriteService, PermissionManager permissionManager, FilterSubscriptionService subscriptionService, ShareTypeFactory shareTypeFactory, UserFormatManager userFormatManager) {
            this.authCtx = authCtx;
            this.searchProvider = searchProvider;
            this.favouriteService = favouriteService;
            this.permissionManager = permissionManager;
            this.subscriptionService = subscriptionService;
            this.shareTypeFactory = shareTypeFactory;
            this.userFormatManager = userFormatManager;
        }

        public SearchRequestDisplayBean createDisplayBean(SearchRequest request) {
            return new SearchRequestDisplayBean(this.authCtx, request, this.searchProvider, this.favouriteService, this.permissionManager, this.subscriptionService, this.shareTypeFactory, this.userFormatManager);
        }

        public List<SearchRequestDisplayBean> createDisplayBeans(Collection<SearchRequest> requests) {
            if (requests == null || requests.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<SearchRequestDisplayBean> displayList = new ArrayList<SearchRequestDisplayBean>(requests.size());
            for (SearchRequest searchRequest : requests) {
                displayList.add(this.createDisplayBean(searchRequest));
            }
            return displayList;
        }
    }
}

