/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.MutableComment;
import com.atlassian.jira.issue.fields.CommentVisibility;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.web.action.issue.AbstractCommentableIssue;
import java.util.HashMap;
import java.util.Map;
import webwork.action.ActionContext;

public class EditComment
extends AbstractCommentableIssue {
    private CommentService commentService;
    private Long commentId;
    private MutableComment commentObject;
    private static final String ERROR_KEY_NO_ASSOC_ISSUE = "edit.comment.no.associated.issue";
    private static final String ERROR_NO_PERMISSION = "errorNoPermission";

    public EditComment(SubTaskManager subTaskManager, FieldScreenRendererFactory fieldScreenRendererFactory, FieldManager fieldManager, ProjectRoleManager projectRoleManager, CommentService commentService, UserUtil userUtil) {
        super(subTaskManager, fieldScreenRendererFactory, fieldManager, projectRoleManager, commentService, userUtil);
        this.commentService = commentService;
    }

    @Override
    protected void doValidation() {
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (!this.commentService.hasPermissionToEdit(this.getJiraServiceContext(), this.getCommentId())) {
            return ERROR_NO_PERMISSION;
        }
        CommentVisibility commentVisibility = new CommentVisibility(this.getCommentLevel());
        String roleLevel = commentVisibility.getRoleLevel();
        this.commentService.validateCommentUpdate(this.getLoggedInUser(), this.getCommentId(), this.getComment(), commentVisibility.getGroupLevel(), roleLevel == null ? null : new Long(roleLevel), (ErrorCollection)this);
        MutableComment commentObject = this.getCommentObject();
        if (commentObject == null) {
            return "error";
        }
        Issue issue = commentObject.getIssue();
        if (issue == null) {
            this.addErrorMessage(this.getText(ERROR_KEY_NO_ASSOC_ISSUE, commentObject.getId()));
            return "error";
        }
        OrderableField field = (OrderableField)ComponentManager.getInstance().getFieldManager().getField("comment");
        field.populateFromParams(this.getFieldValuesHolder(), ActionContext.getParameters());
        if (this.hasAnyErrors()) {
            return "error";
        }
        Long roleLevelId = commentVisibility.getRoleLevel() == null ? null : new Long(commentVisibility.getRoleLevel());
        commentObject.setBody(this.getComment());
        commentObject.setGroupLevel(commentVisibility.getGroupLevel());
        commentObject.setRoleLevelId(roleLevelId);
        this.commentService.update(this.getLoggedInUser(), commentObject, true, (ErrorCollection)this);
        String baseUrl = "/browse/" + issue.getKey();
        UrlBuilder urlBuilder = new UrlBuilder(baseUrl);
        urlBuilder.addParameter("focusedCommentId", this.getCommentId().toString());
        urlBuilder.addParameter("page", "com.atlassian.jira.plugin.system.issuetabpanels:comment-tabpanel");
        urlBuilder.addAnchor("comment-" + this.getCommentId().toString());
        return this.getRedirect(urlBuilder.asUrlString());
    }

    public String doDefault() throws Exception {
        if (!this.commentService.hasPermissionToEdit(this.getJiraServiceContext(), this.getCommentId())) {
            return ERROR_NO_PERMISSION;
        }
        MutableComment commentObject = this.getCommentObject();
        if (commentObject == null) {
            return "error";
        }
        if (!this.commentService.hasPermissionToEdit(this.getLoggedInUser(), (Comment)commentObject, (ErrorCollection)this)) {
            return "error";
        }
        HashMap<String, String[]> initialValues = new HashMap<String, String[]>();
        initialValues.put("comment", new String[]{commentObject.getBody()});
        initialValues.put("commentLevel", new String[]{CommentVisibility.getCommentLevelFromLevels(commentObject.getGroupLevel(), commentObject.getRoleLevelId())});
        OrderableField commentField = (OrderableField)this.getField("comment");
        commentField.populateFromParams(this.getFieldValuesHolder(), initialValues);
        return super.doDefault();
    }

    public void setCommentId(Long id) {
        this.commentId = id;
    }

    public Long getCommentId() {
        return this.commentId;
    }

    public MutableComment getCommentObject() {
        if (this.commentObject == null) {
            this.commentObject = this.commentService.getMutableComment(this.getLoggedInUser(), this.getCommentId(), (ErrorCollection)this);
        }
        return this.commentObject;
    }

    @Override
    public Map<String, Object> getDisplayParams() {
        HashMap<String, Object> displayParams = new HashMap<String, Object>(super.getDisplayParams());
        displayParams.put("theme", "aui");
        return displayParams;
    }
}

