/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.core.util.FileSize;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.bc.issue.attachment.AttachmentService;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.TemporaryAttachmentsMonitorLocator;
import com.atlassian.jira.issue.attachment.TemporaryAttachment;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.AttachmentUtils;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.web.action.issue.AbstractCommentableIssue;
import com.atlassian.jira.web.action.issue.TemporaryAttachmentsMonitor;
import com.atlassian.jira.web.util.AttachmentException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;

public class AttachFile
extends AbstractCommentableIssue
implements OperationContext {
    private final AttachmentService attachmentService;
    private final AttachmentManager attachmentManager;
    private final IssueUpdater issueUpdater;
    private final TemporaryAttachmentsMonitorLocator temporaryAttachmentsMonitorLocator;
    private long maxSize = Long.MIN_VALUE;
    private String[] filetoconvert;
    private static final String FILETOCONVERT = "filetoconvert";

    public AttachFile(SubTaskManager subTaskManager, FieldScreenRendererFactory fieldScreenRendererFactory, FieldManager fieldManager, ProjectRoleManager projectRoleManager, CommentService commentService, AttachmentService attachmentService, AttachmentManager attachmentManager, IssueUpdater issueUpdater, TemporaryAttachmentsMonitorLocator temporaryAttachmentsMonitorLocator, UserUtil userUtil) {
        super(subTaskManager, fieldScreenRendererFactory, fieldManager, projectRoleManager, commentService, userUtil);
        this.attachmentService = attachmentService;
        this.attachmentManager = attachmentManager;
        this.issueUpdater = issueUpdater;
        this.temporaryAttachmentsMonitorLocator = temporaryAttachmentsMonitorLocator;
    }

    public String doDefault() throws Exception {
        this.clearTemporaryAttachmentsForIssue();
        try {
            this.attachmentService.canCreateAttachments(this.getJiraServiceContext(), (Issue)this.getIssueObject());
        }
        catch (IssueNotFoundException e) {
            return "error";
        }
        catch (IssuePermissionException e) {
            return "error";
        }
        return "input";
    }

    @Override
    protected void doValidation() {
        try {
            this.attachmentService.canCreateAttachments(this.getJiraServiceContext(), (Issue)this.getIssueObject());
            super.doValidation();
        }
        catch (IssueNotFoundException ex) {
            return;
        }
        catch (IssuePermissionException ex) {
            return;
        }
        try {
            AttachmentUtils.checkValidAttachmentDirectory((Issue)this.getIssueObject());
        }
        catch (AttachmentException e) {
            this.addErrorMessage(e.getMessage());
        }
        List<Long> filesToConvert = this.getTemporaryFileIdsToConvert();
        if (filesToConvert.isEmpty()) {
            this.addError("tempFilename", this.getText("attachfile.error.filerequired"));
        } else {
            for (Long tempAttachmentId : filesToConvert) {
                TemporaryAttachment temporaryAttachment = this.getTemporaryAttachment(tempAttachmentId);
                if (temporaryAttachment != null && temporaryAttachment.getFile().exists()) continue;
                this.addError("tempFilename", this.getText("attachment.temporary.id.session.time.out"));
                break;
            }
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        ArrayList changeItemBeans = new ArrayList();
        List<Long> fileIdsToConvert = this.getTemporaryFileIdsToConvert();
        try {
            TemporaryAttachmentsMonitor temporaryAttachmentsMonitor = this.temporaryAttachmentsMonitorLocator.get(false);
            if (temporaryAttachmentsMonitor == null) {
                this.addError(FILETOCONVERT, this.getText("attachment.temporary.session.time.out"));
                return "error";
            }
            changeItemBeans.addAll(this.attachmentManager.convertTemporaryAttachments(this.getLoggedInUser(), (Issue)this.getIssueObject(), fileIdsToConvert, temporaryAttachmentsMonitor));
        }
        catch (AttachmentException e) {
            this.addError(FILETOCONVERT, e.getMessage());
            return "error";
        }
        this.clearTemporaryAttachmentsForIssue();
        IssueUpdateBean issueUpdateBean = new IssueUpdateBean(this.getIssue(), this.getIssue(), EventType.ISSUE_UPDATED_ID, this.getLoggedInUser());
        issueUpdateBean.setComment(this.createComment());
        issueUpdateBean.setChangeItems(changeItemBeans);
        issueUpdateBean.setDispatchEvent(true);
        issueUpdateBean.setParams(EasyMap.build((Object)"eventsource", (Object)"action"));
        this.issueUpdater.doUpdate(issueUpdateBean, true);
        if (this.isInlineDialogMode()) {
            return this.returnComplete();
        }
        return this.getRedirect(this.redirectToAttachments());
    }

    private void clearTemporaryAttachmentsForIssue() throws GenericEntityException {
        this.temporaryAttachmentsMonitorLocator.get(true).clearEntriesForIssue(this.getId());
    }

    public String getTargetUrl() {
        return this.isInlineDialogMode() ? this.redirectToIssue() : this.redirectToAttachments();
    }

    private String redirectToAttachments() {
        return "ManageAttachments.jspa?id=" + this.getIssue().getLong("id");
    }

    private String redirectToIssue() {
        return this.getViewUrl();
    }

    public String[] getFiletoconvert() {
        return this.filetoconvert;
    }

    public void setFiletoconvert(String[] filetoconvert) {
        this.filetoconvert = filetoconvert;
    }

    public boolean isFileToConvertChecked(Long tempFileId) {
        List<Long> fileIds = this.getTemporaryFileIdsToConvert();
        return fileIds.contains(tempFileId);
    }

    public long getMaxSize() {
        if (this.maxSize != Long.MIN_VALUE) {
            return this.maxSize;
        }
        try {
            this.maxSize = Long.parseLong(this.getApplicationProperties().getString("webwork.multipart.maxSize"));
        }
        catch (NumberFormatException e) {
            this.maxSize = -1L;
        }
        return this.maxSize;
    }

    public String getMaxSizePretty() {
        long maxSize = this.getMaxSize();
        if (maxSize > 0L) {
            return FileSize.format((long)maxSize);
        }
        return "Unknown?";
    }

    private List<Long> getTemporaryFileIdsToConvert() {
        String[] strings = this.getFiletoconvert();
        if (strings == null) {
            return Collections.emptyList();
        }
        List<String> fileIdStrings = Arrays.asList(strings);
        return CollectionUtil.transform(fileIdStrings, (Function)new Function<String, Long>(){

            public Long get(String input) {
                return Long.parseLong(input);
            }
        });
    }

    @Override
    public Map<String, Object> getDisplayParams() {
        HashMap<String, Object> displayParams = new HashMap<String, Object>(super.getDisplayParams());
        displayParams.put("theme", "aui");
        return displayParams;
    }

    public List<TemporaryAttachment> getTemporaryAttachments() throws GenericEntityException {
        TemporaryAttachmentsMonitor temporaryAttachmentsMonitor = this.temporaryAttachmentsMonitorLocator.get(true);
        return new ArrayList<TemporaryAttachment>(temporaryAttachmentsMonitor.getByIssueId(this.getId()));
    }

    private TemporaryAttachment getTemporaryAttachment(Long temporaryAttachmentId) {
        TemporaryAttachmentsMonitor temporaryAttachmentsMonitor = this.temporaryAttachmentsMonitorLocator.get(false);
        if (temporaryAttachmentsMonitor != null) {
            return temporaryAttachmentsMonitor.getById(temporaryAttachmentId);
        }
        return null;
    }
}

