/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.vcs;

import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.vcs.RepositoryManager;
import com.atlassian.jira.vcs.cvsimpl.CvsRepositoryUtil;
import com.atlassian.jira.web.action.admin.vcs.RepositoryActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import org.ofbiz.core.entity.GenericEntityException;

@WebSudoRequired
public class DeleteRepository
extends RepositoryActionSupport {
    private boolean confirmed;

    public DeleteRepository(RepositoryManager repositoryManager, CvsRepositoryUtil cvsRepositoryUtil) {
        super(repositoryManager, cvsRepositoryUtil);
    }

    @Override
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    protected void doValidation() {
        if (this.getId() == null || !this.isConfirmed()) {
            this.addErrorMessage(this.getText("admin.errors.repositories.confirm.deletion"));
        }
        if (!this.isDeletable()) {
            this.addErrorMessage(this.getText("admin.errors.repositories.cannot.delete.repository"));
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        try {
            this.getRepositoryManager().removeRepository(this.getId());
        }
        catch (Exception e) {
            this.log.error((Object)("Error occurred while removing the repository with id '" + this.getId() + "'."), (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.repositories.error.occured.removing"));
            return this.getResult();
        }
        return this.getRedirect("ViewRepositories.jspa");
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public boolean isDeletable() {
        try {
            return this.getRepositoryManager().getProjectsForRepository(this.getRepositoryManager().getRepository(this.getId())).isEmpty();
        }
        catch (GenericEntityException e) {
            this.log.error((Object)("Error occurred while retrieving the repository with id '" + this.getId() + "'."), (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.repositories.error.occured.removing.repository", "'" + this.getId() + "'"));
            return false;
        }
    }
}

