/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuesecurity;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecurityLevelPermission;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.issue.security.ProjectIssueSecuritySchemeHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.SecurityTypeManager;
import com.atlassian.jira.web.action.admin.issuesecurity.SchemeAwareIssueSecurityAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class EditIssueSecurities
extends SchemeAwareIssueSecurityAction {
    private String name;
    private String description;
    private Long levelId;
    private List<Project> projects;
    private final ProjectIssueSecuritySchemeHelper helper;
    private final IssueSecurityLevelManager issueSecurityLevelManager;

    public EditIssueSecurities(IssueSecuritySchemeManager issueSecuritySchemeManager, SecurityTypeManager issueSecurityTypeManager, IssueSecurityLevelManager issueSecurityLevelManager, ProjectIssueSecuritySchemeHelper helper) {
        super(issueSecuritySchemeManager, issueSecurityTypeManager);
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.helper = helper;
    }

    public List<IssueSecurityLevel> getSecurityLevels() {
        return this.issueSecurityLevelManager.getIssueSecurityLevels(this.getSchemeId().longValue());
    }

    public List<IssueSecurityLevelPermission> getSecurities(IssueSecurityLevel issueSecurityLevel) {
        return this.issueSecuritySchemeManager.getPermissionsBySecurityLevel(issueSecurityLevel.getId());
    }

    public String doAddLevel() throws Exception {
        if (this.name == null || "".equals(this.name.trim())) {
            this.addError("name", this.getText("admin.errors.specify.name.for.security"));
        }
        if (ComponentAccessor.getOfBizDelegator().findByAnd("SchemeIssueSecurityLevels", EasyMap.build((Object)"scheme", (Object)this.getSchemeId(), (Object)"name", (Object)this.name.trim())).size() > 0) {
            this.addError("name", this.getText("admin.errors.security.level.with.name.already.exists"));
        }
        if (this.getErrors().isEmpty()) {
            EntityUtils.createValue("SchemeIssueSecurityLevels", EasyMap.build((Object)"scheme", (Object)this.getSchemeId(), (Object)"name", (Object)this.name, (Object)"description", (Object)this.description));
        }
        return this.getRedirect(this.getRedirectURL());
    }

    public String doMakeDefaultLevel() throws Exception {
        GenericValue scheme = this.getScheme();
        if (scheme != null) {
            if (new Long(-1L).equals(this.levelId)) {
                scheme.set("defaultlevel", null);
            } else {
                scheme.set("defaultlevel", (Object)this.levelId);
            }
            this.issueSecuritySchemeManager.updateScheme(scheme);
        }
        return this.getRedirect(this.getRedirectURL());
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getLevelId() {
        return this.levelId;
    }

    public void setLevelId(Long levelId) {
        this.levelId = levelId;
    }

    @Override
    public String getRedirectURL() {
        return "EditIssueSecurities!default.jspa?schemeId=" + this.getSchemeId();
    }

    public List<Project> getUsedIn() {
        if (this.projects == null) {
            Scheme issueSecurityScheme = this.getSchemeObject();
            this.projects = this.helper.getSharedProjects(issueSecurityScheme);
        }
        return this.projects;
    }
}

