/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.loader.LDAPDirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.upgrade.tasks.util.Sequences;
import com.atlassian.jira.user.DefaultUserPropertyManager;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.user.util.UserUtilImpl;
import com.atlassian.jira.web.util.HelpUtil;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseTypeFactory;

public class UpgradeTask_Build602
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build602.class);
    private final GenericDelegator genericDelegator;
    private final CrowdDirectoryService crowdDirectoryService;
    private final LDAPDirectoryInstanceLoader ldapDirectoryInstanceLoader;
    private final Sequences sequences;
    private Long internalDirectoryID;
    private boolean internalDirectoryExists;
    private boolean delegatingDirectoryExists;
    private List<RemoteDirectory> remoteDirectories = new ArrayList<RemoteDirectory>();
    private final String upgradeGuideUrl;
    private final String upgradeGuideTitle;
    private int maxExternalEntityId = 0;
    private int nextGroupId = 10000;
    private static final String LOGIN_INFO_ATTRIBUTES = " 'login.lastLoginMillis', 'login.previousLoginMillis', 'login.lastFailedLoginMillis', 'login.count', 'login.currentFailedCount', 'login.totalFailedCount' ";
    private boolean useSavePoints;

    public UpgradeTask_Build602(GenericDelegator genericDelegator, CrowdDirectoryService crowdDirectoryService, LDAPDirectoryInstanceLoader ldapDirectoryInstanceLoader, Sequences sequences) {
        super(false);
        this.genericDelegator = genericDelegator;
        this.crowdDirectoryService = crowdDirectoryService;
        this.ldapDirectoryInstanceLoader = ldapDirectoryInstanceLoader;
        this.sequences = sequences;
        HelpUtil.HelpPath helpPath = HelpUtil.getInstance().getHelpPath("upgrading");
        this.upgradeGuideUrl = helpPath.getUrl();
        this.upgradeGuideTitle = helpPath.getTitle();
    }

    @Override
    public String getBuildNumber() {
        return "602";
    }

    @Override
    public String getShortDescription() {
        return "Converting Users and Groups to new structure for Crowd Embedded.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        Connection connection = this.getDatabaseConnection();
        this.useSavePoints = connection.getMetaData().supportsSavepoints() && !this.isORACLE(connection) && !this.isMSSQL(connection);
        boolean committed = false;
        try {
            connection.setAutoCommit(false);
            if (this.crowdAlreadyInitialised(connection)) {
                log.warn((Object)"The crowd embedded tables already contain data.  No conversion will be performed.");
                return;
            }
            this.getDirectoryInfo(connection);
            boolean ok = true;
            if (ok) {
                ok &= this.migrateGroups(connection);
            }
            if (ok) {
                ok &= this.migrateGroupPropertySets(connection);
            }
            if (ok) {
                ok &= this.migrateUsers(connection);
            }
            if (ok) {
                ok &= this.migrateUserProperties(connection);
            }
            if (ok) {
                ok &= this.migrateMemberships(connection);
            }
            if (ok) {
                this.cleanOldTables(connection);
                connection.commit();
                committed = true;
            }
        }
        finally {
            if (!committed) {
                connection.rollback();
            }
            connection.close();
        }
        this.flushUserCaches();
    }

    private void getDirectoryInfo(Connection connection) throws SQLException, DirectoryInstantiationException {
        this.internalDirectoryID = 1L;
        this.internalDirectoryExists = false;
        this.delegatingDirectoryExists = false;
        String selectSql = "select id, directory_type from " + this.convertToSchemaTableName("cwd_directory") + " order by directory_position";
        PreparedStatement selectStmt = connection.prepareStatement(selectSql);
        ResultSet rs = selectStmt.executeQuery();
        while (rs.next()) {
            String directoryType = rs.getString("directory_type");
            if (directoryType.equals(DirectoryType.INTERNAL.toString())) {
                this.internalDirectoryExists = true;
                this.internalDirectoryID = rs.getLong("id");
                continue;
            }
            if (!directoryType.equals(DirectoryType.DELEGATING.toString())) continue;
            this.delegatingDirectoryExists = true;
            Directory delegatingDirectory = this.crowdDirectoryService.findDirectoryById(rs.getLong("id"));
            Directory ldap = this.getLdapVersionOfDirectory(delegatingDirectory);
            this.remoteDirectories.add(this.ldapDirectoryInstanceLoader.getDirectory(ldap));
        }
    }

    private void flushUserCaches() {
        UserUtil userUtil = ComponentAccessor.getUserUtil();
        if (userUtil instanceof UserUtilImpl) {
            ((UserUtilImpl)userUtil).flushUserCaches();
        } else {
            log.error((Object)("Expected to find a UserUtilImpl, but got " + userUtil.getClass().getName()));
        }
        UserPropertyManager propertyManager = ComponentAccessor.getUserPropertyManager();
        if (propertyManager instanceof DefaultUserPropertyManager) {
            ((DefaultUserPropertyManager)propertyManager).onClearCache(null);
        } else {
            log.error((Object)("Expected to find a DefaultUserPropertyManager, but got " + propertyManager.getClass().getName()));
        }
        this.genericDelegator.refreshSequencer();
    }

    private void cleanOldTables(Connection connection) throws SQLException {
        Statement stmt = connection.createStatement();
        stmt.execute("delete from " + this.convertToSchemaTableName("membershipbase"));
        stmt.execute("delete from " + this.convertToSchemaTableName("groupbase"));
        stmt.execute("delete from " + this.convertToSchemaTableName("userbase"));
        stmt.execute("delete from " + this.convertToSchemaTableName("propertystring") + " where id in (select id from " + this.convertToSchemaTableName("propertyentry") + " where entity_name = 'OSUser')");
        stmt.execute("delete from " + this.convertToSchemaTableName("propertytext") + " where id in (select id from " + this.convertToSchemaTableName("propertyentry") + " where entity_name = 'OSUser')");
        stmt.execute("delete from " + this.convertToSchemaTableName("propertydate") + " where id in (select id from " + this.convertToSchemaTableName("propertyentry") + " where entity_name = 'OSUser')");
        stmt.execute("delete from " + this.convertToSchemaTableName("propertydecimal") + " where id in (select id from " + this.convertToSchemaTableName("propertyentry") + " where entity_name = 'OSUser')");
        stmt.execute("delete from " + this.convertToSchemaTableName("propertynumber") + " where id in (select id from " + this.convertToSchemaTableName("propertyentry") + " where entity_name = 'OSUser')");
        stmt.execute("delete from " + this.convertToSchemaTableName("propertyentry") + " where entity_name = 'OSUser'");
    }

    @SuppressWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="Non-constant but safe.")
    private boolean migrateUsers(Connection connection) throws SQLException, OperationFailedException {
        String selectSql = "select ub.id as id, ub.username as username, psname.propertyvalue as fullname, psmail.propertyvalue as email, ub.password_hash as credential  from " + this.convertToSchemaTableName("userbase") + " ub " + " left outer join " + this.convertToSchemaTableName("propertyentry") + " pename on (ub.id = pename.entity_id) and (pename.entity_name = 'OSUser' and pename.property_key = 'fullName') " + " left outer join " + this.convertToSchemaTableName("propertystring") + " psname ON psname.id = pename.id " + " left outer join " + this.convertToSchemaTableName("propertyentry") + " pemail on (ub.id = pemail.entity_id) and (pemail.entity_name = 'OSUser' and pemail.property_key = 'email') " + " left outer join " + this.convertToSchemaTableName("propertystring") + " psmail ON psmail.id = pemail.id ";
        String insertSql = "insert into " + this.convertToSchemaTableName("cwd_user") + " (id, directory_id, user_name, lower_user_name, active, created_date, updated_date, first_name, lower_first_name, " + "  last_name, lower_last_name, display_name, lower_display_name, email_address, lower_email_address,  credential)" + "  values (?, ?, ?, ?, 1, current_timestamp, current_timestamp, '', '', '', '', ?, ?, ?, ?, ?)";
        PreparedStatement selectStmt = connection.prepareStatement(selectSql);
        PreparedStatement insertStmt = connection.prepareStatement(insertSql);
        ResultSet rs = selectStmt.executeQuery();
        while (rs.next()) {
            int id = rs.getInt("id");
            String userName = rs.getString("username");
            String fullName = rs.getString("fullname");
            String email = rs.getString("email");
            String credential = rs.getString("credential");
            long directoryId = this.getDirectoryIdForUser(userName);
            insertStmt.setLong(1, id);
            insertStmt.setLong(2, directoryId);
            insertStmt.setString(3, userName);
            insertStmt.setString(4, userName.toLowerCase());
            insertStmt.setString(5, fullName);
            insertStmt.setString(6, fullName == null ? null : fullName.toLowerCase());
            insertStmt.setString(7, email);
            insertStmt.setString(8, email == null ? null : email.toLowerCase());
            insertStmt.setString(9, credential);
            Savepoint savePoint = null;
            try {
                savePoint = this.setSavepoint(connection);
                insertStmt.execute();
                this.releaseSavepoint(connection, savePoint);
                this.migrateUserLoginAttributes(connection, id, directoryId);
            }
            catch (SQLException sqlex) {
                log.warn((Object)("User not migrated. User: " + userName + ". Error: " + sqlex.getMessage()));
                this.rollBackSavePoint(connection, savePoint);
            }
        }
        rs.close();
        selectStmt.close();
        insertStmt.close();
        this.sequences.update(connection, "User", "cwd_user");
        this.sequences.update(connection, "UserAttribute", "cwd_user_attributes");
        return true;
    }

    private long getDirectoryIdForUser(String userName) throws OperationFailedException {
        for (RemoteDirectory remoteDirectory : this.remoteDirectories) {
            try {
                remoteDirectory.findUserByName(userName);
                return remoteDirectory.getDirectoryId();
            }
            catch (UserNotFoundException e) {
            }
        }
        return this.internalDirectoryID;
    }

    private Directory getLdapVersionOfDirectory(Directory directory) {
        DirectoryImpl ldap = new DirectoryImpl(directory);
        String ldapClass = directory.getValue("crowd.delegated.directory.type");
        ldap.setImplementationClass(ldapClass);
        return ldap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean migrateUserProperties(Connection connection) throws SQLException {
        PreparedStatement stmt = connection.prepareStatement("select max(id) from " + this.convertToSchemaTableName("external_entities"));
        ResultSet rs = stmt.executeQuery();
        if (rs.next()) {
            this.maxExternalEntityId = rs.getInt(1);
        }
        rs.close();
        stmt.close();
        String selectSql = "select id, entity_id, property_key        from " + this.convertToSchemaTableName("propertyentry") + " pe " + "      where pe.entity_name = 'OSUser' " + "        and pe.property_key not in ('fullName', 'email') " + "        and pe.property_key not in (" + LOGIN_INFO_ATTRIBUTES + ") ";
        String updateSql = "update " + this.convertToSchemaTableName("propertyentry") + " set entity_id = ?, entity_name = 'ExternalEntity' " + "  where id = ?";
        String checkDupSql = "select id from " + this.convertToSchemaTableName("propertyentry") + "  where entity_name = 'ExternalEntity' and entity_id = ? and property_key= ?";
        String deleteSql = "delete from " + this.convertToSchemaTableName("propertyentry") + "  where id = ?";
        PreparedStatement selectStmt = connection.prepareStatement(selectSql);
        PreparedStatement updateStmt = connection.prepareStatement(updateSql);
        PreparedStatement checkDupStmt = connection.prepareStatement(checkDupSql);
        PreparedStatement deleteStmt = connection.prepareStatement(deleteSql);
        rs = selectStmt.executeQuery();
        while (rs.next()) {
            int entityId;
            String key;
            int id;
            block9: {
                id = rs.getInt("id");
                int crowdUserId = rs.getInt("entity_id");
                key = rs.getString("property_key");
                entityId = 0;
                try {
                    entityId = this.getExternalEntityId(connection, crowdUserId);
                }
                catch (UserNotFoundException e) {
                    log.warn((Object)("User property not migrated. User Id : " + entityId + ", property key : " + key + ". user noes not exist."));
                }
                checkDupStmt.setInt(1, crowdUserId);
                checkDupStmt.setString(2, key);
                ResultSet rsChk = checkDupStmt.executeQuery();
                try {
                    if (!rsChk.next()) break block9;
                    if (!this.internalDirectoryExists) continue;
                    deleteStmt.setInt(1, rsChk.getInt("id"));
                    deleteStmt.execute();
                }
                finally {
                    rsChk.close();
                    continue;
                }
            }
            updateStmt.setInt(1, entityId);
            updateStmt.setInt(2, id);
            Savepoint savePoint = null;
            try {
                savePoint = this.setSavepoint(connection);
                updateStmt.execute();
                this.releaseSavepoint(connection, savePoint);
            }
            catch (SQLException sqlex) {
                log.warn((Object)("Attribute not migrated. User Id : " + entityId + ", attribute key : " + key + ". Error: " + sqlex.getMessage()));
                this.rollBackSavePoint(connection, savePoint);
            }
        }
        rs.close();
        selectStmt.close();
        updateStmt.close();
        checkDupStmt.close();
        deleteStmt.close();
        this.sequences.update(connection, "ExternalEntity", "external_entities");
        return true;
    }

    private boolean migrateUserLoginAttributes(Connection connection, long userId, long directoryId) throws SQLException {
        String selectSql = "select pe.id as id, pe.entity_id as user_id, pe.property_key as property_key, ps.propertyvalue as property_value       from " + this.convertToSchemaTableName("propertyentry") + " pe join " + this.convertToSchemaTableName("propertystring") + " ps ON ps.id = pe.id " + "      where pe.entity_name = 'OSUser' and pe.property_key in (" + LOGIN_INFO_ATTRIBUTES + ") and pe.entity_id = ?";
        String insertSql = "insert into " + this.convertToSchemaTableName("cwd_user_attributes") + " (id, user_id, directory_id, attribute_name, attribute_value, lower_attribute_value) " + "  values (?,?,?,?,?,?)";
        PreparedStatement selectStmt = connection.prepareStatement(selectSql);
        PreparedStatement insertStmt = connection.prepareStatement(insertSql);
        selectStmt.setLong(1, userId);
        ResultSet rs = selectStmt.executeQuery();
        while (rs.next()) {
            long id = rs.getLong("id");
            long entityId = rs.getLong("user_id");
            String key = rs.getString("property_key");
            String propertyValue = rs.getString("property_value");
            insertStmt.setLong(1, id);
            insertStmt.setLong(2, entityId);
            insertStmt.setLong(3, directoryId);
            insertStmt.setString(4, key);
            insertStmt.setString(5, propertyValue);
            insertStmt.setString(6, propertyValue == null ? null : propertyValue.toLowerCase());
            Savepoint savePoint = null;
            try {
                savePoint = this.setSavepoint(connection);
                insertStmt.execute();
                this.releaseSavepoint(connection, savePoint);
            }
            catch (SQLException sqlex) {
                log.warn((Object)("Attribute not migrated. User Id : " + entityId + ", attribute key : " + key + ". Error: " + sqlex.getMessage()));
                this.rollBackSavePoint(connection, savePoint);
            }
        }
        rs.close();
        selectStmt.close();
        insertStmt.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getExternalEntityId(Connection connection, int crowdUserId) throws SQLException, UserNotFoundException {
        String selectCrowdUser = "select user_name from " + this.convertToSchemaTableName("cwd_user") + " where id = ?";
        String selectExternalEntity = "select id from " + this.convertToSchemaTableName("external_entities") + " where name = ? and entitytype = 'com.atlassian.jira.user.OfbizExternalEntityStore'";
        String insertExternalEntity = "insert into " + this.convertToSchemaTableName("external_entities") + " (id, name, entitytype) values(?, ?, 'com.atlassian.jira.user.OfbizExternalEntityStore')";
        PreparedStatement stmtCrowdUser = connection.prepareStatement(selectCrowdUser);
        PreparedStatement stmtExternalEntity = connection.prepareStatement(selectExternalEntity);
        PreparedStatement stmtInsertExternalEntity = connection.prepareStatement(insertExternalEntity);
        try {
            ResultSet rs2;
            String name;
            block13: {
                int n;
                block12: {
                    stmtCrowdUser.setInt(1, crowdUserId);
                    ResultSet rs = stmtCrowdUser.executeQuery();
                    try {
                        if (rs.next()) {
                            name = rs.getString("user_name");
                            break block12;
                        }
                        throw new UserNotFoundException(String.valueOf(crowdUserId));
                    }
                    finally {
                        rs.close();
                    }
                }
                stmtExternalEntity.setString(1, name);
                rs2 = stmtExternalEntity.executeQuery();
                try {
                    if (!rs2.next()) break block13;
                    n = rs2.getInt("id");
                }
                catch (Throwable throwable) {
                    rs2.close();
                    throw throwable;
                }
                rs2.close();
                return n;
            }
            ++this.maxExternalEntityId;
            stmtInsertExternalEntity.setInt(1, this.maxExternalEntityId);
            stmtInsertExternalEntity.setString(2, name);
            stmtInsertExternalEntity.execute();
            int n = this.maxExternalEntityId;
            rs2.close();
            return n;
        }
        finally {
            stmtCrowdUser.close();
            stmtExternalEntity.close();
            stmtInsertExternalEntity.close();
        }
    }

    private boolean migrateGroups(Connection connection) throws SQLException {
        boolean ok = true;
        if (this.internalDirectoryExists) {
            ok = this.migrateGroups(connection, this.internalDirectoryID);
        }
        if (ok && this.delegatingDirectoryExists) {
            for (RemoteDirectory remoteDirectory : this.remoteDirectories) {
                ok &= this.migrateGroups(connection, remoteDirectory.getDirectoryId());
            }
        }
        this.sequences.update(connection, "Group", "cwd_group");
        return ok;
    }

    private boolean migrateGroups(Connection connection, long directoryId) throws SQLException {
        String selectSql = " select id, groupname from " + this.convertToSchemaTableName("groupbase");
        String insertSql = "insert into " + this.convertToSchemaTableName("cwd_group") + " (id, group_name, lower_group_name, active, local, created_date, updated_date, description, group_type, directory_id) " + "  values (?, ?, ?, 1, 0, current_timestamp, current_timestamp, '', 'GROUP' ,?)";
        PreparedStatement selectStmt = connection.prepareStatement(selectSql);
        PreparedStatement insertStmt = connection.prepareStatement(insertSql);
        ResultSet rs = selectStmt.executeQuery();
        boolean ok = true;
        while (rs.next()) {
            int id;
            ++this.nextGroupId;
            String groupname = rs.getString("groupname");
            insertStmt.setInt(1, id);
            insertStmt.setString(2, groupname);
            insertStmt.setString(3, groupname.toLowerCase());
            insertStmt.setLong(4, directoryId);
            Savepoint savePoint = null;
            try {
                savePoint = this.setSavepoint(connection);
                insertStmt.execute();
                this.releaseSavepoint(connection, savePoint);
            }
            catch (SQLException sqlex) {
                log.warn((Object)("Group not migrated. Group: " + groupname + ". Error: " + sqlex.getMessage()));
                this.rollBackSavePoint(connection, savePoint);
                if (sqlex.getSQLState() != null && sqlex.getSQLState().startsWith("23")) {
                    this.addError(this.getI18nBean().getText("admin.errors.upgrade.602.duplicate.group", groupname, this.upgradeGuideUrl, this.upgradeGuideTitle));
                } else {
                    this.addError(this.getI18nBean().getText("admin.errors.upgrade.602.bad.group", groupname, sqlex.getMessage()));
                }
                ok = false;
            }
        }
        rs.close();
        selectStmt.close();
        insertStmt.close();
        return ok;
    }

    private boolean migrateGroupPropertySets(Connection connection) throws SQLException {
        String sql = "update " + this.convertToSchemaTableName("propertyentry") + " set entity_name = 'Group'" + " where entity_name = 'OSGroup'";
        Statement stmt = connection.createStatement();
        stmt.execute(sql);
        stmt.close();
        return true;
    }

    @SuppressWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="There is no risk of external SQL injection")
    private boolean migrateMemberships(Connection connection) throws SQLException {
        String selectSql = "select mb.id as id, cg.id as groupid, cu.id as userid, cu.user_name as username, cu.directory_id as directoryid, cg.group_name as groupname, cu.user_name as username   from " + this.convertToSchemaTableName("membershipbase") + " mb, " + this.convertToSchemaTableName("cwd_user") + " cu, " + this.convertToSchemaTableName("cwd_group") + " cg " + "  where mb.group_name = cg.group_name and mb.user_name = cu.user_name and cu.directory_id = cg.directory_id";
        String insertSql = "insert into " + this.convertToSchemaTableName("cwd_membership") + " (id, parent_id, child_id, membership_type, group_type, parent_name, lower_parent_name, child_name, lower_child_name, directory_id) " + "  values (?, ?, ?, 'GROUP_USER', NULL, ?, ?, ?, ?, ?)";
        PreparedStatement selectStmt = connection.prepareStatement(selectSql);
        PreparedStatement insertStmt = connection.prepareStatement(insertSql);
        ResultSet rs = selectStmt.executeQuery();
        while (rs.next()) {
            int id = rs.getInt("id");
            int groupId = rs.getInt("groupid");
            int userId = rs.getInt("userid");
            String userName = rs.getString("username");
            int directoryId = rs.getInt("directoryid");
            String groupName = rs.getString("groupname");
            insertStmt.setInt(1, id);
            insertStmt.setInt(2, groupId);
            insertStmt.setInt(3, userId);
            insertStmt.setString(4, groupName);
            insertStmt.setString(5, groupName.toLowerCase());
            insertStmt.setString(6, userName);
            insertStmt.setString(7, userName.toLowerCase());
            insertStmt.setInt(8, directoryId);
            Savepoint savePoint = null;
            try {
                connection.getHoldability();
                savePoint = this.setSavepoint(connection);
                insertStmt.execute();
                this.releaseSavepoint(connection, savePoint);
            }
            catch (SQLException sqlex) {
                log.warn((Object)("Membership not migrated. Group: " + groupName + " User: " + userName + ". Error: " + sqlex.getMessage()));
                this.rollBackSavePoint(connection, savePoint);
            }
        }
        rs.close();
        selectStmt.close();
        insertStmt.close();
        this.sequences.update(connection, "Membership", "cwd_membership");
        return true;
    }

    private boolean crowdAlreadyInitialised(Connection connection) throws SQLException {
        return !this.isTableEmpty(connection, "cwd_user") || !this.isTableEmpty(connection, "cwd_group") || !this.isTableEmpty(connection, "cwd_membership");
    }

    private boolean isTableEmpty(Connection connection, String tableName) throws SQLException {
        Statement stmt = connection.createStatement();
        String sql = "select count(*) from " + this.convertToSchemaTableName(tableName);
        ResultSet rs = stmt.executeQuery(sql);
        rs.next();
        int count = rs.getInt(1);
        rs.close();
        stmt.close();
        return count == 0;
    }

    private void checkForTruncatedData(Connection connection, String tableName) throws SQLException {
        Statement stmt = connection.createStatement();
        String condition = this.isMSSQL(connection) ? "LEN(cast(propertyvalue as varchar(max))) > 255" : (this.isMYSQL(connection) ? "CHAR_LENGTH(propertyvalue) > 255" : "LENGTH(propertyvalue) > 255");
        String sql = "select count(*) from " + this.convertToSchemaTableName(tableName) + " where " + condition;
        ResultSet rs = stmt.executeQuery(sql);
        rs.next();
        int count = rs.getInt(1);
        rs.close();
        stmt.close();
        if (count > 0) {
            log.warn((Object)(String.valueOf(count) + " instances of user attribute data have been truncated at 255 characters. The first " + Math.min(5, count) + " samples are listed below"));
            stmt = connection.createStatement();
            sql = "select propertyvalue from " + this.convertToSchemaTableName(tableName) + " where " + condition;
            rs = stmt.executeQuery(sql);
            for (int i = 0; i < 5 && rs.next(); ++i) {
                log.warn((Object)rs.getString(1));
            }
            rs.close();
            stmt.close();
        }
    }

    private boolean isORACLE(Connection connection) throws SQLException {
        DatabaseType databaseType = DatabaseTypeFactory.getTypeForConnection((Connection)connection);
        return databaseType.getFieldTypeName().startsWith("oracle");
    }

    private boolean isMSSQL(Connection connection) throws SQLException {
        DatabaseType databaseType = DatabaseTypeFactory.getTypeForConnection((Connection)connection);
        return databaseType.getFieldTypeName().startsWith("mssql");
    }

    private boolean isMYSQL(Connection connection) throws SQLException {
        DatabaseType databaseType = DatabaseTypeFactory.getTypeForConnection((Connection)connection);
        return databaseType.getFieldTypeName().startsWith("mysql");
    }

    private Savepoint setSavepoint(Connection connection) throws SQLException {
        if (this.useSavePoints) {
            return connection.setSavepoint("atlassian");
        }
        return null;
    }

    private void releaseSavepoint(Connection connection, Savepoint savePoint) throws SQLException {
        if (this.useSavePoints) {
            connection.releaseSavepoint(savePoint);
        }
    }

    private void rollBackSavePoint(Connection connection, Savepoint savePoint) throws SQLException {
        if (this.useSavePoints && savePoint != null) {
            connection.rollback(savePoint);
        }
    }

    private static interface AttributeConverter {
        public String convert(Object var1) throws SQLException;
    }
}

