/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.jira.bean.export.IllegalXMLCharactersException;
import com.atlassian.jira.upgrade.UpgradeHistoryItem;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;

public interface UpgradeManager {
    public Status doSetupUpgrade();

    public Status doUpgradeIfNeededAndAllowed(@Nullable String var1) throws IllegalXMLCharactersException;

    public String getExportFilePath();

    public List<UpgradeHistoryItem> getUpgradeHistory();

    public static class Status {
        private final boolean reindexPerformed;
        private final Collection<String> errors;

        public Status(String error) {
            this.reindexPerformed = false;
            this.errors = ImmutableList.of((Object)error);
        }

        public Status(boolean reindexPerformed, Collection<String> errors) {
            this.reindexPerformed = reindexPerformed;
            this.errors = errors;
        }

        public boolean reindexPerformed() {
            return this.reindexPerformed;
        }

        public boolean succesful() {
            return CollectionUtils.isEmpty(this.errors);
        }

        public Collection<String> getErrors() {
            return this.errors;
        }
    }
}

