/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.type;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.customfields.impl.MultiUserCFType;
import com.atlassian.jira.issue.customfields.impl.UserCFType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.type.AbstractIssueFieldSecurityType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class UserCF
extends AbstractIssueFieldSecurityType {
    public static final String TYPE = "userCF";
    private static final Logger log = Logger.getLogger(UserCF.class);
    private JiraAuthenticationContext jiraAuthenticationContext;
    private final CustomFieldManager customFieldManager;

    public UserCF(JiraAuthenticationContext jiraAuthenticationContext, CustomFieldManager customFieldManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.customFieldManager = customFieldManager;
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.permission.types.user.custom.field");
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void doValidation(String key, Map parameters, JiraServiceContext jiraServiceContext) {
        String customFieldOption = (String)parameters.get(this.getType());
        if (StringUtils.isEmpty((String)customFieldOption)) {
            String localisedMessage = jiraServiceContext.getI18nBean().getText("admin.permissions.errors.please.select.user.customfield");
            jiraServiceContext.getErrorCollection().addErrorMessage(localisedMessage);
        } else {
            CustomField customField = this.customFieldManager.getCustomFieldObject(customFieldOption);
            if (customField != null && customField.getCustomFieldSearcher() == null) {
                String localisedMessage = jiraServiceContext.getI18nBean().getText("admin.permissions.errors.customfieldnotindexed", customField.getName());
                jiraServiceContext.getErrorCollection().addErrorMessage(localisedMessage);
            }
        }
    }

    @Override
    protected String getFieldName(String parameter) {
        return parameter;
    }

    @Override
    protected boolean hasProjectPermission(User user, boolean issueCreation, GenericValue project) {
        return !issueCreation;
    }

    @Override
    protected boolean hasProjectPermission(User user, boolean issueCreation, Project project) {
        return !issueCreation;
    }

    @Override
    protected boolean hasIssuePermission(User user, boolean issueCreation, GenericValue issueGv, String customFieldName) {
        CustomFieldManager customFieldManager = ComponentAccessor.getCustomFieldManager();
        IssueFactory issueFactory = ComponentManager.getComponentInstanceOfType(IssueFactory.class);
        CustomField field = customFieldManager.getCustomFieldObject(customFieldName);
        if (field != null) {
            Set values = this.convertToValueSet(this.getValuesFromIssue(field, (Issue)issueFactory.getIssue(issueGv)));
            return values.contains(user);
        }
        return false;
    }

    @Override
    protected boolean hasIssuePermission(User user, boolean issueCreation, Issue issue, String parameter) {
        CustomFieldManager customFieldManager = ComponentAccessor.getCustomFieldManager();
        CustomField field = customFieldManager.getCustomFieldObject(parameter);
        if (field != null) {
            Set values = this.convertToValueSet(this.getValuesFromIssue(field, issue));
            return values.contains(user);
        }
        return false;
    }

    public List getDisplayFields() {
        Set fieldSet;
        ArrayList<Field> fields = new ArrayList<Field>();
        FieldManager fieldManager = this.getFieldManager();
        try {
            fieldSet = fieldManager.getAllAvailableNavigableFields();
        }
        catch (FieldException e) {
            return Collections.EMPTY_LIST;
        }
        for (Field field : fieldSet) {
            CustomField customField;
            if (!fieldManager.isCustomField(field) || !((customField = (CustomField)field).getCustomFieldType() instanceof UserCFType) && !(customField.getCustomFieldType() instanceof MultiUserCFType)) continue;
            fields.add(field);
        }
        return fields;
    }

    @Override
    public String getArgumentDisplay(String argument) {
        CustomFieldManager fieldManager = ComponentAccessor.getCustomFieldManager();
        CustomField field = fieldManager.getCustomFieldObject(argument);
        return field != null ? field.getName() : argument;
    }

    @Override
    public Set<User> getUsers(PermissionContext ctx, String customFieldId) {
        if (ctx.getIssue() == null) {
            log.info((Object)("Could not retrieve users for UserCF '" + customFieldId + "' since provided PermissionContext has no issue."));
            return Collections.EMPTY_SET;
        }
        Issue issue = ctx.getIssue();
        FieldManager fieldManager = this.getFieldManager();
        CustomField field = fieldManager.getCustomField(customFieldId);
        return this.convertToValueSet(this.getValuesFromIssue(field, issue));
    }

    Object getValuesFromIssue(CustomField field, Issue issue) {
        return field.getCustomFieldType().getValueFromIssue(field, issue);
    }

    FieldManager getFieldManager() {
        return ComponentManager.getInstance().getFieldManager();
    }

    Set convertToValueSet(Object fieldValues) {
        HashSet<Object> users = new HashSet<Object>(1);
        if (fieldValues != null) {
            if (fieldValues instanceof Collection) {
                users.addAll((Collection)fieldValues);
            } else {
                users.add(fieldValues);
            }
        }
        return users;
    }
}

