/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.auth.trustedapps;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.auth.trustedapps.UserNameTransformer;
import com.atlassian.jira.util.dbc.Null;
import com.atlassian.security.auth.trustedapps.ApplicationCertificate;
import com.atlassian.security.auth.trustedapps.CurrentApplication;
import com.atlassian.security.auth.trustedapps.TrustedApplication;
import com.atlassian.security.auth.trustedapps.TrustedApplicationsManager;
import com.atlassian.security.auth.trustedapps.UserResolver;
import com.atlassian.seraph.filter.TrustedApplicationsFilter;
import java.security.Principal;

public class TrustedApplicationFilter
extends TrustedApplicationsFilter {
    public TrustedApplicationFilter() {
        super((TrustedApplicationsManager)new DelegateManager(), (UserResolver)new OSUserResolver());
    }

    private static class DelegateManager
    implements TrustedApplicationsManager {
        private DelegateManager() {
        }

        public TrustedApplication getTrustedApplication(String id) {
            return this.getDelegate().getTrustedApplication(id);
        }

        public CurrentApplication getCurrentApplication() {
            return this.getDelegate().getCurrentApplication();
        }

        private TrustedApplicationsManager getDelegate() {
            return ComponentManager.getInstance().getTrustedApplicationsManager();
        }
    }

    private static class OSUserResolver
    implements UserResolver {
        private final UserNameTransformer transformer;

        public OSUserResolver() {
            UserNameTransformer.Factory factory = new UserNameTransformer.Factory(new UserNameTransformer.ApplicationPropertiesClassNameRetriever(ComponentManager.getInstance().getApplicationProperties()));
            this.transformer = factory.get();
            Null.not("transformer", this.transformer);
        }

        public Principal resolve(ApplicationCertificate certificate) {
            Null.not("ApplicationCertificate", certificate);
            String name = this.transformer.transform(certificate.getUserName());
            return ComponentAccessor.getUserUtil().getUser(name);
        }
    }
}

