/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.auth;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.security.login.LoginLoggers;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.plugin.webwork.WebworkPluginSecurityServiceHelper;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.security.auth.Authorisation;
import com.atlassian.jira.security.auth.AuthorisationManager;
import com.atlassian.jira.security.auth.AuthorisationModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class AuthorisationManagerImpl
implements AuthorisationManager,
Startable {
    private static final Logger loggerSecurityEvents = LoginLoggers.LOGIN_SECURITY_EVENTS;
    private final PermissionManager permissionManager;
    private final PluginAccessor pluginAccessor;
    private final WebworkPluginSecurityServiceHelper webworkPluginSecurityServiceHelper;
    private final EventPublisher eventPublisher;
    private final ResettableLazyReference<Iterable<Authorisation>> authorisationsRef = new ResettableLazyReference<Iterable<Authorisation>>(){

        protected Iterable<Authorisation> create() throws Exception {
            return AuthorisationManagerImpl.this.buildEnabledAuthorisers();
        }
    };

    Iterable<Authorisation> buildEnabledAuthorisers() {
        List modules = Lists.transform((List)this.pluginAccessor.getEnabledModuleDescriptorsByClass(AuthorisationModuleDescriptor.class), (Function)new Function<AuthorisationModuleDescriptor, Authorisation>(){

            public Authorisation apply(AuthorisationModuleDescriptor input) {
                return (Authorisation)input.getModule();
            }
        });
        return Iterables.filter((Iterable)modules, (Predicate)Predicates.notNull());
    }

    public AuthorisationManagerImpl(PermissionManager permissionManager, PluginAccessor pluginAccessor, WebworkPluginSecurityServiceHelper webworkPluginSecurityServiceHelper, EventPublisher eventPublisher) {
        this.permissionManager = permissionManager;
        this.pluginAccessor = pluginAccessor;
        this.webworkPluginSecurityServiceHelper = webworkPluginSecurityServiceHelper;
        this.eventPublisher = eventPublisher;
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @PluginEventListener
    public void onPluginModuleEnabled(PluginModuleEnabledEvent event) {
        if (event.getModule() instanceof AuthorisationModuleDescriptor) {
            this.authorisationsRef.reset();
        }
    }

    @PluginEventListener
    public void onPluginModuleDisabled(PluginModuleDisabledEvent event) {
        if (event.getModule() instanceof AuthorisationModuleDescriptor) {
            this.authorisationsRef.reset();
        }
    }

    @Override
    public boolean authoriseForLogin(@Nonnull User user, HttpServletRequest httpServletRequest) {
        boolean authorised;
        Authorisation.Decision decision = this.authoriseForLoginViaPlugins(user, httpServletRequest);
        if (decision == Authorisation.Decision.ABSTAIN) {
            decision = this.authoriseForLoginViaJIRA(user);
        }
        if (!(authorised = decision.toBoolean())) {
            loggerSecurityEvents.warn((Object)("The user '" + this.safeUserName(user) + "' is NOT AUTHORIZED to perform to login for this request"));
        }
        return authorised;
    }

    private Authorisation.Decision authoriseForLoginViaPlugins(final User user, final HttpServletRequest httpServletRequest) {
        for (final Authorisation authorisation : (Iterable)this.authorisationsRef.get()) {
            Authorisation.Decision decision = this.safeRun(authorisation, user, new Callable<Authorisation.Decision>(){

                @Override
                public Authorisation.Decision call() throws Exception {
                    return authorisation.authoriseForLogin(user, httpServletRequest);
                }
            });
            if (decision == Authorisation.Decision.ABSTAIN) continue;
            return decision;
        }
        return Authorisation.Decision.ABSTAIN;
    }

    private Authorisation.Decision authoriseForLoginViaJIRA(User user) {
        return Authorisation.Decision.toDecision((this.permissionManager.hasPermission(0, user) || this.permissionManager.hasPermission(1, user) ? 1 : 0) != 0);
    }

    @Override
    public Set<String> getRequiredRoles(HttpServletRequest httpServletRequest) {
        HashSet requiredRoles = Sets.newHashSet(this.webworkPluginSecurityServiceHelper.getRequiredRoles(httpServletRequest));
        for (Authorisation authorisation : (Iterable)this.authorisationsRef.get()) {
            try {
                Set set = authorisation.getRequiredRoles(httpServletRequest);
                requiredRoles.addAll(this.safeSet(set));
            }
            catch (RuntimeException e) {
                loggerSecurityEvents.error((Object)String.format("Exception thrown by '%s'. The roles will be ignored : %s", authorisation.getClass().getName(), e.getMessage()));
            }
        }
        return requiredRoles;
    }

    @Override
    public boolean authoriseForRole(@Nullable User user, HttpServletRequest httpServletRequest, String role) {
        boolean authorised;
        Authorisation.Decision decision = this.authoriseForRoleViaPlugins(user, httpServletRequest, role);
        if (decision == Authorisation.Decision.ABSTAIN) {
            decision = this.authoriseForRoleViaJIRA(user, role);
        }
        if (!(authorised = decision.toBoolean())) {
            loggerSecurityEvents.warn((Object)("The user '" + this.safeUserName(user) + "' is NOT AUTHORIZED to perform this request"));
        }
        return authorised;
    }

    private Authorisation.Decision authoriseForRoleViaPlugins(final User user, final HttpServletRequest httpServletRequest, final String role) {
        for (final Authorisation authorisation : (Iterable)this.authorisationsRef.get()) {
            Authorisation.Decision decision = this.safeRun(authorisation, user, new Callable<Authorisation.Decision>(){

                @Override
                public Authorisation.Decision call() throws Exception {
                    return authorisation.authoriseForRole(user, httpServletRequest, role);
                }
            });
            if (decision == Authorisation.Decision.ABSTAIN) continue;
            return decision;
        }
        return Authorisation.Decision.ABSTAIN;
    }

    private Authorisation.Decision authoriseForRoleViaJIRA(User user, String role) {
        int permissionType = Permissions.getType((String)role);
        if (permissionType == -1) {
            return Authorisation.Decision.DENIED;
        }
        return Authorisation.Decision.toDecision((boolean)this.permissionManager.hasPermission(permissionType, user));
    }

    private Authorisation.Decision safeRun(Authorisation authorisation, User user, Callable<Authorisation.Decision> callable) {
        try {
            Authorisation.Decision decision = callable.call();
            if (loggerSecurityEvents.isDebugEnabled()) {
                loggerSecurityEvents.debug((Object)String.format("%s has authorised '%s' as %s", authorisation.getClass().getName(), this.safeUserName(user), decision));
            }
            return decision;
        }
        catch (Exception e) {
            loggerSecurityEvents.error((Object)String.format("Exception thrown by '%s'. The decision will be treated as ABSTAIN : %s", authorisation.getClass().getName(), e.getMessage()));
            return Authorisation.Decision.ABSTAIN;
        }
    }

    private String safeUserName(User user) {
        return user == null ? "anonymous" : user.getName();
    }

    private Set<String> safeSet(Set<String> set) {
        return set == null ? Collections.emptySet() : set;
    }
}

