/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraPermission;
import com.atlassian.jira.security.JiraPermissionImpl;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class GlobalPermissionsCache {
    private static final Logger log = Logger.getLogger(GlobalPermissionsCache.class);
    private Set<JiraPermission> permissions;
    private Map<JiraPermission, GenericValue> permGVs;

    GlobalPermissionsCache() {
        log.debug((Object)"GlobalPermissionsCache.GlobalPermissionsCache");
        try {
            this.refresh();
        }
        catch (Throwable t) {
            log.error((Object)("Exception constructing GlobalPermissionsCache: " + t), t);
        }
    }

    public synchronized void refresh() {
        this.permissions = new HashSet<JiraPermission>();
        this.permGVs = new HashMap<JiraPermission, GenericValue>();
        List allPermissions = ComponentAccessor.getOfBizDelegator().findByAnd("SchemePermissions", MapBuilder.build((Object)"scheme", null));
        for (GenericValue permissionGV : allPermissions) {
            JiraPermissionImpl jiraPerm = new JiraPermissionImpl(permissionGV);
            boolean added = this.permissions.add(jiraPerm);
            added = this.permGVs.put(jiraPerm, permissionGV) == null && added;
            if (added) continue;
            log.warn((Object)("Could not add permission " + jiraPerm + " - it already existed?"));
        }
    }

    public boolean hasPermission(JiraPermission jiraPermission) {
        return this.permissions.contains(jiraPermission);
    }

    public GenericValue getPermission(JiraPermission jiraPermission) {
        return this.permGVs.get(jiraPermission);
    }

    public Set<JiraPermission> getPermissions() {
        return this.permissions;
    }

    public Collection<JiraPermission> getPermissions(int permissionType) {
        if (!Permissions.isGlobalPermission((int)permissionType)) {
            throw new IllegalArgumentException("PermissionType passed must be a global permissions " + permissionType + " is not");
        }
        ArrayList<JiraPermission> matchingPerms = new ArrayList<JiraPermission>();
        for (JiraPermission perm : this.permissions) {
            if (perm.getType() != permissionType) continue;
            matchingPerms.add(perm);
        }
        return matchingPerms;
    }
}

