/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.propertyset;

import com.atlassian.jira.ofbiz.DefaultOfBizConnectionFactory;
import com.atlassian.jira.ofbiz.OfBizConnectionFactory;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.util.HashMap;

public class DefaultJiraPropertySetFactory
implements JiraPropertySetFactory {
    private static final Long DEFAULT_ENTITY_ID = 1L;
    private final OfBizConnectionFactory ofBizConnectionFactory = DefaultOfBizConnectionFactory.getInstance();

    public PropertySet buildNoncachingPropertySet(String entityName) {
        return this.buildNoncachingPropertySet(entityName, DEFAULT_ENTITY_ID);
    }

    public PropertySet buildNoncachingPropertySet(String entityName, Long entityId) {
        HashMap ofbizArgs = MapBuilder.newBuilder().add((Object)"delegator.name", (Object)this.ofBizConnectionFactory.getDelegatorName()).add((Object)"entityName", (Object)entityName).add((Object)"entityId", (Object)entityId).toHashMap();
        return this.createPropertySet("ofbiz", ofbizArgs);
    }

    public PropertySet buildCachingDefaultPropertySet(String entityName, boolean bulkLoad) {
        return this.buildCachingPropertySet(this.buildNoncachingPropertySet(entityName), bulkLoad);
    }

    public PropertySet buildCachingPropertySet(String entityName, Long entityId, boolean bulkLoad) {
        return this.buildCachingPropertySet(this.buildNoncachingPropertySet(entityName, entityId), bulkLoad);
    }

    public PropertySet buildCachingPropertySet(PropertySet propertySet, boolean bulkLoad) {
        Preconditions.checkNotNull((Object)propertySet, (Object)"propertySet is a required parameter");
        HashMap arguments = MapBuilder.newBuilder().add((Object)"PropertySet", (Object)propertySet).add((Object)"bulkload", (Object)bulkLoad).toHashMap();
        return this.createPropertySet("cached", arguments);
    }

    public PropertySet buildMemoryPropertySet(String entityName, Long entityId) {
        PropertySet dbPropertySet = this.buildNoncachingPropertySet(entityName, entityId);
        PropertySet memoryPropertySet = this.createPropertySet("memory", Maps.newHashMap());
        PropertySetManager.clone((PropertySet)dbPropertySet, (PropertySet)memoryPropertySet);
        return memoryPropertySet;
    }

    PropertySet createPropertySet(String propertySetDelegator, HashMap<String, Object> ofbizArgs) {
        return PropertySetManager.getInstance((String)propertySetDelegator, ofbizArgs);
    }
}

