/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.report.impl;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.web.bean.PagerFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

class SubTaskFetcher {
    private static final Logger log = Logger.getLogger(SubTaskFetcher.class);
    private final SearchProvider searchProvider;

    SubTaskFetcher(SearchProvider searchProvider) {
        this.searchProvider = searchProvider;
    }

    List<Issue> getSubTasks(User user, List<Issue> parentIssues, String subtaskInclusion, boolean onlyIncludeUnresolved) throws SearchException {
        if ("onlySelected".equals(subtaskInclusion)) {
            return Collections.emptyList();
        }
        if (parentIssues == null || parentIssues.isEmpty()) {
            return Collections.emptyList();
        }
        JqlClauseBuilder queryBuilder = this.getSearchForSubTasks(parentIssues, onlyIncludeUnresolved);
        if ("selectedAndBlank".equals(subtaskInclusion)) {
            queryBuilder.and().fixVersionIsEmpty();
        }
        SearchResults subtaskSearchResults = this.searchProvider.search(queryBuilder.buildQuery(), user, new PagerFilter(Integer.MAX_VALUE));
        return subtaskSearchResults.getIssues();
    }

    List<Issue> getSubTasksForUser(User user, List<Issue> parentIssues, String subtaskInclusion, boolean onlyIncludeUnresolved) throws SearchException {
        if ("onlyAssigned".equals(subtaskInclusion)) {
            return Collections.emptyList();
        }
        if (!"assignedAndUnassigned".equals(subtaskInclusion)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Unknown Subtask Inclusion parameter: " + subtaskInclusion));
            }
            return Collections.emptyList();
        }
        if (parentIssues == null || parentIssues.isEmpty()) {
            return Collections.emptyList();
        }
        JqlClauseBuilder whereClauseBuilder = this.getSearchForSubTasks(parentIssues, onlyIncludeUnresolved);
        whereClauseBuilder.and().assigneeIsEmpty();
        SearchResults subtaskSearchResults = this.searchProvider.search(whereClauseBuilder.buildQuery(), user, new PagerFilter(Integer.MAX_VALUE));
        return subtaskSearchResults.getIssues();
    }

    private JqlClauseBuilder getSearchForSubTasks(List<Issue> parentIssues, boolean onlyIncludeUnresolved) {
        List parentIssueIds = CollectionUtil.transform(parentIssues, (Function)new Function<Issue, Long>(){

            public Long get(Issue input) {
                return input.getId();
            }
        });
        JqlClauseBuilder builder = JqlQueryBuilder.newBuilder().where().issueParent().inNumbers((Collection)parentIssueIds);
        if (onlyIncludeUnresolved) {
            builder = builder.and().unresolved();
        }
        return builder;
    }
}

