/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.componentpanel.fragment.impl;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.plugin.componentpanel.BrowseComponentContext;
import com.atlassian.jira.plugin.componentpanel.fragment.ComponentTabPanelFragment;
import com.atlassian.jira.plugin.profile.UserFormatManager;
import com.atlassian.jira.plugin.projectpanel.fragment.impl.AbstractFragment;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ComponentDescriptionFragment
extends AbstractFragment
implements ComponentTabPanelFragment {
    private static final String TEMPLATE_DIRECTORY_PATH = "templates/plugins/jira/componentpanels/fragments/summary/";
    private final UserFormatManager userFormatManager;

    public ComponentDescriptionFragment(VelocityTemplatingEngine templatingEngine, JiraAuthenticationContext jiraAuthenticationContext, UserFormatManager userFormatManager) {
        super(templatingEngine, jiraAuthenticationContext);
        this.userFormatManager = userFormatManager;
    }

    @Override
    public String getId() {
        return "componentdescription";
    }

    @Override
    public boolean showFragment(BrowseContext ctx) {
        try {
            ProjectComponent component = ((BrowseComponentContext)ctx).getComponent();
            return !StringUtils.isBlank((String)component.getDescription()) || component.getLead() != null;
        }
        catch (ClassCastException e) {
            log.error((Object)"The supplied context must be of type BrowseComponentContext", (Throwable)e);
            throw new IllegalArgumentException("The supplied context must be of type BrowseComponentContext", e);
        }
    }

    @Override
    protected String getTemplateDirectoryPath() {
        return TEMPLATE_DIRECTORY_PATH;
    }

    @Override
    protected Map<String, Object> createVelocityParams(BrowseContext ctx) {
        Map<String, Object> velocityParams = super.createVelocityParams(ctx);
        velocityParams.put("userFormat", this.userFormatManager.getUserFormat("profileLink"));
        return velocityParams;
    }
}

