/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.notification.NotificationFilter;
import com.atlassian.jira.notification.NotificationFilterManager;
import com.atlassian.jira.notification.NotificationFilterModuleDescriptor;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class NotificationFilterManagerImpl
implements NotificationFilterManager,
Startable {
    private static final Logger log = Logger.getLogger(NotificationFilterManagerImpl.class);
    private final PluginAccessor pluginAccessor;
    private final EventPublisher eventPublisher;
    private final ResettableLazyReference<Iterable<NotificationFilter>> enabledFilters = new ResettableLazyReference<Iterable<NotificationFilter>>(){

        protected Iterable<NotificationFilter> create() throws Exception {
            return NotificationFilterManagerImpl.this.buildEnabledNotificationFilters();
        }
    };

    public NotificationFilterManagerImpl(PluginAccessor pluginAccessor, EventPublisher eventPublisher) {
        this.pluginAccessor = pluginAccessor;
        this.eventPublisher = eventPublisher;
    }

    private Iterable<NotificationFilter> buildEnabledNotificationFilters() {
        List modules = Lists.transform((List)this.pluginAccessor.getEnabledModuleDescriptorsByClass(NotificationFilterModuleDescriptor.class), (Function)new Function<NotificationFilterModuleDescriptor, NotificationFilter>(){

            public NotificationFilter apply(NotificationFilterModuleDescriptor input) {
                return (NotificationFilter)input.getModule();
            }
        });
        return Iterables.filter((Iterable)modules, (Predicate)Predicates.notNull());
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @PluginEventListener
    public void onPluginModuleEnabled(PluginModuleEnabledEvent event) {
        if (event.getModule() instanceof NotificationFilterModuleDescriptor) {
            this.enabledFilters.reset();
        }
    }

    @PluginEventListener
    public void onPluginModuleDisabled(PluginModuleDisabledEvent event) {
        if (event.getModule() instanceof NotificationFilterModuleDescriptor) {
            this.enabledFilters.reset();
        }
    }

    @Override
    public Iterable<NotificationRecipient> enhanceAndFilter(Iterable<NotificationRecipient> recipients, final NotificationFilter.Context context) {
        Iterable added = Iterables.concat(recipients, this.add(context));
        return Iterables.filter((Iterable)added, (Predicate)new Predicate<NotificationRecipient>(){

            public boolean apply(@Nullable NotificationRecipient input) {
                return !NotificationFilterManagerImpl.this.remove(input, context);
            }
        });
    }

    @Override
    public boolean filter(NotificationRecipient recipient, NotificationFilter.Context context) {
        return this.remove(recipient, null);
    }

    private Iterable<NotificationRecipient> add(NotificationFilter.Context context) {
        HashSet allRecipients = Sets.newHashSet();
        for (NotificationFilter notificationFilter : this.enabledNotificationFilters()) {
            try {
                Iterable recipients = notificationFilter.add(context);
                if (recipients == null) continue;
                Iterables.addAll((Collection)allRecipients, (Iterable)recipients);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("Added extra recipients via plugin '%s'", notificationFilter.getClass().getName()));
            }
            catch (RuntimeException e) {
                log.error((Object)String.format("Ignoring notification filter of type '%s' because of '%s'", notificationFilter.getClass().getName(), e.getMessage()));
            }
        }
        return allRecipients;
    }

    private boolean remove(NotificationRecipient recipient, NotificationFilter.Context context) {
        for (NotificationFilter notificationFilter : this.enabledNotificationFilters()) {
            try {
                if (!notificationFilter.remove(recipient, context)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Removed '%s' as a notification recipient via plugin '%s'", recipient, notificationFilter.getClass().getName()));
                }
                return true;
            }
            catch (RuntimeException e) {
                log.error((Object)String.format("Ignoring notification filter of type '%s' because of '%s'", notificationFilter.getClass().getName(), e.getMessage()));
            }
        }
        return false;
    }

    @VisibleForTesting
    Iterable<NotificationFilter> enabledNotificationFilters() {
        return (Iterable)this.enabledFilters.get();
    }
}

