/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.mail.JiraMailQueueUtils;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.velocity.exception.VelocityException;

public class RenderingMailQueueItem
extends SingleMailQueueItem {
    private static final Logger log = Logger.getLogger(RenderingMailQueueItem.class);
    private final String subjectTemplatePath;
    private final String bodyTemplatePath;
    private final Map<String, Object> params;

    public RenderingMailQueueItem(Email email, String subjectTemplatePath, String bodyTemplatePath, Map<String, Object> params) {
        super(email);
        this.subjectTemplatePath = subjectTemplatePath;
        this.bodyTemplatePath = bodyTemplatePath;
        this.params = params;
    }

    public String getSubject() {
        I18nHelper i18n = ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
        Map<String, Object> contextParams = JiraMailQueueUtils.getContextParamsBody(this.params);
        contextParams.put("i18n", i18n);
        try {
            return this.renderEmailSubject(contextParams);
        }
        catch (VelocityException e) {
            log.error((Object)"Could not determine e-mail subject", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void send() throws MailException {
        Map<String, Object> contextParams = JiraMailQueueUtils.getContextParamsBody(this.params);
        try {
            String subject = this.renderEmailSubject(contextParams);
            String body = this.renderEmailBody(this.getEmail(), contextParams);
            this.getEmail().setSubject(subject);
            this.getEmail().setBody(body);
        }
        catch (VelocityException e) {
            throw new RuntimeException(e);
        }
        super.send();
    }

    private String renderEmailSubject(Map<String, Object> contextParams) {
        return this.getTemplatingEngine().render(TemplateSources.file((String)this.subjectTemplatePath)).applying(contextParams).asPlainText();
    }

    private String renderEmailBody(Email message, Map<String, Object> contextParams) {
        if (message.getMimeType().equals("text/html")) {
            return this.getTemplatingEngine().render(TemplateSources.file((String)this.bodyTemplatePath)).applying(contextParams).asHtml();
        }
        return this.getTemplatingEngine().render(TemplateSources.file((String)this.bodyTemplatePath)).applying(contextParams).asPlainText();
    }

    @VisibleForTesting
    VelocityTemplatingEngine getTemplatingEngine() {
        return (VelocityTemplatingEngine)ComponentAccessor.getComponent(VelocityTemplatingEngine.class);
    }
}

