/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.util.JqlIssueKeySupport;
import com.atlassian.jira.jql.util.JqlIssueSupport;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

@InjectableComponent
public class IssueParentValidator
implements ClauseValidator {
    private static final Logger log = Logger.getLogger(IssueParentValidator.class);
    private final JqlOperandResolver operandResolver;
    private final SupportedOperatorsValidator supportedOperatorsValidator;
    private final JqlIssueKeySupport issueKeySupport;
    private final JqlIssueSupport issueSupport;
    private final I18nHelper.BeanFactory i18nFactory;
    private final SubTaskManager subTaskManager;

    IssueParentValidator(JqlOperandResolver operandResolver, JqlIssueKeySupport issueKeySupport, JqlIssueSupport issueSupport, I18nHelper.BeanFactory i18nFactory, SupportedOperatorsValidator supportedOperatorsValidator, SubTaskManager subTaskManager) {
        this.issueSupport = issueSupport;
        this.issueKeySupport = (JqlIssueKeySupport)Assertions.notNull((String)"issueKeySupport", (Object)issueKeySupport);
        this.i18nFactory = (I18nHelper.BeanFactory)Assertions.notNull((String)"i18nFactory", (Object)i18nFactory);
        this.supportedOperatorsValidator = (SupportedOperatorsValidator)Assertions.notNull((String)"supportedOperatorsValidator", (Object)supportedOperatorsValidator);
        this.operandResolver = (JqlOperandResolver)Assertions.notNull((String)"operandResolver", (Object)operandResolver);
        this.subTaskManager = (SubTaskManager)Assertions.notNull((String)"subTaskManager", (Object)subTaskManager);
    }

    public IssueParentValidator(JqlOperandResolver operandResolver, JqlIssueKeySupport issueKeySupport, JqlIssueSupport issueSupport, I18nHelper.BeanFactory i18nFactory, SubTaskManager subTaskManager) {
        this(operandResolver, issueKeySupport, issueSupport, i18nFactory, new SupportedOperatorsValidator(new Collection[]{OperatorClasses.EQUALITY_OPERATORS}), subTaskManager);
    }

    public MessageSet validate(User searcher, TerminalClause terminalClause) {
        Operand operand;
        List values;
        Assertions.notNull((String)"terminalClause", (Object)terminalClause);
        if (!this.subTaskManager.isSubTasksEnabled()) {
            MessageSetImpl messageSet = new MessageSetImpl();
            I18nHelper i18n = this.i18nFactory.getInstance(searcher);
            messageSet.addErrorMessage(i18n.getText("jira.jql.clause.issue.parent.subtasks.disabled", terminalClause.getName()));
            return messageSet;
        }
        MessageSet messages = this.supportedOperatorsValidator.validate(searcher, terminalClause);
        if (!messages.hasAnyErrors() && (values = this.operandResolver.getValues(searcher, operand = terminalClause.getOperand(), terminalClause)) != null) {
            for (QueryLiteral value : values) {
                if (value.getLongValue() != null) {
                    this.validateIssueId(messages, value.getLongValue(), searcher, terminalClause, value.getSourceOperand());
                    continue;
                }
                if (value.getStringValue() != null) {
                    this.validateIssueKey(messages, value.getStringValue(), searcher, terminalClause, value.getSourceOperand());
                    continue;
                }
                if (value.isEmpty()) {
                    this.validateEmptyOperand(messages, searcher, terminalClause, value.getSourceOperand());
                    continue;
                }
                log.error((Object)("Unknown QueryLiteral: " + value.toString()));
            }
        }
        return messages;
    }

    private MessageSet validateEmptyOperand(MessageSet messageSet, User searcher, TerminalClause clause, Operand operand) {
        I18nHelper i18n = this.i18nFactory.getInstance(searcher);
        if (!this.operandResolver.isFunctionOperand(operand)) {
            messageSet.addErrorMessage(i18n.getText("jira.jql.clause.field.does.not.support.empty", clause.getName()));
        } else {
            messageSet.addErrorMessage(i18n.getText("jira.jql.clause.field.does.not.support.empty.from.func", clause.getName(), operand.getName()));
        }
        return messageSet;
    }

    private boolean validateIssueId(MessageSet messages, Long issueId, User searcher, TerminalClause clause, Operand operand) {
        Issue issue = this.issueSupport.getIssue(issueId.longValue(), searcher);
        if (issue == null) {
            I18nHelper i18n = this.i18nFactory.getInstance(searcher);
            if (!this.operandResolver.isFunctionOperand(operand)) {
                messages.addErrorMessage(i18n.getText("jira.jql.clause.no.value.for.id", clause.getName(), issueId.toString()));
            } else {
                messages.addErrorMessage(i18n.getText("jira.jql.clause.no.value.for.name.from.function", operand.getName(), clause.getName()));
            }
            return false;
        }
        return true;
    }

    private boolean validateIssueKey(MessageSet messages, String key, User searcher, TerminalClause clause, Operand operand) {
        List issues = this.issueSupport.getIssues(key, searcher);
        if (issues.isEmpty()) {
            I18nHelper i18n = this.i18nFactory.getInstance(searcher);
            boolean validIssueKey = this.issueKeySupport.isValidIssueKey(key);
            if (!this.operandResolver.isFunctionOperand(operand)) {
                if (validIssueKey) {
                    messages.addErrorMessage(i18n.getText("jira.jql.clause.issuekey.noissue", key, clause.getName()));
                } else {
                    messages.addErrorMessage(i18n.getText("jira.jql.clause.issuekey.invalidissuekey", key, clause.getName()));
                }
            } else if (validIssueKey) {
                messages.addErrorMessage(i18n.getText("jira.jql.clause.issuekey.noissue.from.func", operand.getName(), clause.getName()));
            } else {
                messages.addErrorMessage(i18n.getText("jira.jql.clause.issuekey.invalidissuekey.from.func", operand.getName(), clause.getName()));
            }
            return false;
        }
        return true;
    }
}

