/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.index.IndexedChangeHistoryFieldManager;
import com.atlassian.jira.jql.operand.PredicateOperandResolver;
import com.atlassian.jira.jql.operand.registry.JqlFunctionHandlerRegistry;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.jql.validator.HistoryFieldValueValidator;
import com.atlassian.jira.jql.validator.HistoryPredicateValidator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.query.clause.ChangedClause;

public class ChangedClauseValidator {
    private final IndexedChangeHistoryFieldManager indexedChangeHistoryFieldManager;
    private final PredicateOperandResolver predicateOperandResolver;
    private final JqlDateSupport jqlDateSupport;
    private final HistoryPredicateValidator historyPredicateValidator;
    private final JiraAuthenticationContext authContext;
    private final HistoryFieldValueValidator historyFieldValueValidator;
    private final JqlFunctionHandlerRegistry registry;

    public ChangedClauseValidator(IndexedChangeHistoryFieldManager indexedChangeHistoryFieldManager, PredicateOperandResolver predicateOperandResolver, JqlDateSupport jqlDateSupport, JiraAuthenticationContext authContext, HistoryFieldValueValidator historyFieldValueValidator, JqlFunctionHandlerRegistry registry) {
        this.indexedChangeHistoryFieldManager = indexedChangeHistoryFieldManager;
        this.predicateOperandResolver = predicateOperandResolver;
        this.jqlDateSupport = jqlDateSupport;
        this.authContext = authContext;
        this.historyFieldValueValidator = historyFieldValueValidator;
        this.registry = registry;
        this.historyPredicateValidator = this.getHistoryPredicateValidator();
    }

    private HistoryPredicateValidator getHistoryPredicateValidator() {
        return new HistoryPredicateValidator(this.authContext, this.predicateOperandResolver, this.jqlDateSupport, this.historyFieldValueValidator, this.registry);
    }

    public MessageSet validate(User searcher, ChangedClause clause) {
        MessageSetImpl messageSet = new MessageSetImpl();
        this.validateField(searcher, clause.getField(), (MessageSet)messageSet);
        if (clause.getPredicate() != null) {
            messageSet.addMessageSet(this.historyPredicateValidator.validate(searcher, clause, clause.getPredicate()));
        }
        return messageSet;
    }

    private void validateField(User searcher, String fieldName, MessageSet messages) {
        if (!this.indexedChangeHistoryFieldManager.getIndexedChangeHistoryFieldNames().contains(fieldName.toLowerCase())) {
            messages.addErrorMessage(this.getI18n(searcher).getText("jira.jql.history.field.not.supported", fieldName));
        }
    }

    I18nHelper getI18n(User user) {
        return new I18nBean(user);
    }
}

